#The following R packages are needed:
#tidyverse for general data processing
#viridis for plotting colors

require(tidyverse)
require(viridis)

#tested with R version 3.5.1 (2018-07-02)
#tidyverse 1.2.1
#viridis 0.5.1



wash_out_df <- readr::read_csv('Supplementary_Figure_2.1_source_data.csv')

ggplot(wash_out_df, aes(factor(treatment, levels = c('Untreated', '20 min incubation', 'Wash out  + 60 min')), per_motile, color = donor_pool, shape=drug)) +
  geom_jitter(size = 3, width = 0.1, alpha = 0.8) +
  scale_y_continuous(breaks = seq(0,100, 20), limits = c(-10,100)) +
  scale_shape(name = '') +
  scale_color_manual(name = '', values = viridis::viridis(4)[1:3]) +
  labs(y = '% Total Motility', x = '') +
  theme(
    panel.grid.minor = element_blank(),
    axis.text.x = element_text(angle = 30, hjust = 1)
)
