#Please note: no compound information available in this data. Unblinding was done by Calibr after dose response experiments have been performed

require(tidyverse)

#tested with R version 3.5.1 (2018-07-02)
#tidyverse 1.2.1




#load acrosome data, which contains raw counts and well ratios (% events); please setup path to csv file
acrosome_df <- read_csv('supplementary_file_2.csv') %>% 
  print()

#classifiy wells, where staining might have failed or with very low event counts
acrosome_classified <- acrosome_df %>% 
  select(-Count) %>%
  spread(Population, ratio) %>% 
  mutate(`Pi+` = `Pi+_PNA-` + `Pi+_PNA+`,
         `PNA+` = `Pi+_PNA+` + `Pi-_PNA+`, 
         flag = ifelse(`Pi+_PNA+` < 5 | `Pi+` < 20 | ParentCount < 200, 'failed', 'ok')) %>%
  gather(Population, ratio, -x, -y, -plate, -well_number, -ParentCount, -plate, -flag, -cpd_type, -gate_frame, -fl1_gate, -fl3_gate) %>%
  #classify acrosome controls (Negative Control: DMSO only, Positive Control: A23187 ionophore)
  mutate(facs_type = ifelse(well_number %in% c('I23', 'J23', 'K23', 'L23'), 'Negative Control',
                            ifelse(well_number %in% c('A23', 'B23', 'C23', 'D23', 'P23', 'O23', 'M23', 'N23'), 'Positive Control', 'Compound'))) %>% 
  #remove remaining pristimerin wells
  filter(y != '24') %>% 
  print()

ggplot(acrosome_classified %>% filter(Population == 'Pi-_PNA+', flag == 'ok'),
       aes(factor(facs_type, levels = c('Compound', 'Positive Control', 'Negative Control'),
                  labels = c('Compounds', 'Positive Controls', 'Negative Controls')), ratio))+ 
  #note: geom_jitter improves visualization by seperating dots, but makes plots look slightly different each time
  geom_jitter(size = 1, alpha = 0.4) +
  geom_hline(yintercept = 0, alpha = 0.7) +
  labs(x = '', y = '% Events',
       title = 'ReFRAME library (10,122 cpds)',
       subtitle = 'Acrosome reacting Live (Pi- PNA+)')+
  scale_y_continuous(breaks = seq(0,100,20), limits = c(-1,100)) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    legend.position = 'none',
    legend.text = element_text(size =8)
  )

ggplot(acrosome_classified %>% filter(Population == 'Pi+_PNA+', flag == 'ok'),
       aes(factor(facs_type, levels = c('Compound', 'Positive Control', 'Negative Control'),
                  labels = c('Compounds', 'Positive Controls', 'Negative Controls')), ratio))+ 
  #note: geom_jitter improves visualization by seperating dots, but makes plots look slightly different each time
  geom_jitter(size = 1, alpha = 0.4) +
  geom_hline(yintercept = 0, alpha = 0.7) +
  labs(x = '', y = '% Events',
       title = 'ReFRAME library (10,122 cpds)',
       subtitle = 'Acrosome reacting Dead (Pi+ PNA+)')+
  scale_y_continuous(breaks = seq(0,100,20), limits = c(-1,100)) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    legend.position = 'none',
    legend.text = element_text(size =8)
  )

ggplot(acrosome_classified %>% filter(Population == 'Pi+_PNA-', flag == 'ok'),
       aes(factor(facs_type, levels = c('Compound', 'Positive Control', 'Negative Control'),
                  labels = c('Compounds', 'Positive Controls', 'Negative Controls')), ratio))+ 
  #note: geom_jitter improves visualization by seperating dots, but makes plots look slightly different each time
  geom_jitter(size = 1, alpha = 0.4) +
  geom_hline(yintercept = 0, alpha = 0.7) +
  labs(x = '', y = '% Events',
       title = 'ReFRAME library (10,122 cpds)',
       subtitle = 'No Acrosome reaction Dead (Pi+ PNA-)')+
  scale_y_continuous(breaks = seq(0,100,20), limits = c(-1,100)) +
  theme(
    panel.grid.major = element_blank(),
    panel.grid.minor = element_blank(),
    legend.position = 'none',
    legend.text = element_text(size =8)
  )


acrosome_classified %>% filter(flag == 'ok', Population == 'Pi-_PNA+', ratio > 15) %>% arrange(ratio) %>% summarize(hits = length(well_number)) %>% print()
