function [resizedMat, centerEvts_resized] = stretchEvts(mat, centerEvts)


DIST_EVTS_S = [1.3, 0.55, 0.97, 0.4] / 0.55;

centerEvts_resized(1) = 1;
resizedMat            = mat(:,1);  % start with very first column
for w = 1:numel(DIST_EVTS_S)
    % start with the second column to resize
    currWin = mat(:, centerEvts(w)+1 : centerEvts(w+1));
    numcols = round(size(currWin,2) * DIST_EVTS_S(w));
    M = imresize(currWin, [size(currWin,1) numcols]);
    resizedMat = [resizedMat, M];
    if w<numel(DIST_EVTS_S)
        centerEvts_resized(w+1) = centerEvts_resized(w) + numcols;
    end
end