#!/usr/bin/python3
## This file was made to be used in combination with the template_count_within_distance.vmd file.

import sys
from subprocess import call
import shlex
import re
import os

# getting the script location
here = os.path.dirname(__file__)
filename = "template_count_selection.vmd"
path = os.path.join(here, filename)

# reading the template file
with open(path, "r") as f:
    read_data = f.read()

# getting all the input files and selection
error1 = "\n### ERROR ###\nPlease specify a gro, xtc, step, output_file and a selection. It is also possible to not specify the selection in the command line, but to add a selectio.inp file in the same folder.\n"
try:
    gro = sys.argv[1]
    xtc = sys.argv[2]
    step = sys.argv[3]
    outfile = sys.argv[4]
except IndexError:
    print(error1)
    sys.exit()
try:
    with open("selection.inp", "r") as f:
        selection = f.read().strip()
    print("selection.inp was used as the selection descriptor.")
except FileNotFoundError:
    try:
        selection = sys.argv[5]
    except IndexError:
        print(error1)
        sys.exit(1)

# replacing all the @TAGS with the right files and selection
template_indicators = ["@IN_GRO", "@IN_XTC", "@XTCSTEPSIZE", "@OUTFILE", "@SELECTION"]
keywords = [gro, xtc, step, outfile, selection]
replacement_tuples = zip(template_indicators, keywords)
for tag, keyword in replacement_tuples:
    read_data = re.sub(tag, keyword, read_data)
write_data = read_data

# writing the generated count selection.vmd
with open("generated_count_selection.vmd", "w") as f:
    f.write(write_data)
    

# running the filled in count_within_file in vmd
command = "vmd -e generated_count_selection.vmd -dispdev text"
call(shlex.split(command))
