clear;clc;
Path = pwd; % Change directory to the folder Figure3B_Bootstrap_OT
File = 'Figure3B_Bootstrap_OT.csv';
cd(Path);
Data = readtable(File);
Revenge(:,1) = Data.OT(strcmp(Data.condition,'Revenge')&strcmp(Data.Time,'OT1')); 
Revenge(:,2) = Data.OT(strcmp(Data.condition,'Revenge')&strcmp(Data.Time,'OT2')); 
Revenge(:,3) = Data.OT(strcmp(Data.condition,'Revenge')&strcmp(Data.Time,'OT3')); 
Control(:,1) = Data.OT(strcmp(Data.condition,'Control')&strcmp(Data.Time,'OT1')); 
Control(:,2) = Data.OT(strcmp(Data.condition,'Control')&strcmp(Data.Time,'OT2')); 
Control(:,3) = Data.OT(strcmp(Data.condition,'Control')&strcmp(Data.Time,'OT3')); 
%%
%OT2 minus OT1 & OT2 minus OT3
for l = 1:1000
    for r = 1:length(Revenge)
        Select_revenge = randperm(length(Revenge));
        Samp_revenge(r,1) = Revenge(Select_revenge(1,1),2)-Revenge(Select_revenge(1,1),1);
        Samp_revenge(r,2) = Revenge(Select_revenge(1,1),2)-Revenge(Select_revenge(1,1),3);
    end
    Boot_revenge(l,:) = mean(Samp_revenge,1);
    Boot_revenge_s(l,1) = sqrt(Boot_revenge(l,1)^2+Boot_revenge(l,2)^2);
    
    for c = 1:length(Control)
        Select_control = randperm(length(Control));
        Samp_control(c,1) = Control(Select_control(1,1),2)-Control(Select_control(1,1),1);
        Samp_control(c,2) = Control(Select_control(1,1),2)-Control(Select_control(1,1),3);
    end
    Boot_control(l,:) = mean(Samp_control,1);
    Boot_control_s(l,1) = sqrt(Boot_control(l,1)^2+Boot_control(l,2)^2);
    
    Boot_revenge_control(l,1) = sqrt(Boot_revenge(l,1)^2+Boot_revenge(l,2)^2)-sqrt(Boot_control(l,1)^2+Boot_control(l,2)^2);
end
%%
% Mean distance and 95%CI
Sort_distance = sort(Boot_revenge_control);
fprintf('Mean distance between Revenge and Control groups is %.2f, and 95CI is %.2f and %.2f', mean(Sort_distance), Sort_distance(25,1),Sort_distance(975,1));
%%
% Draw figures
s1 = 36;
c1 = [241 108 103];
scatter(Boot_revenge(:,1),Boot_revenge(:,2),s1,c1/255);
hold on;
s2 = 36;
c2 = [110 158 232];
scatter(Boot_control(:,1),Boot_control(:,2),s2,c2/255);
axis([0,80,0,80]);
axis equal;
set(gca,'XTick',0:20:80);
set(gca,'YTick',0:20:80);
set(gca,'tickdir','out');
set(gca,'xcolor',[180,180,180]/255)
set(gca,'ycolor',[180,180,180]/255)
set(gca,'LineWidth',1.5)
set(gca,'FontName','Times New Roman','FontSize',14,'FontWeight','Bold');
xlabel('OT Time 2 vs Time 1 (pg/ml)','FontName','Times New Roman','FontSize',14,'FontWeight','Bold','Color','black');
ylabel('OT Time 2 vs Time 3 (pg/ml)','FontName','Times New Roman','FontSize',14,'FontWeight','Bold','Color','black');
h = legend('Revenge','Control','location','southeast');
set(h,'Box','off');