function gen_fig3()
%GEN_FIG3

matfile = 'retrieval_diff.mat';

load(matfile, ...
    'diff_res');

subj = 'ec109'; %S5

% subject 5, channel 2 -- select subject, channel and frequency of interest
s = 5; c = 2; f = 21;

% for indiviual electrode example (across trials

fig('FontSize', 16, ...
    'Font', 'Arial', ...
    'border','on', ...
    'units', 'centimeters', ...
    'width', 16, ...
    'height', 8);

norm = true;

a1 = squeeze(diff_res(s).alpha1(:,c,f)); % original pre
a2 = squeeze(diff_res(s).alpha2(:,c,f)); % updated post
a3 = squeeze(diff_res(s).alpha3(:,c,f)); % original post
a4 = squeeze(diff_res(s).alpha4(:,c,f)); % updated pre

[n1, edg1] = histcounts(a1,linspace(-pi,pi,11));
[n2, edg2] = histcounts(a2,linspace(-pi,pi,11));
[n3, edg3] = histcounts(a3,linspace(-pi,pi,11));
[n4, edg4] = histcounts(a4,linspace(-pi,pi,11));

if norm
    n1 = n1/sum(n1);
    n2 = n2/sum(n2);
    n3 = n3/sum(n3);
    n4 = n4/sum(n4);
end

original_color = [169 83 255]/255;
updated_color = [33 176 80]/255;

orig_cols = gen_shades(original_color, 5);
updated_cols = gen_shades(updated_color, 5);

subplot(1,2,1);
hpo_pre = polarhistogram('BinEdges', edg1, 'BinCounts', n1);
hold on;
hpo_post =  polarhistogram('BinEdges', edg3, 'BinCounts', n3);

hpo_pre.FaceColor = orig_cols(1,:);
hpo_pre.EdgeColor = orig_cols(1,:);
hpo_pre.FaceAlpha = .8;
hpo_pre.EdgeAlpha = 1;

hpo_post.FaceColor = orig_cols(3,:);
hpo_post.EdgeColor = orig_cols(3,:);
hpo_post.FaceAlpha = .8;
hpo_post.EdgeAlpha = 1;

uistack(hpo_pre, 'top');

hleg = legend([hpo_pre, hpo_post], {'Pre','Post'});
hleg.Box = 'off';
hleg.Position = [0.3317 0.7619 0.1564 0.1784];

rl = get(gca,'RLim');
set(gca, ...
    'ThetaTick',[0 90 180 270], ...
    'ThetaTickLabel',{'0','\pi/2','\pi','-\pi/2'}, ...
    'GridAlpha', .2, ...
    'RTickLabel', '', ...
    'FontSize',16);

subplot(1,2,2);
hpu_pre = polarhistogram('BinEdges', edg4, 'BinCounts', n4);
hold on;
hpu_post =  polarhistogram('BinEdges', edg2, 'BinCounts', n2);

hpu_pre.FaceColor = updated_cols(1,:);
hpu_pre.EdgeColor = updated_cols(1,:);
hpu_pre.FaceAlpha = .8;
hpu_pre.EdgeAlpha = 1;

hpu_post.FaceColor = updated_cols(3,:);
hpu_post.EdgeColor = updated_cols(3,:);
hpu_post.FaceAlpha = .8;
hpu_post.EdgeAlpha = 1;

uistack(hpu_post, 'top');

hleg = legend([hpu_pre, hpu_post], {'Pre','Post'});
% objhl = findobj(objh, 'type', 'patch');
% set(objhl, 'Markersize', 12);
hleg.Box = 'off';
hleg.Position =  [0.7789 0.7619 0.1564 0.1784];

rl = get(gca,'RLim');

set(gca, ...
    'ThetaTick',[0 90 180 270], ...
    'ThetaTickLabel',{'0','\pi/2','\pi','-\pi/2'}, ...
    'GridAlpha', .2, ...
    'RTickLabel', '', ...
    'FontSize',16);

% and now look at the effect across electrodes and subjects
resmat = 'retrieval.mat';

post_window = 80:120;
pre_window = -420:-380;
[mu_pre_c1, mu_post_c1, mu_pre_c2, mu_post_c2] = pref_angle_plot( ...
    resmat, pre_window, post_window);

fig('FontSize', 16, ...
    'Font', 'Arial', ...
    'border','on', ...
    'units', 'centimeters', ...
    'width', 16, ...
    'height', 8);

norm = false;

a1 = squeeze(mu_pre_c1(:,21));
a2 = squeeze(mu_post_c2(:,21));
a3 = squeeze(mu_post_c1(:,21));
a4 = squeeze(mu_pre_c2(:,21));

[n1, edg1] = histcounts(a1,linspace(-pi,pi,12));
[n2, edg2] = histcounts(a2,linspace(-pi,pi,12));
[n3, edg3] = histcounts(a3,linspace(-pi,pi,12));
[n4, edg4] = histcounts(a4,linspace(-pi,pi,12));

if norm
    n1 = n1/sum(n1);
    n2 = n2/sum(n2);
    n3 = n3/sum(n3);
    n4 = n4/sum(n4);
end

subplot(1,2,1);
hpo_pre = polarhistogram('BinEdges', edg1, 'BinCounts', n1);
hold on;
hpo_post =  polarhistogram('BinEdges', edg3, 'BinCounts', n3);

hpo_pre.FaceColor = orig_cols(1,:);
hpo_pre.EdgeColor = orig_cols(1,:);
hpo_pre.FaceAlpha = .8;
hpo_pre.EdgeAlpha = 1;

hpo_post.FaceColor = orig_cols(3,:);
hpo_post.EdgeColor = orig_cols(3,:);
hpo_post.FaceAlpha = .8;
hpo_post.EdgeAlpha = 1;

uistack(hpo_pre, 'top');

hleg = legend([hpo_pre, hpo_post], {'Pre','Post'});
hleg.Box = 'off';
hleg.Position = [0.3317 0.7619 0.1564 0.1784];

rl = get(gca,'RLim');
set(gca, ...
    'ThetaTick',[0 90 180 270], ...
    'ThetaTickLabel',{'0','\pi/2','\pi','-\pi/2'}, ...
    'GridAlpha', .2, ...
    'RTick', [min(rl):2:(max(rl)+2)], ...
    'RTickLabel', '', ...
    'FontSize',16);

subplot(1,2,2);
hpu_pre = polarhistogram('BinEdges', edg4, 'BinCounts', n4);
hold on;
hpu_post =  polarhistogram('BinEdges', edg2, 'BinCounts', n2);

hpu_pre.FaceColor = updated_cols(1,:);
hpu_pre.EdgeColor = updated_cols(1,:);
hpu_pre.FaceAlpha = .8;
hpu_pre.EdgeAlpha = 1;

hpu_post.FaceColor = updated_cols(3,:);
hpu_post.EdgeColor = updated_cols(3,:);
hpu_post.FaceAlpha = .8;
hpu_post.EdgeAlpha = 1;

uistack(hpu_post, 'top');

hleg = legend([hpu_pre, hpu_post], {'Pre','Post'});
% objhl = findobj(objh, 'type', 'patch');
% set(objhl, 'Markersize', 12);
hleg.Box = 'off';
hleg.Position =  [0.7789 0.7619 0.1564 0.1784];

rl = get(gca,'RLim');
set(gca, ...
    'ThetaTick',[0 90 180 270], ...
    'ThetaTickLabel',{'0','\pi/2','\pi','-\pi/2'}, ...
    'GridAlpha', .2, ...
    'RTick', [min(rl):2:(max(rl)+2)], ...
    'RTickLabel', '', ...
    'FontSize',16);

[F_z, stat, p_z] = gen_pref_angle_plot(a1, ...
    a2, ...
    original_color, ...
    updated_color, ...
    subj, ...
    {'Original (Pre)','Updated (Post)'});


end


function colors = gen_shades(base_color, n)
% generates n colors (shades) around the base color

colors = [];
for i = 1:n
    colors(i,:) = (1-(i-1)*.2)*base_color;
end

end
