function [F_z, stat, p_z] = gen_pref_angle_plot(mu_pre_original, mu_post_updated, ...
    color_pre, color_post, labels)
%
r1 = circ_r(mu_pre_original);
thetahat1 = circ_mean(mu_pre_original);
theta1_ci = circ_confmean(mu_pre_original);

r2 = circ_r(mu_post_updated);
thetahat2 = circ_mean(mu_post_updated);
theta2_ci = circ_confmean(mu_post_updated);

x = -pi:.001:pi;
y = cos(x);

x1 = linspace(thetahat1-theta1_ci,thetahat1+theta1_ci,100);
x1 = wrapToPi(x1);
x1p = wrapToPi(mu_pre_original);
y1p = cos(mu_pre_original) + rand(size(mu_pre_original))-.5;

y1 = cos(x1);

x2 = linspace(thetahat2-theta2_ci,thetahat2+theta2_ci,100);
x2 = wrapToPi(x2);
y2 = cos(x2);
x2p = wrapToPi(mu_post_updated);
y2p = cos(mu_post_updated) + rand(size(mu_post_updated))-.5;


fig('units','centimeters','width',12,'Font','Arial','FontSize',14);

set(gcf,'Position',[19.7203   16.6511   13.2997   10.9361]);
axis square

% subplot(3,1,1);
hl = plot(x, y);
set(gca,'Position',[0.0881 0.2 0.8000 0.8]);

hl.LineWidth = 2; hl.Color = 'k';
hold on;

hp1 = plot(x1p, y1p, 'o');
hp1.MarkerFaceColor = [1 1 1];
hp1.MarkerEdgeColor = color_pre;
hp1.MarkerSize = 3;

hp2 = plot(x2p, y2p, 'o');
hp2.MarkerFaceColor = [1 1 1];
hp2.MarkerEdgeColor = color_post;
hp2.MarkerSize = 3;

if any(x1<=-pi/2 + .05)
hl1 = plot(x1(x1<=-pi/2 + .05), y1(x1<=-pi/2 + .05));
hl1.LineWidth = 6; hl1.Color = color_pre;
end

if any(x1>=-pi/2)
hl1 = plot(x1(x1>=-pi/2), y1(x1>=-pi/2));
hl1.LineWidth = 6; hl1.Color = color_pre;
end

if any(x2<=-pi/2 + .05)
hl2 = plot(x2(x2<=-pi/2 + .05), y2(x2<=-pi/2 + .05));
hl2.LineWidth = 6; hl2.Color = color_post;
end
if any(x2>=-pi/2)
hl2 = plot(x2(x2>=-pi/2), y2(x2>=-pi/2));
hl2.LineWidth = 6; hl2.Color = color_post;
end

if ~exist('hl2','var')
    hl2 = [];
end

if ~exist('hl1','var')
    hl1 = [];
end

set(gca,'YColor','none','FontSize',16,'XLim',[-pi pi], ...
    'XTick', [-pi 0 pi], ...
    'XTickLabel', {'-\pi','0','\pi'}, ...
    'box','off','LineWidth',2);
% text(-pi-.2, -1.35, '-\pi', 'FontSize', 16);
% text(-.1, -1.35, '0', 'FontSize', 16);
% text(pi-.1, -1.35, '\pi', 'FontSize', 16);

xlabel('Phase Angle (rad)');

hleg = legend([hl1 hl2], labels);
hleg.Box = 'off';
hleg.Position = [0.0172    0.8803    0.3794    0.0985];

% plot ITC (r bar)
ax2 = axes('Position', [0.8    0.7    0.15    0.2]);
hb1 = bar(ax2, 1, r1);
hold on
se1 = std(bootstrp(1000, @circ_r, mu_pre_original));
he1 = errorbar(ax2, 1, r1, se1);
hb1.FaceColor = color_pre;
hb1.EdgeColor = color_pre;
he1.Color = 'k';
he1.LineWidth = 2;

hb2 = bar(ax2, 2, r2);
se2 = std(bootstrp(1000, @circ_r, mu_post_updated));
he2 = errorbar(ax2, 2, r2, se2);
hb2.FaceColor = color_post;
hb2.EdgeColor = color_post;
he2.Color = 'k';
he2.LineWidth = 2;
set(gca,'box','off','XColor','none','Color','none','LineWidth',2);
ylabel('r');

% nonparametric test

null_stat = nan(1,10000);
for n = 1:10000
    a = mu_pre_original;
    b = mu_post_updated;
    
    for e = 1:length(a) % random flip within e
        if rand < .5
           a(e) = mu_post_updated(e);
           b(e) = mu_pre_original(e);
        end
    end
    
    [~, table] = circ_wwtest(a, b);
    null_stat(n) = table{2,5};
%     [~, ~, stat(n)] = circ_cmtest(a, b);   
end

[pval, table] = circ_wwtest(mu_pre_original, mu_post_updated);
stat = table{2,5}; %F
F_z = (stat-nanmean(null_stat))./nanstd(null_stat);

p_z = sum(null_stat>stat)/10000;