function [mu_pre_c1, mu_post_c1, mu_pre_c2, mu_post_c2] = pref_angle_plot( ...
    resmat, pre_window, post_window)

load(resmat, 'c1_res','c2_res');

% post_window = 80:120;
% pre_window = -420:-380;

pre_idx = ismember(c1_res(1).time, pre_window);
post_idx = ismember(c1_res(1).time, post_window);

mu_pre_c1 = get_mu(c1_res, pre_idx);
mu_post_c1 = get_mu(c1_res, post_idx);

mu_pre_c2 = get_mu(c2_res, pre_idx);
mu_post_c2 = get_mu(c2_res, post_idx);

% figure;
% obj_pre =CircHist(mu_pre_c1(:,21)*180/pi, 15);
%
% figure;
% obj_post =CircHist(mu_post_c1(:,21)*180/pi, 15);

% figure;
% plot(circ_mean(mu_pre_c1));
% hold on; plot(circ_mean(mu_post_c1));
% hl = line([21 21],get(gca,'YLim'));
% hl.Color = 'k'; hl.LineStyle = '--';
%
% legend({'pre','post','5 Hz'});

end

function mu = get_mu(res, t_idx)

mu = [];
for s = 1:length(res)
    
    s_c = nan(size(res(s).mu,1), size(res(s).mu,2));
    for f = 1:size(res(s).mu,2)
        s_c(:,f) = squeeze(circ_mean(res(s).mu(:,f,t_idx), ...
            [], ...
            3));
    end
    mu = cat(1, mu, s_c);  
end

end
