function gen_fig4()
%gen_fig4()

% original vs. repeated
original_color = [169 83 255]/255;
updated_color = [5 178 65]/255;

rem_color = [1 0 0];
for_color = [0 0 1];

%% new plots

% loc2
matfile = 'updated_sme_pre.mat';
xtl = [-600 -400 -200 0];
pos_color = rem_color;
neg_color = for_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -750:2:50);
set(gca,'CLim',[-.1 .1]);

matfile = 'updated_sme_post.mat';
xtl = [0 200 400 600];
pos_color = rem_color;
neg_color = for_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -50:2:750);
set(gca,'CLim',[-.1 .1]);

% loc1
matfile = 'original_sme_pre.mat';
xtl = [-600 -400 -200 0];
pos_color = rem_color;
neg_color = for_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -750:2:50);
set(gca,'CLim',[-.1 .1]);

matfile = 'original_sme_post.mat';
xtl = [0 200 400 600];
pos_color = rem_color;
neg_color = for_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -50:2:750);
set(gca,'CLim',[-.1 .1]);

% interaction
matfile = 'sme_diff_pre.mat';
xtl =  [-600 -400 -200 0];
pos_color = updated_color;
neg_color = original_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -750:2:50);
set(gca,'CLim',[-.175 .175]);

matfile = 'sme_diff_post.mat';
xtl = [0 200 400 600];
pos_color = updated_color;
neg_color = original_color;
mscript_tfplot(matfile, xtl, pos_color, neg_color, true, .05, -50:2:750);
set(gca,'CLim',[-.175 .175]);

end

function cfg = mscript_tfplot(matfile, xtl, pos_color, neg_color, itcflag, alpha, time)
%MSCRIPT_TFPLOT plots a modified time-frequency plot

if ~exist('itcflag','var')
    itcflag = true;
end

% xtl = [-600 -400 -200 0];
% xtl = [0 200 400 600];

if itcflag
    load(matfile,'hc_itc_stats');
    stats = hc_itc_stats;
else
    load(matfile,'hc_pow_stats');
    stats = hc_pow_stats;
end

if ~exist('alpha','var')
    alpha = 0.05;
end
stats.mask = stats.prob < alpha;

if exist('time','var')
    stats.time = time;
end

cfg              = [];
cfg.title        = '';
cfg.maskstyle    = 'opacity';
cfg.maskalpha    = .2;
cfg.fontsize = 16;
cfg.zlim = 'maxabs';
cfg.channel      = stats.label{1};
cfg.interactive  = 'no';
cfg.maskparameter = 'mask';
cfg.verbose = 0;

fig('FontSize',16,'Font','Arial','border','on','units','centimeters','width',12);

ax1 = gca;

if ~isfield(stats, 'powspctrm')
    stats.powspctrm = stats.stat;
end
% 
freqs = 1:length(stats.freq);
of = stats.freq;
stats.freq = freqs;

cfg = ft_singleplotTFR(cfg, stats);

yt = [1:6:length(freqs) length(freqs)]; %get(gca,'YTick');
set(gca,'YTick',yt);
% set(gca,'YTickLabel', round(of(yt)));
set(gca,'YTickLabel',sprintf('%0.1f\n',of(yt)));
% lazy kludge
if ~exist('time','var')
    set(gca,'XTickLabel',xtl);
end
% set(gca,'CLim',[-.06 .06]);

ylabel('Frequency (Hz)');
xlabel('Time (ms)');

title('');
% hc = colorbar; ylabel(hc,'\DeltaITC');
cm = create_cluster_cmap(pos_color, neg_color);
colormap(cm);
hold on;
x = get(gca,'XTick');
x = x(xtl==0);
hl = line([x x], get(gca,'YLim'));
hl.Color = 'k'; hl.LineWidth=2; hl.LineStyle = '--';

end

function cmap = create_cluster_cmap(pos_color, neg_color)

x = [linspace(pos_color(1),1,64) linspace(1,neg_color(1),64)];
y = [linspace(pos_color(2),1,64) linspace(1,neg_color(2),64)];
z = [linspace(pos_color(3),1,64) linspace(1,neg_color(3),64)];

cmap = flipud([x; y; z]');

end