function gen_fig4_fs1()
%GEN_FIG4_FS1

% original vs. repeated

repeated_color = [0 0 0];
original_color = [169 83 255]/255;
updated_color = [5 178 65]/255;

rem_color = [1 0 0];
for_color = [0 0 1];

%% plots

% retrieval
xtl = [-600 -400 -200 0];
pos_color = original_color;
neg_color = updated_color;
mat_pre = 'retrieval';
time = -750:2:50;

h = fig('FontSize',16,'Font','Arial');
ax = itc_plot_wrapper(mat_pre, xtl, pos_color, neg_color, time);
set(gcf,'Position',[18.7060    1.6933   12.0915   24.4475]);

% sme
xtl = [0 200 400 600];
pos_color = rem_color;
neg_color = for_color;
mat_pre = 'sme';
time = -50:2:750;

h = fig('FontSize',16,'Font','Arial');
ax = itc_plot_wrapper(mat_pre, xtl, pos_color, neg_color, time);
set(gcf,'Position',[18.7060    1.6933   12.0915   24.4475]);

% novelty
xtl = [0 200 400 600];
pos_color = updated_color;
neg_color = repeated_color;
mat_pre = 'novelty';
time = -50:2:750;

h = fig('FontSize',16,'Font','Arial');
ax = itc_plot_wrapper(mat_pre, xtl, pos_color, neg_color, time);
set(gcf,'Position',[18.7060    1.6933   12.0915   24.4475]);


end

function ax = itc_plot_wrapper(mat_pre, xtl, pos_color, neg_color, time)

times = [100 200 400];
for t = 1:length(times)
    ax = subplot(3,1,t);
    matfile = [mat_pre '_' num2str(times(t)) '.mat'];
    
    [cfg, n1, n2] = mscript_tfplot_multi(matfile, ...
        ax, ...
        xtl, ...
        pos_color, ...
        neg_color, ...
        true, ...
        .1, ...
        time);
    
    if time(1) == -50 % post interval
        hl = plot([0 times(t)], [0.5 0.5], 'y-');
    elseif time(end) == 50
        hl = plot([-times(t) 0], [0.5 0.5], 'y-');
    end
    hl.LineWidth = 2;
    
    
     set(gca,'CLim',[-.05 .05]);
end

end