function [cfg, n1, n2] = mscript_tfplot_multi(matfile, ax, xtl, pos_color, neg_color, ...
    itcflag, alpha, time)
%MSCRIPT_TFPLOT plots a modified time-frequency plot

if ~exist('itcflag','var')
    itcflag = true;
end

% xtl = [-600 -400 -200 0];
% xtl = [0 200 400 600];

if itcflag
    load(matfile,'hc_itc_stats');
    stats = hc_itc_stats;
else
    load(matfile,'hc_pow_stats');
    stats = hc_pow_stats;
end


n1 = sum(stats.cfg.design(1,:)==1);
n2 = sum(stats.cfg.design(1,:)==2);

if ~exist('alpha','var')
    alpha = 0.05;
end
stats.mask = stats.prob < alpha;

if exist('time','var')
    stats.time = time;
end

cfg              = [];
cfg.title        = '';
cfg.maskstyle    = 'opacity';
cfg.maskalpha    = .2;
cfg.fontsize = 16;
cfg.zlim = 'maxabs';
cfg.channel      = stats.label{1};
cfg.interactive  = 'no';
cfg.maskparameter = 'mask';
cfg.verbose = 0;

if isempty(ax)
fig('FontSize',16,'Font','Arial','border','on','units','centimeters','width',12);
end

if ~isfield(stats, 'powspctrm')
    stats.powspctrm = stats.stat;
end
% 
freqs = 1:length(stats.freq);
of = stats.freq;
stats.freq = freqs;

cfg = ft_singleplotTFR(cfg, stats);

yt = [1:6:length(freqs) length(freqs)]; %get(gca,'YTick');
set(gca,'YTick',yt);
% set(gca,'YTickLabel', round(of(yt)));
set(gca,'YTickLabel',sprintf('%0.1f\n',of(yt)));
% lazy kludge
if ~exist('time','var')
    set(gca,'XTickLabel',xtl);
end
% set(gca,'CLim',[-.06 .06]);

ylabel('Frequency (Hz)');
xlabel('Time (ms)');

title('');
% hc = colorbar; ylabel(hc,'\DeltaITC');
cm = create_cluster_cmap(pos_color, neg_color);
colormap(cm);
hold on;
x = get(gca,'XTick');
x = x(xtl==0);
hl = line([x x], get(gca,'YLim'));
hl.Color = 'k'; hl.LineWidth=2; hl.LineStyle = '--';

end
