function gen_fig4_fs2()

repeated_color = [0 0 0];
original_color = [169 83 255]/255;
updated_color = [5 178 65]/255;

% mismatch object, SME
pos_color = [1 0 0];
neg_color = [0 0 1];

matfile = 'sme_stats.mat';

load(matfile, ...
     'stats', ...
     'stats_c1', ...
     'stats_c2');

[hl, hp] = plot_psd_reset(stats, ...
    stats_c1, ...
    stats_c2, ...
    pos_color, ...
    neg_color, ...
    {'Remembered','Forgotten'});
               
% % 
pos_color = original_color;
neg_color = updated_color;
matfile = 'retrieval_stats.mat';

load(matfile, ...
    'stats', ...
    'stats_c1', ...
    'stats_c2');

[hl, hp] = plot_psd_reset(stats, ...
    stats_c1, ...
    stats_c2, ...
    pos_color, ...
    neg_color, ...
    {'Original','Updated'});

% novelty

pos_color = updated_color;
neg_color = repeated_color;
matfile = 'novelty_stats.mat';

load(matfile, ...
    'stats', ...
    'stats_c1', ...
    'stats_c2');

[hl, hp] = plot_psd_reset(stats, ...
    stats_c1, ...
    stats_c2, ...
    pos_color, ...
    neg_color, ...
    {'Updated','Repeated'});
                        

end

function [hl, hp] = plot_psd_reset(stats, stats_c1, stats_c2, pos_color, neg_color, labels)
%PLOT_PSD_RESET generates differences in PSDs of erps

fig('FontSize', 16, ...
    'Font', 'Arial', ...
    'border', 'on', ...
    'units', 'centimeters', ...
    'width', 8);

x = stats.freq;

m1 = nanmean(squeeze(stats.cond1.z(:,:,stats.freq <= 50)));
e1 = nanstd(squeeze(stats.cond1.z(:,:,stats.freq <= 50)))/...
    sqrt(size(stats.cond1.z,1));

m2 = nanmean(squeeze(stats.cond2.z(:,:,stats.freq <= 50)));
e2 = nanstd(squeeze(stats.cond2.z(:,:,stats.freq <= 50)))/...
    sqrt(size(stats.cond2.z,1));

[hl, hp] = boundedline(x, ...
    m1, ...
    e1');

set(hp, 'FaceAlpha', .4);
set(hp, 'FaceColor', pos_color);
set(hl, 'LineWidth', 2);
set(hl, 'Color', pos_color);

holder(1) = hl;

hold on

[hl, hp] = boundedline(x, ...
    m2, ...
    e2');

holder(2) = hl;


set(hp, 'FaceAlpha', .4);
set(hp, 'FaceColor', neg_color);
set(hl, 'LineWidth', 2);
set(hl, 'Color', neg_color);
set(hl, 'LineStyle', '--');


xlabel('Frequency (Hz)');
ylabel('\DeltaPower (\muV^2/Hz)');

set(gca, 'XLim', [0 50], ...
    'XTick', [0:10:50]);

grid on

add_sig(stats, [.7 .7 .7]);
add_sig(stats_c1, pos_color);
add_sig(stats_c2, neg_color);

hl = legend(holder, labels);
hl.Box = 'off'; hl.Location = 'Best';    
    
function add_sig(stats, sig_color)


% pos clusters first
for p = 1:length(stats.posclusters)
    if stats.posclusters(p).prob < .05
        x_sig = find(stats.posclusterslabelmat == p);
        y_sig = max([m1(x_sig)+e1(x_sig), m2(x_sig)+e2(x_sig)])+.05*rand;
        hold on;
        h_sig = plot(stats.freq(x_sig), y_sig*ones(size(x_sig)));
        h_sig.Color = sig_color;
        h_sig.LineWidth = 2;
    elseif stats.posclusters(p).prob < .1
        x_sig = find(stats.posclusterslabelmat == p);
        y_sig = max([m1(x_sig)+e1(x_sig), m2(x_sig)+e2(x_sig)])+.05*rand;
        hold on;
        h_sig = plot(stats.freq(x_sig), y_sig*ones(size(x_sig)));
        h_sig.Color = 'k';
        h_sig.LineWidth = 2;
    end
end

% neg clusters
for p = 1:length(stats.negclusters)
    if stats.negclusters(p).prob < .05
        x_sig = find(stats.negclusterslabelmat == p);
        y_sig = min([m1(x_sig)-e1(x_sig), m2(x_sig)-e2(x_sig)])-.05*rand;
        hold on;
        h_sig = plot(stats.freq(x_sig), y_sig*ones(size(x_sig)));
        h_sig.Color = sig_color;
        h_sig.LineWidth = 2;
    elseif stats.negclusters(p).prob < .1
        x_sig = find(stats.negclusterslabelmat == p);
        y_sig = min([m1(x_sig)-e1(x_sig), m2(x_sig)-e2(x_sig)])-.05*rand;
        hold on;
        h_sig = plot(stats.freq(x_sig), y_sig*ones(size(x_sig)));
        h_sig.Color = 'k';
        h_sig.LineWidth = 2;
    end
end
    


end

end