function gen_fig6()
% gen_fig6

repeated_color = [0 0 0];
original_color = [169 83 255]/255;
updated_color = [5 178 65]/255;

rem_color = [1 0 0];
for_color = [0 0 1];

matfile = 'retrieval.mat';
load(matfile, 'stats_func');

[l, p] = condition_plot(stats_func, original_color, updated_color);
[l, p] = difference_plot(stats_func);

matfile = 'sme.mat';
load(matfile, 'stats_func');

[l, p] = condition_plot(stats_func, rem_color, for_color);
[l, p] = difference_plot(stats_func);

matfile = 'novelty';
load(matfile, 'stats_func');

[l, p] = condition_plot(stats_func, updated_color, repeated_color);
[l, p] = difference_plot(stats_func);

end

function [l, p] = condition_plot(stats, col1, col2)

x = stats.cond1.time; % high freq
y1 = nanmean(bootstrp(1000, @mean, squeeze(stats.cond1.z)));
e1 = nanstd(bootstrp(1000, @mean, squeeze(stats.cond1.z)));

y2 = nanmean(bootstrp(1000, @mean, squeeze(stats.cond2.z)));
e2 = nanstd(bootstrp(1000, @mean, squeeze(stats.cond2.z)));

fig('FontSize',12,'Font','Arial','border','on','units','centimeters','width',6);

[l, p] = boundedline(x, y1, e1, ...
    x, y2, e2, ...
    'cmap', [col1; col2]);

set(l(1),'LineWidth',2);
set(l(2),'LineWidth',2);

hl = line(get(gca,'XLim'), [0 0]);
hl.LineWidth = 2; hl.Color = [0 0 0]; hl.LineStyle = '--';
uistack(hl,'bottom');
uistack(hl,'top');

set(gca,'LineWidth',2,'XLim',[80 200],'XTick',[]);
% xlabel('Frequency (Hz)');
ylabel('MI_{Z}');

end


function [l, p] = difference_plot(stats)

x = stats.cond1.time; % high freq
y = nanmean(bootstrp(1000, @mean, squeeze(stats.cond1.z)-squeeze(stats.cond2.z)));
e = nanstd(bootstrp(1000, @mean, squeeze(stats.cond1.z)-squeeze(stats.cond2.z)));

fig('FontSize',12,'Font','Arial','border','on','units','centimeters','width',6);

[l, p] = boundedline(x, y, e, ...
    'cmap', [0 0 0]);

set(l(1),'LineWidth',2);

hl = line(get(gca,'XLim'), [0 0]);
hl.LineWidth = 2; hl.Color = [0 0 0]; hl.LineStyle = '--';
uistack(hl,'bottom');
uistack(hl,'top');

set(gca, 'LineWidth', 2, ...
    'XLim', [80 200], ...
    'XTick', 80:30:200, ...
    'YLim', [-max(abs(get(gca,'YLim'))) ...
    max(abs(get(gca,'YLim')))]);

xlabel('Frequency (Hz)');
ylabel('\Delta MI_{Z}');

% add sigline
hold on;

sig = squeeze(stats.prob<.05);
x_sig = x(sig);
y_sig = max(get(gca,'YTick'))*sig(sig);
hs = plot(x_sig, y_sig);
if ~isempty(hs)
    hs.Color = 'r'; hs.LineWidth = 2;
end
end
