probe<-read.csv('HuGene-1_0-st-v1.hg19.probe.csv',header=FALSE,colClasses=c('character','integer','integer','character','integer','character','integer'))

#############
structure<-read.csv('features_hg19_UTR_d.csv',header=FALSE,colClasses=c('character','integer','integer','character','integer','character','character','integer'))

structure<-rbind(structure,structure[nrow(structure),])
structure[nrow(structure),4]<-"FAKE"

#############

dat<-read.csv('ST1features_CTR_v_CLP1_SH2.csv',colClasses=c('numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','numeric','character'))


############# Keep expression values over 10.
############# Enter the right column names in the line below

dat<-dat[dat$KO_116>=10|dat$KO_118>=10|dat$KO_124>=10|dat$WT_126>=10|dat$WT_128>=10|dat$WT_132>=10,]



testWT<-vector(mode="numeric",length=nrow(structure))
testWTnorm<-vector(mode="numeric",length=nrow(structure))
testKO<-vector(mode="numeric",length=nrow(structure))
testKOnorm<-vector(mode="numeric",length=nrow(structure))
testFCnorm<-vector(mode="numeric",length=nrow(structure))
testP<-vector(mode="numeric",length=nrow(structure))
FCmed<-vector(mode="numeric",length=nrow(structure))
Refseq<-vector(mode="character",length=nrow(structure))
ex<-vector(mode="character",length=nrow(structure))
exnb<-vector(mode="integer",length=nrow(structure))
dir<-vector(mode="character",length=nrow(structure))




ini<-1
WTglob<-1
KOglob<-1
store<-NA
test<-0
adj<-1


nbr<-nrow(structure)-1



for (i in ini:(nbr+1)) {
	
	chr<-structure[i,1]
	start<-structure[i,2]
	end<-structure[i,3]
	
	temp<-probe[(probe[,1]==chr & probe[,2]>=start & probe[,3]<=end),c(4,7)]
	
	if (nrow(temp)>0){
		findWT<-as.matrix(log2(dat[match(temp[,1],dat$probename),c('WT_126','WT_128','WT_132')]))
		findKO<-as.matrix(log2(dat[match(temp[,1],dat$probename),c('KO_116','KO_118','KO_124')]))
		general<-cbind(structure[i,c(4,7,8,6)],feat_start=start,feat_end=end,probename=temp[,1],probe[match(temp[,1],probe[,4]),c(2,3)],2^findWT,2^findKO,row.names=NULL)
	
		if (test==0){
			store<-general
			test<-1
			}else{store<-rbind(store,general)}
		}	
	
	
	
	if (nrow(temp)>=2|i==(nbr+1)) {
		
		print(i)		
		if (length(unique(na.omit((match(temp[,1],dat$probename)))))>=2)												{
		
			WT<-cbind(findWT,i)
			KO<-cbind(findKO,i)
			
			if (i==ini|(!is.na(WTglob[1])&WTglob[1]==1)){
				WTglob<-WT
				KOglob<-KO
				} else {
					if ((structure[i,4])==(structure[i-adj,4])){
						WTglob<-rbind(WTglob,WT)
						KOglob<-rbind(KOglob,KO)
							
						} else {
							
							WTmedian<-median(na.omit(WTglob[,1:3]))
							KOmedian<-median(na.omit(KOglob[,1:3]))
							
							WTcn<-cbind(WTglob[,1:3]-WTmedian,WTglob[,4])
							KOcn<-cbind(KOglob[,1:3]-KOmedian,KOglob[,4])
							
							#WTcnVis<-WTcn-rowMeans(cbind(WTcn,KOcn))
							#KOcnVis<-KOcn-rowMeans(cbind(WTcn,KOcn))
							
							for (j in WTglob[1,4]:WTglob[nrow(WTglob),4]){
								
								Refseq[j]<-structure[j,4]
								ex[j]<-structure[j,7]
								exnb[j]<-structure[j,8]
								dir[j]<-structure[j,6]
								
								FCmed[j]<-2^(WTmedian-KOmedian)								
							
								if (nrow(na.omit(WTcn[WTcn[,4]==j,1:3]))>=2){
									if (!identical(WTcn[WTcn[,4]==j,1:3][1,],WTcn[WTcn[,4]==j,1:3][2,])&!identical(KOcn[KOcn[,4]==j,1:3][1,],KOcn[KOcn[,4]==j,1:3][2,])==TRUE){
									testWT[j]<-median(WTglob[WTglob[,4]==j,1:3],na.rm=TRUE)
									testKO[j]<-median(KOglob[KOglob[,4]==j,1:3],na.rm=TRUE)
									testWTnorm[j]<-median(WTcn[WTcn[,4]==j,1:3],na.rm=TRUE)
									testKOnorm[j]<-median(KOcn[KOcn[,4]==j,1:3],na.rm=TRUE)
									testFCnorm[j]<-testWTnorm[j]-testKOnorm[j]
										if (length(unique(as.numeric(na.omit(WTcn[WTcn[,4]==j,1:3]))))!=1|length(unique(as.numeric(na.omit(KOcn[KOcn[,4]==j,1:3]))))!=1){
											ttest<-t.test(as.numeric(na.omit(WTcn[WTcn[,4]==j,1:3])),as.numeric(na.omit(KOcn[KOcn[,4]==j,1:3])),var.equal=TRUE)
											testP[j]<-ttest$p.value} else {
																ttest<-0
																testP[j]<-0
																print("CST")
															}
									}
									} else {
										testWT[j]<-NA
										testKO[j]<-NA
										testWTnorm[j]<-NA
										testKOnorm[j]<-NA
										testFCnorm[j]<-NA
										testP[j]<-NA
									}
								}
								WTglob<-WT
								KOglob<-KO
							}
						}
						
						adj<-1
												
					} else {adj<-adj+1}
				} else {adj<-adj+1}
				Refseq[i]<-structure[i,4]
				ex[i]<-structure[i,7]
				exnb[i]<-structure[i,8]
				dir[i]<-structure[i,6]
			}
				
	


global<-data.frame(Refseq,feature=ex,feat_nbr=exnb,direction=dir,feat_WT=testWT,feat_KO=testKO,feat_WTnorm=testWTnorm,feat_KOnorm=testKOnorm,feat_FC=testFCnorm,feat_P=testP,Refseq_FC=FCmed)

names(store)[names(store)=="V4"]<-"Refseq"
names(store)[names(store)=="V7"]<-"feature"
names(store)[names(store)=="V8"]<-"feat_nbr"
names(store)[names(store)=="V6"]<-"direction"
names(store)[names(store)=="V2"]<-"probe_start"
names(store)[names(store)=="V3"]<-"probe_end"
store<-cbind(store,probe_WT=rowMeans(store[,10:12]),probe_KO=rowMeans(store[,13:15]),probe_FC=rowMeans(store[,10:12])/rowMeans(store[,13:15]))


#write.table(global[ini:nbr,],file="global_HuGene_CTR_v_CLP1_SH2.csv",sep=",",row.names=FALSE)

############# Optional
#write.table(store,file="store_TOUT_siDDX5_2008_hg19_UTR_d_V6p_cut10.csv",sep=",",row.names=FALSE)
