depthArray = [1000, 1200];
fNames = arrayfun(@(x) ['Heating_1320nm_', num2str(x),'um.csv'], depthArray, 'UniformOutput', false);
markerType = {'v','^'};
markerSize = [84, 84, 84];
markerColor = {[217 139 99]/255, [192 63 58]/255, [41 154 99]/255};
bkgColor = {[253 225 204]/255, [249 206 207]/255, [205 233 219]/255};

markers = {'HSP70','GFAP','Iba1'};

for j = 1:length(markers)
    eval(['f', num2str(j), '= figure;']);
    tbl = readtable('Heating_1320nm_control.csv');
    pd = fitdist(tbl{:,1+j}, 'Normal');
    ci = paramci(pd);
    rec = rectangle('Position', [0, ci(1,1), 200, ci(2,1)-ci(1,1)], 'FaceColor', bkgColor{j}, 'EdgeColor', 'none');
    disp([markers{j}, ': mean=', num2str(nanmean(tbl{:,1+j})), '; stdev=', num2str(nanstd(tbl{:,1+j}))]);
    
    hold on
    scatter(tbl{:,1}, tbl{:,1+j}, 56,  markerColor{j}, 'o', 'filled', 'LineWidth' ,1.5);

    for i = 1:length(depthArray)
        tbl = readtable(fNames{i});
%         if i == 2
%             scatter(tbl{:,1}, tbl{:,1+j}, markerSize(i), markerColor{j}, markerType{i}, 'LineWidth' ,2);
%         else
            scatter(tbl{:,1}, tbl{:,1+j}, markerSize(i), markerColor{j}, markerType{i}, 'LineWidth' ,2);
%         end
    end
    %title(markers{j});
    xlabel('Average Power after the Objective Lens (mW)');
    ylabel([markers{j}, '  I/I0']);
    ax = gca;
%     ax = axes('Position', [0.14 0.13 0.72, 0.77],...
%     'Color','none');
    ax.FontSize = 20;
    ax.FontName = 'Arial';
    ax.LineWidth = 2;
    ax.XLim = [0, 200];
    maxY = ax.YLim(2);
    ax.YLim = [-0.1, ceil(maxY/0.2)*0.2];
    ax.XTick = [0:25:200];
    ax.Layer = 'top';
    legend({'Control',  '1 mm', '1.2 mm'}, 'Location', 'northwest', 'FontSize', 20);
%     objhl = findobj(objh, 'type', 'line'); % objects of legend of type line
%     set(objhl, 'Markersize', 8); % set marker size as desired
%     objhl = findobj(objh, 'type', 'patch'); % objects of legend of type patch
%     set(objhl, 'Markersize', 8);
    box on
end