%08/09/16 ATT

%These parameters can be tweaked, but the number of cells can't really go
%any lower

num_durs = 4;
num_freqs = 4;
num_cells = 5;
num_instances = 20; %i.e. makes num_instances versions of each condition

%Set duration transition and frequency transition probability conditions

dur_trans_probs = [0.1 0.9];
freq_trans_probs = [0.3 0.7];

%Set frequencies and durations

durations = [0.075 0.125 0.175 0.225];
frequencies = [440 466.16 493.88 523.25];%[440 493.88 554.37 622.25];

%Duration of silence between trials

silence_dur = 0;

%This section generates a sequence with a length of num_durs * num_freqs *
%num_cells that contains the appropriate frequency and duration transition
%probabilities.

for z = 1:num_instances

for r = 1:length(dur_trans_probs)
    
    for q = 1:length(freq_trans_probs)
        
        found_sequence = 0;
        
        %Note that the program will run until it finds an appropriate
        %sequence, so if you use a set of parameters that won't work it
        %will run forever
        
        while found_sequence == 0
            
            dur_list = [];
            freq_list = [];
            
            %Populates the list of frequencies available for a given
            %duration. At start, each frequency is represented num_cells
            %times.
            
            for n = 1:num_durs
                cond_matrix{n} = repmat([1:num_freqs],1,num_cells);
            end
            
            for n = 1:(num_durs * num_freqs * num_cells)
                
                %The code below can produce an unworkable result (for
                %example, by selecting a duration with no remaining
                %usable examples), so the code just loops until it produces
                %a workable result. This is lazy, will fix eventually.
                
                stop_now = 0;
                while stop_now == 0
                    
                    %Randomly decide whether to pick the duration of the
                    %previous note, based on the current duration
                    %transition probability. Otherwise, pick one of the
                    %other durations, selected at random.
                    
                    dice_roll = rand;
                    if dice_roll > dur_trans_probs(r) & n > 1
                        dur_index = dur_list(n-1);
                    else
                        dur_index = randperm(num_durs);
                        if n > 1
                            if dur_index(1) ~= dur_list(n-1)
                                dur_index = dur_index(1);
                            else
                                dur_index = dur_index(2);
                            end
                        else
                            dur_index = dur_index(1);
                        end
                    end
                    freq_index = [];
                    if length(cond_matrix{dur_index}) > 0
                        
                        %Randomly decide whether to pick the frequency of
                        %the previous note, based on the current frequency
                        %transition probability. If there aren't any
                        %examples left for the selected duration, though,
                        %just pick some other frequency.
                        
                        dice_roll = rand;
                        if dice_roll > freq_trans_probs(q) & n > 1
                            for p = randperm(length(cond_matrix{dur_index}))
                                if cond_matrix{dur_index}(p) == freq_list(n-1)
                                    freq_index = p;
                                end
                            end
                            if length(freq_index) == 0
                                freq_index = randperm(length(cond_matrix{dur_index}));
                                freq_index = freq_index(1);
                            end
                            
                            %...otherwise, try to pick a different
                            %frequency from the last one selected. If there
                            %aren't any other frequencies left, though,
                            %just pick the same frequency again.
                            
                        else
                            for p = randperm(length(cond_matrix{dur_index}))
                                if n > 1
                                    if cond_matrix{dur_index}(p) ~= freq_list(n-1)
                                        freq_index = p;
                                    end
                                end
                            end
                            if length(freq_index) == 0
                                freq_index = randperm(length(cond_matrix{dur_index}));
                                freq_index = freq_index(1);
                            end
                        end
                        
                        %Record the selected frequencies and durations in
                        %two separate lists
                        
                        freq_list(n) = cond_matrix{dur_index}(freq_index);
                        dur_list(n) = dur_index;
                        
                        %Remove the selected duration/frequency combination
                        %from the set of possible options to choose from
                        
                        cond_matrix{dur_index}(freq_index) = [];
                        
                        %...and tell the loop to stop looping
                        
                        stop_now = 1;
                    else
                        stop_now = 0;
                    end
                end
            end
            
            %Now that the sequence has been made, check to see if it has
            %the target number of duration and frequency transitions. If
            %so, stop, and save the current list of frequencies and 
            %durations. If not, start over.
            
            num_dur_transitions = 0;
            num_freq_transitions = 0;
            for n = 2:length(dur_list)
                if dur_list(n-1) ~= dur_list(n)
                    num_dur_transitions = num_dur_transitions + 1;
                end
            end
            for n = 2:length(freq_list)
                if freq_list(n-1) ~= freq_list(n)
                    num_freq_transitions = num_freq_transitions + 1;
                end
            end
            
            if ceil(dur_trans_probs(r)*(num_durs * num_freqs * num_cells - 1)) == num_dur_transitions & ceil(freq_trans_probs(q)*(num_durs * num_freqs * num_cells - 1)) == num_freq_transitions
                found_sequence = 1;
                dur_matrix{r,q} = dur_list;
                freq_matrix{r,q} = freq_list;
            else
                found_sequence = 0;
            end
        end
    end
end

%The following actually makes the sound for each condition. Sequences are
%made up of complex tones including the first six harmonics, but this is
%easily tweakable.

fs = 44100;

for n = 1:length(dur_trans_probs)
    for m = 1:length(freq_trans_probs)
        
        dur_list = dur_matrix{n,m};
        freq_list = freq_matrix{n,m};
        
        sound_sequence = [];
        
        for p = 1:num_durs * num_freqs * num_cells
            
            frequency = frequencies(freq_list(p));
            silence_duration = durations(dur_list(p))-0.03;
            duration = 0.03;
            
            %Change the next line to include different sets of harmonics
            
            harmonics = [frequency frequency*2 frequency*3 frequency*4 frequency*5 frequency*6];
            
            current_sound = zeros(1,ceil(duration * fs));
            
            %Add harmonics one by one
            
            for r = 1:length(harmonics)
                
                num_samples = ceil(duration * fs);
                samples = (1:num_samples)/fs;
                temp_sound = sin(2 * pi * harmonics(r) * samples);
                current_sound = current_sound + temp_sound;
                
            end
            
            current_sound = current_sound/(max(abs(current_sound)));
            current_sound = current_sound.*0.9;
            
            %Cosine ramp
            
            ramp_dur = 0.010;
            num_ramp_samples = ceil(fs * ramp_dur);
            ramp = cos(linspace(pi,0,num_ramp_samples));
            ramp = (ramp+1)./2;
            ramp = [ramp, ones(1,num_samples - num_ramp_samples * 2),fliplr(ramp)];
            current_sound = current_sound .* ramp;
            
            current_sound = [current_sound zeros(1,ceil(silence_duration*fs))];
            

            
            %Add note to sequence
            
            sound_sequence = [sound_sequence current_sound];
           
        end
        
        sound_sequence = [sound_sequence zeros(1,silence_dur*fs)];
        
        seq_matrix{n,m} = sound_sequence;
        
    end
end

%Create .wav files for each sequence. Files are saved as
%'Pitchdur_[Dur_trans_prob]_[Freq_trans_prob].wav', where [Dur_trans_prob]
%and [Freq_trans_prob] are the percentage change that a given transition
%between two notes contains a change in duration or frequency.

for n = 1:length(dur_trans_probs)
    for m = 1:length(freq_trans_probs)
        audiowrite(['Pitchdur_' num2str(dur_trans_probs(n)*100) '_' num2str(freq_trans_probs(m)*100) '_' num2str(z) '.wav'],seq_matrix{n,m},fs);
    end
end

end

seq_length = length(seq_matrix{1,1});
silence = zeros(1,seq_length);
audiowrite('Silence.wav',silence,fs);
            
            