%% Introduction
% This program help to get fushion images from the opposite z-stack raw
% images.
% modified by zhc & kkk 12/18/2018
% Modified & anotated by Bofei Cui.

%% Initialization 
% Clear the memory and close all figures.
clear
close all
% Chooose the file folder containing data. Our example dataset has 4 channels,
% and the number of images in one channel is the total number divided by 4.

input_filepath1 = uigetdir('*.*','Please select the first folder');
img_path_list_1 = dir(strcat(input_filepath1,'/*.tif'));
img_num_1 = length(img_path_list_1);
num_sig_1 = img_num_1/4; 
input_filepath2 = uigetdir('*.*','Please select the second folder');
img_path_list_2 = dir(strcat(input_filepath2,'/*.tif'));
img_num_2 = length(img_path_list_2);
num_sig_2 = img_num_2/4;
Nfig = max(num_sig_1,num_sig_2);

matchingRange = 500;
imgSize=[1920,1920];

%% Register and save position information of two image sequence.
% Registration is conducted according to the maximum-area section.

% Extract the embryomask from the first image sequence accordiing to the given threshold.
kMaskThr = 1000; 
% select middle part to make sure the better Signal-noise ratio; manual adjust
A=zeros(2,Nfig);
for i=1:num_sig_1
    if i>50 && i<150 
        F = strcat(input_filepath1,'/',img_path_list_1(i).name);
        im=imread(F);
        A(1,i) = i;
        i
        [A(2,i),~]=K_mask_zhc_2(im,kMaskThr);
    else
        A(1,i) = i;
        A(2,i) = 0;
    end
end
A1=A;
figure,plot(A1(2,:));
reply = input('Is maximum-area section in the range? [yes]1 [No]0');
if reply == 0  
    return;
end
close all

% Extract the embryomask from the second image sequence accordiing to the same threshold.
A=zeros(2,Nfig);
 for i1 = 1:num_sig_2
    if 50< i1 && i1<150
    F = strcat(input_filepath2,'/',img_path_list_2(i1).name);
    im=imread(F);
    A(1,i1) = i1;
    i1
   [A(2,i1),~]=K_mask_zhc_2(im,kMaskThr);
   else
        A(1,i1) = i1;
        A(2,i1) = 0;
    end
end
figure,plot(A(2,:));
reply = input('Is maximum-area section in the range? [yes]1 [No]0');
if reply == 0  
    return;
end
A2f=fliplr(A);
clear im F t;

[~,p1]=max(A1(2,:));
[~,p2]=max(A2f(2,:));
Afinal(1,:) = A1(1,:)+p1-p2;
Afinal(2,:) = A2f(1,:);
posi=Afinal;
close all
figure,plot(A2f(2,:));
% Label the abnormal values in position information. They will not be used for 
% dual-fusion in the following.
posi_column = size(posi,2);
posi_t = [];
for i2 = 1:posi_column
    if posi(1,i2)<=0 || posi(2,i2)<=0 ||posi(1,i2)>num_sig_1 ||posi(2,i2)>num_sig_2
       posi(:,i2) = [0,0];
    end
end
save posi_information
clear t i F A 


%% We provide 2 alternative method for image registration and fusion.
% The first method:
% principle:find the parameters from the middle part of two z-stack images
% and then apply into the all images
% advantages and disadvantages: faster operation rate but biased sometimes
%%
mkdir kfuC1
dirName_ch1='kfuC1'
DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch1,1)
%%
mkdir kfuC2
dirName_ch2='kfuC2'
DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch2,2)
%%
mkdir kfuC3
dirName_ch3='kfuC3'
DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch3,3)
%%
mkdir kfuC0
dirName_ch0='kfuC0'
DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch0,0)

%% The second method
% principle:find the suitable parameters from the each two z-stack images
% and then adjust
% advantages and disadvantages: slower operation rate but better result

% %%
% mkdir kfuC1
% dirName_ch1='kfuC1'
% DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch1,1)
% %%
% mkdir kfuC2
% dirName_ch2='kfuC2'
% DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch2,2)
% %%
% mkdir kfuC3
% dirName_ch3='kfuC3'
% DualFusion1(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch3,3)
% %%
% mkdir kfuC0
% dirName_ch0='kfuC0'
% DualFusion2(posi,num_sig_1,num_sig_2,input_filepath1,input_filepath2,img_path_list_1,img_path_list_2,dirName_ch0,0)

