function Checklist= CheckHbboundary_7Eve_LSM(EmIdlist1,HbChaNum, DapiChaNum, method,Emprofile)
% -------------------------------------------------------------------------
% This function allows the user to manually check that the hunchback
% boundary was properly detected.
%
% INPUTS:
% -HbChaNum: The channel that the Hb profile is in. Should be a number
% between 1 and 3.
%
% -method: Tells the program which method was used to find the Hb boundary.
% If method is 0 (Default), the program checks the boundary as determined by both the
% 0.5 threshold and Feng's slope algorithm.
% If method is 1, the program only checks the thresholded boundary.
% If method is 2, the program only checks the slope-wise boundary.
%
% Edited by Alex 7/13/11
% -------------------------------------------------------------------------


if ~exist('HbChaNum', 'var') || isempty(HbChaNum), HbChaNum=1; end
if ~exist('DapiChaNum', 'var') || isempty(DapiChaNum), DapiChaNum=1; end
if ~exist('method', 'var') || isempty(method), method=0; end
if HbChaNum>3, HbChaNum=3; end
if ~exist('Emprofile','var') || isempty(Emprofile), load Emprofile; end



%load Results
Profile = Emprofile.NormHbprofile_7Eve;
Boundary = Emprofile.Hbboundary_7Eve;
Nans = isnan(Boundary);
Boundary(Nans) = 0;
APx=0:0.001:0.999;


Checklist=[];
for i=1:length(EmIdlist1)
     %for i=[81,103,220];
     Checklist1=EmIdlist1(i);
    %Orientation = Emprofile.Em(EmIdlist1(i)).Orientation;
    DV=Emprofile.DV(EmIdlist1(i),1,2);
    %if Orientation==1&DV>0.01&DV<0.1
    Emnum=Emprofile.Em(EmIdlist1(i)).Emnum;
    APxy=Emprofile.Em(EmIdlist1(i)).APxy;
    Outline=Emprofile.Em(EmIdlist1(i)).Outline;
%     
    %Emage = Emprofile.Em(EmIdlist1(i)).InvaginationDepth;
    Dorsalprofile=Emprofile.Em(EmIdlist1(i)).dorsal(:,:,HbChaNum);
    for j=1:size(Dorsalprofile,2)
        Dorsalprofile(:,j)=inpaint_nans(Dorsalprofile(:,j));
    end
    
    Ventralprofile=Emprofile.Em(EmIdlist1(i)).ventral(:,:,HbChaNum);
    for j=1:size(Ventralprofile,2)
        Ventralprofile(:,j)=inpaint_nans(Ventralprofile(:,j));
    end
    
   
    if method == 0
        
        %for k = 1:2
            for k=1
            ind=find(abs(Dorsalprofile(:,1)-Boundary(EmIdlist1(i),1,k))<0.001,1,'first');
            Boundaryposition(1,1)=Dorsalprofile(ind,1);%APx
            Boundaryposition(2,1)=round(Dorsalprofile(ind,3));%y
            Boundaryposition(3,1)=round(Dorsalprofile(ind,4));%x
            
            ind=find(abs(Ventralprofile(:,1)-Boundary(EmIdlist1(i),2,k))<0.001,1,'first');
            Boundaryposition(1,2)=Ventralprofile(ind,1);
            Boundaryposition(2,2)=round(Ventralprofile(ind,3));
            Boundaryposition(3,2)=round(Ventralprofile(ind,4));
            
            Eimfilename=sprintf('Fluimage_%03g.tif',Emnum);
            Eim=imread(Eimfilename);
            %Dim = Eim(:,:,DapiChaNum);
            Dim = Eim(:,:,DapiChaNum);
            Eim=Eim(:,:,HbChaNum);
            for l=1:2
            figure('windowstyle','docked');
            subplot 311
            plot(APx,Profile(:,EmIdlist1(i),l),'ro','Markersize',2);
            hold on;
            %plot(APx,Profile(:,EmIdlist1(i),l),'bo','Markersize',2);
            axis([0 1 0 1.1]);
            line([Boundary(EmIdlist1(i),l,k) Boundary(EmIdlist1(i),l,k)],[0 1],'color','r','LineStyle','-');
            %line([Boundary(EmIdlist1(i),2,k) Boundary(EmIdlist1(i),l,k)],[0 1],'color','b','LineStyle','-');
            
            subplot 312
            %imagesc(Eim); axis image;
            imshow(Eim,[]); axis image;
            hold on, plot(Boundaryposition(3,l),Boundaryposition(2,l),'r*','Markersize',3);
            %hold on, plot(Boundaryposition(3,2),Boundaryposition(2,2),'b*','Markersize',3);
            hold on, plot([APxy(1) APxy(3)],[APxy(2) APxy(4)],'y*','Markersize',6);
            
            subplot 313
            %imagesc(Dim); axis image;
            imshow(single(Eim)+single(50*Outline),[]); axis image;
            hold on, plot(Boundaryposition(3,l),Boundaryposition(2,l),'r*','Markersize',3);
            %hold on, plot(Boundaryposition(3,2),Boundaryposition(2,2),'b*','Markersize',3);
            title(sprintf('Em %g with Invagination Depth %g', Emnum))%,Emage));
            
            %             i
            reply = input('Are you satisfied with the embryo? Y/N [Y]', 's');
            if isempty(reply)
                reply = 'Y';
            end
            
            close
            
            if(reply=='N')
                Checklist1=cat(2,Checklist1,0);
            else
                Checklist1=cat(2,Checklist1,1);
            end
            close all
            end
        end
    else
        ind=find(abs(Dorsalprofile(:,1)-Boundary(i,1,method))<0.001,1,'first');
        Boundaryposition(1,1)=Dorsalprofile(ind,1);
        Boundaryposition(2,1)=round(Dorsalprofile(ind,3));
        Boundaryposition(3,1)=round(Dorsalprofile(ind,4));
        
        ind=find(abs(Ventralprofile(:,1)-Boundary(i,2,method))<0.001,1,'first');
        Boundaryposition(1,2)=Ventralprofile(ind,1);
        Boundaryposition(2,2)=round(Ventralprofile(ind,3));
        Boundaryposition(3,2)=round(Ventralprofile(ind,4));
        
        Eimfilename=sprintf('Fluimage_%03g.tif',Emnum);
        Eim=imread(Eimfilename);
        Dim = Eim(:,:,DapiChaNum);
        Eim=Eim(:,:,HbChaNum);
        
        figure('windowstyle','docked');
        subplot 311
        plot(APx,Profile(:,i,1),'ro','Markersize',2);
        hold on;
        plot(APx,Profile(:,i,2),'bo','Markersize',2);
        axis([0 1 0 1.1]);
        line([Boundary(i,1) Boundary(i,1)],[0 1],'color','r','LineStyle','-');
        line([Boundary(i,2) Boundary(i,2)],[0 1],'color','b','LineStyle','-');
        
        subplot 312
        %imagesc(Eim); axis image;
        imshow(Eim,[]); axis image;
        hold on, plot(Boundaryposition(3,1),Boundaryposition(2,1),'r*','Markersize',3);
        hold on, plot(Boundaryposition(3,2),Boundaryposition(2,2),'b*','Markersize',3);
        
        subplot 313
        %imagesc(Dim); axis image;
        %imshow(Dim,[]); axis image;
        imshow(single(Eim)+200*single(Outline),[]); axis image;
        hold on, plot(Boundaryposition(3,1),Boundaryposition(2,1),'r*','Markersize',3);
        hold on, plot(Boundaryposition(3,2),Boundaryposition(2,2),'b*','Markersize',3);
        title(sprintf('Em %g with Invagination Depth %g', Emnum))%,Emage));
        
        %         i
        reply = input('Are you satisfied with the embryo? Y/N [Y]', 's');
        if isempty(reply)
            reply = 'Y';
        end
        
        close
        
        if(reply=='N')
          Checklist1=cat(2,Checklist1,0);
        else
          Checklist1=cat(2,Checklist1,1);
        end
        close all
    end
    Checklist=cat(1,Checklist,Checklist1);
    

%     else
%     
%     Checklist1=cat(2,Checklist1,0,0);
%     Checklist=cat(1,Checklist,Checklist1);
% 
% end

    end
end

