%% Intruduction
% This code is for the image analysis for fix embryos to get the profiles
% along the AP axis of embryos

%% Rotate, flip and crop the images of all the embryos
close all;
clear all;
clc;

numofchannels=1; % the numbers of image channels

Emprofile=rearrange_Embryos_qua('image_resize*.tif',numofchannels);

Emindlist=1:length(Emprofile.Em);

Emprofile=EmbryosAnalysis_new_triple(Emindlist,Emprofile,1);

%% Extracted eve profile and normlized it
Hbprofile=Readprofile(Emprofile,Emindlist,1);
NormHbprofile=GetNormlizedprofile(Hbprofile,0.03,0,1);
Emprofile.Hbprofile_7Eve=Hbprofile;
Emprofile.NormHbprofile_7Eve=NormHbprofile;

Hbboundary1= GetBoundary(NormHbprofile,1);% dorsal profiles
Hbboundary2= GetBoundary(NormHbprofile,2);% ventral profiles
Hbboundary=cat(3,Hbboundary1,Hbboundary2);
DV=Hbboundary(:,1,:)-Hbboundary(:,2,:);
Emprofile.Hbboundary_7Eve=Hbboundary;
Emprofile.DV=DV;
save Emprofile Emprofile

%% manually check that the hunchback
% boundary was properly detected.    
Checklist= CheckHbboundary_7Eve_LSM(Emindlist,1,1,0,Emprofile); %
Emprofile.Hbcheck_7Eve=Checklist;
save Emprofile Emprofile

[NormHbprofile_check_1,boundary1]=GetNormlizedprofile_sort(Emprofile,Hbprofile,0.03,0,1,1);
Emprofile.sort1boundary=boundary1;
save Emprofile Emprofile
[NormHbprofile_check_2,boundary2]=GetNormlizedprofile_sort(Emprofile,Hbprofile,0.03,0,1,2);
Emprofile.sort2boundary=boundary2;
NormHbprofile = cat(2,NormHbprofile_check_1,NormHbprofile_check_1);
save Emprofile Emprofile
 
load Emprofile

%% synchronize orientation

B1=Emprofile.sort1boundary;
B2=Emprofile.sort2boundary;

m1=nanmean(B1(:,1));m2=nanmean(B2(:,1));
s1=nanstd(B1(:,1));s2=nanstd(B2(:,1));
newB=cat(1,B1(:,1),B2(:,1));
m3=nanmean(newB);s3=nanstd(newB);

HbPpeak=findHbPpeak_ThresMaxMethod_7Eve(NormHbprofile,Emindlist);
Emprofile.HbPpeak_7Eve=HbPpeak;

%pixelscale=ap_leng*0.001;%for previous fused embryos
[APDVlength EL Orient]= GetAPandDVlength(Emprofile,1);



%% synchronize orientation

% clear
% load('results.mat')
DV=Emprofile.DV;
symindex1=find(DV(:,:,1)<0.01);
symindex1=round(mean(symindex1));
%symindex1=28;

orienteddorsal1=[B1(symindex1:end,:);B1(1:symindex1-1,:)];
orientedventral1=[B2(symindex1:end,:);B2(1:symindex1-1,:)];
orientedboundary1=[orienteddorsal1;orientedventral1];
orientedHbdorsal1=[NormHbprofile_check_1(:,symindex1:end,1),NormHbprofile_check_1(:,1:symindex1-1,1)];
orientedHbventral1=[NormHbprofile_check_2(:,symindex1:end,1),NormHbprofile_check_2(:,1:symindex1-1,1)];
orientedHb1=[orientedHbdorsal1,orientedHbventral1];
% original data
orientedHbprofiledorsal1=[Hbprofile(:,symindex1:end,1),Hbprofile(:,1:symindex1-1,1)];
orientedHbprofileventral1=[Hbprofile(:,symindex1:end,2),Hbprofile(:,1:symindex1-1,2)];
orientedHbprofile1=[orientedHbprofiledorsal1,orientedHbprofileventral1];

Hbcheckdorsal1=[Emprofile.Hbcheck_7Eve(symindex1:end,2);Emprofile.Hbcheck_7Eve(1:symindex1-1,2)];
Hbcheckventral1=[Emprofile.Hbcheck_7Eve(symindex1:end,3);Emprofile.Hbcheck_7Eve(1:symindex1-1,3)];
Hbcheckall1=[Hbcheckdorsal1;Hbcheckventral1];

orienteddorsalEL=[EL(symindex1:end,1);EL(1:symindex1-1,1)];
orientedventralEL=[EL(symindex1:end,1);EL(1:symindex1-1,1)];
orientedallEL=[orienteddorsalEL;orientedventralEL];

orienteddorsalAPlength=[APDVlength(symindex1:end,1);APDVlength(1:symindex1-1,1)];
orientedventralAPlength=[APDVlength(symindex1:end,1);APDVlength(1:symindex1-1,1)];
orientedallAPlength=[orienteddorsalAPlength;orientedventralAPlength];

save results


