function [xx, yy] = myGetAP(emMask, fig)

    if ~exist('fig', 'var') || isempty(fig), fig = 0; end

    [xcor, ycor] = find(bwperim(emMask));
    if size(ycor, 1) == 0
        xx = [0, 0]; yy = [0, 0];
        return
    end
    rec_cor = [xcor, ycor];
    %leng = length(xcor);
    %mygap = 10;
    %imagesc(emMask)
    %hold on 
    samp = datasample(rec_cor, 500, 1);
    distan = squareform(pdist(samp));
    [~, argm] = max(distan(:));
    [row, col] = ind2sub(size(distan), argm);
    cor1 = samp(row, :); cor2 = samp(col, :);
    xx = [cor1(1), cor2(1)];
    yy = [cor1(2), cor2(2)];
    
    if fig  
        %figure
        imagesc(emMask)
        hold on
        scatter(yy(1), xx(1), 'MarkerFaceColor', 'r')
        scatter(yy(2), xx(2), 'MarkerFaceColor', 'r')
        hold off
        drawnow
    end
    
    %{
    [aux_xx, aux_yy] = meshgrid(- 25: 25);
    aux_xx = aux_xx(:); aux_yy = aux_yy(:);
    aux_samp = [aux_yy, aux_xx];
    sq1 = aux_samp + cor1;
    sq2 = aux_samp + cor2;
    rang1 = intersect(sq1, rec_cor, 'rows');
    rang2 = intersect(sq2, rec_cor, 'rows');

    scatter(rang1(:, 2), rang1(:, 1))
    scatter(rang2(:, 2), rang2(:, 1));
   
    for iter_p = 1: mygap: leng
       scatter(xcor(iter_p), ycor(iter_p))
       drawnow;
       pause(0.1)
    end
    %}
end