function Emprofile=rearrange_Embryos_qua(inputmask,numofchannels,level,Bfchannelnum,nbits)

% This program takes the original images, rotates them and flips
% them so that the embryos are shown horizontally with the anterior side on
% the left and the dorsal side on the top. The new images are stored in the
% main folder as imagexxx.tif
%
% INPUTS
%
% inpuymask - string,e.g,'Image*.tif',name formate of the inputfiles, by
% default, it is a tif file containing multiple channels including at
% least bright filed 
% level - threshold level used to find the mask
% 
%
% REVISION HISTORY
%
% 04/06/10 Written by Julien Dubuis
% 01/30/2011 Updated by Feng Liu
% 02/21/2010  Update by Feng Liu,set the threshold for embryo mask
% automaticlly; find the brignt filed channel automatically.
% 09/03/2019 Updated by Hongcun Zhu

if ~exist('numofchannels') || isempty(numofchannels), numofchannels = 1; end
if ~exist('level') || isempty(level), level = 0.006; end
if ~exist('Bfchannelnum') || isempty(Bfchannelnum), Bfchannelnum = 1; end
if ~exist('nbits') || isempty(nbits), nbits = 16; end

%load Emprofile

warning off
filelist = dir(inputmask);
fileNames = {filelist.name}';
numfiles=length(fileNames);
numofEm=numfiles/1;


BadEmcount=0;


for i=1:numofEm
    
    disp(i);
    Im=[];Znum=0;
    
    
    imfile=fileNames{1*i};
    Im=imread(imfile);
    
if strfind(imfile,'image')
    
    p1=strfind(imfile,'image');
    
    Emnum=str2num(imfile(p1+12:p1+13));  %need to notice  !!!!
end

[m n numofchannels]=size(Im);
    
    % Try to find the bright filed channel, Im_new is the new image without
    % the brightfield channel, Im_tot is the sum of all the chanelles
    % except the bright field.
    
    % Pick the bright field channel assuming its background is the
    % brightest and embryo dose not touch the top edge of the image
    % also take the following satuation into consideration:
    %there is another embryos or dark bubbles on the edge
    %[Bfcutoff Bfchannelnum]=max(median(double(Im(1,:,:))),[],3);
    
    %Im_tot=uint16(zeros(m,n));
    Im_bf=Im;
    Im_new=Im;
    %Im_new(:,:,Bfchannelnum)=[];
    
    % if two different channel has very different dynamic range, combine
    % them can cause problem
    
    %Im_tot=sum(Im_new,3);
    
    Im_tot=Im_new;%yz,nuc channel
    
    % automatic find the level threshold, if the embryomask touches the
    % edge of the image then increase the threshold
    % But if the embryo did touch the edge, then the embryomask will be
    % wrong
    
    k=1;
    level1=k*level;    

  [~,Im_mask]=K_mask_zhc_2(Im_tot,590);% the cutoff value can adjust
     
     if sum(sum(Im_mask))<= 0.1*m*n
       disp(['Image ',num2str(Emnum),' failed to be rotated']);
       BadEmcount=BadEmcount+1;
     else
       [I_rotated Imask_rotated]=rotate_Embryo(Im_new,Im_mask);
       
     if sum(sum(Imask_rotated))<= 0.1*m*n
       disp(['Image ',num2str(Emnum),' failed to be rotated']);
       BadEmcount=BadEmcount+1;
       
         
       
     else
    
     
     Bf_rotated=rotate_Embryo(Im_bf,Im_mask);

     
     if Znum==0
     [~, Imask_rotatedandflipped]=flip_Embryo(I_rotated,Imask_rotated,'Fluimage',Emnum);
     %flip_Embryo(Bf_rotated,Imask_rotated,'Bfimage',Emnum);
     else
     [~, Imask_rotatedandflipped]=flip_Embryo(I_rotated,Imask_rotated,['Fluimagez' num2str(Znum)],Emnum);
     %flip_Embryo(Bf_rotated,Imask_rotated,['Bfimagez' num2str(Znum)],Emnum);
     end
         
     
     
    Emprofile.Em(i-BadEmcount).Emnum=Emnum;
    Emprofile.Em(i-BadEmcount).Filename=imfile;
    Emprofile.Em(i-BadEmcount).masklevel=level1;
   % Emprofile.Em(i-BadEmcount).Emimage=Em_rotatedandflipped;
    Emprofile.Em(i-BadEmcount).Emmask=Imask_rotatedandflipped;
     
     end
     
     end
    
end
save Emprofile Emprofile
end




function Im_mask=GetEmbryomask(Im,nbits,level)

% get rid of the touching on the edge


     
     Im([1 end],:)=0;
     
     Im(:,[1 end])=0;
    
  
bw = im2bw(Im,level);

bwfill = imfill(bw, 'holes');

% if there are multiple embryos, get rid the others

L = bwlabel(bwfill);
A = regionprops(L, 'Area');
areas = [A.Area];
biggestRegion = find(max(areas)==areas);
bwfill1 = (L==biggestRegion);  


% select embryo mask at the center

%I_opened = bwselect(bwfill1,round(size(bwfill,2)/2),round(size(bwfill,1)/2));

I_opened=bwfill1;


I_opened=I_opened*2^nbits;

if nbits==8
    I_opened=uint8(I_opened);
else
    I_opened=uint16(I_opened);
end

% figure, imshow(I_opened), title('I_open')

PSF = fspecial('gaussian',40,20);
I_blurred = imfilter(I_opened,PSF,'symmetric','conv');

% figure, imshow(I_blurred), title('I_blurred')

level = graythresh(I_blurred);
Im_mask = im2bw(I_blurred,level);
        
        
end


function [Im_rotated Imask_rotated]=rotate_Embryo(I,Im_mask)
% Rotateangele is determined by the orientation calcualted by regionprops.
% It finds the angle between the x-axis and the major axis of an ellipse
% which has the same second moment as the embryo. However, ellipse is not
%a good approxmation of the embryo shape especially when it is in lateral 
% view. Need to find out the difference between this method and the one which 
% calcualte the maximum distance beween the embryo perimeter  

% INPUTS
%
% I_tot - original image in TIF format
% level - threshold level used to find the mask
% num_channels - number of channels on the TIF image
%
% OUTPUTS
%
% I_rotated - matrix containing the rotated image
%
% REVISION HISTORY
%
% 11/11/10 Written by Julien Dubuis
% 01/28/11 Rewirtten by Feng Liu

 
    
    
    L=bwlabel(Im_mask);
    Props=regionprops(L,'Orientation');
    angle=Props.Orientation;
    
    Im_new=imrotate(I,-angle);
    Imask_rotated=imrotate(Im_mask,-angle);
    
    
    L=bwlabel(Imask_rotated);
    
    % Try to find the boundary of the image to determine the image size
    
    Props=regionprops(L,'Extrema');
    
    ext=Props.Extrema;
    
    x_min=round(min(ext(7,1),ext(8,1)));
    x_max=round(max(ext(3,1),ext(4,1)));
    
    y_min=round(min(ext(5,2),ext(6,2)));
    y_max=round(max(ext(1,2),ext(2,2)));
    
    
    
    
    % prevent from out of bound cut
     [m n]=size(Imask_rotated);
    
    i_min=max(y_max,11);
    i_max=min(y_min,m-10);
    
    j_min=max(x_min,11);
    j_max=min(x_max,n-10);
    
    
    
    Im_rotated=Im_new([i_min-10:i_max+10],[j_min-10:j_max+10],:);
    Imask_rotated=Imask_rotated([i_min-10:i_max+10],[j_min-10:j_max+10]);
    
    
    
    % figure('windowstyle','docked')
    % imshow(I_rotated)
    % pause
    % close
    
end



function [I_flipped I_mask]=flip_Embryo(I_rotated,I_mask,output_name,n)

% This program flips the embryo and saves the final image in the main
% folder.
%
% INTPUT
%
% I_rotated - matrix containing the rotated image of the embryo
% Im_mask - index of the image
% output_name - string containing the saving name of the final image
% output_name - string containing the saving name of the final image
% n - Emnum
%
% REVISION HISTORY
%
% 03/22/10 Written by Julien Dubuis
% 01/28/11 Rewritten by Feng Liu

[d1,d2]=size(I_mask);

% flip in AP axis

I_front=I_mask(:,[1:200]);
I_back=I_mask(:,[d2-199:d2]);

% figure('windowstyle','docked')
% subplot(1,2,1); imshow(I_front)
% subplot(1,2,2); imshow(I_back)

size_front=sum(sum(I_front));
size_back=sum(sum(I_back));

% if(size_front>size_back)
%     I_flipped=flipdim(I_rotated,2);
%     I_mask=flipdim(I_mask,2);
% else
%     I_flipped=I_rotated;
% end
     
I_flipped=I_rotated;
% 
%   I_flipped=flipdim(I_rotated,2);
%   I_mask=flipdim(I_mask,2);
% %  
%% flip in DV direction
% 
I_dorsal=I_mask([1:end/2],:);
I_ventral=I_mask([round(d1-end/2+1):d1],:);

size_ventral=sum(sum(I_ventral));
size_dorsal=sum(sum(I_dorsal));

if(size_ventral>size_dorsal)
    I_flipped=flipdim(I_flipped,1);
    I_mask=flipdim(I_mask,1);

end

filename=cat(2,output_name,sprintf('_%03g.tif',n));

if size(I_flipped,3)<=4
imwrite(I_flipped(:,:,1),filename,'tif','compression','none');
elseif size(I_flipped,3)==5
imwrite(I_flipped(:,:,1:end-1),filename,'tif','compression','none');  
filename=cat(2,'DNAimage',sprintf('_%03g.tif',n));
imwrite(I_flipped(:,:,end),filename,'tif','compression','none');   
end

end




