%% Setup and Introduction
% Created by Jialong. Apr. 23. 2018.
% This program help to get the image of the embryo of a plane crossing the 
% main AP axis. The embryo mask and AP axis functions are adapted form 
% Prof. Liu's program. The image stack is placed in the 'c1' folder with a
% z-axis order. 
% Modified & anotated by Bofei Cui.

%% Initialization
% Clear the memory and close all figures.Specify the directory containing data.
clear all;close all;
folderpath= pwd;
folder_ch = strcat(folderpath,'/kfuC3/');
folderName=strcat(folder_ch,'kfu*');
files1 = dir(folderName);
num_pic = size(files1, 1);


%% Parameters
% Most parameters can be applied to most conditions, but some are related
% to specific conditions. Please use the histogram to find suitable
% parameters.
%{
    imgParameters.showPicMin  : The minimum value of image display range
    imgParameters.showPicMax  : The maximum value of image display range
    imgParameters.piicSize    : Size of raw image
    imgParameters.resolution  : Resolution of stack in pixels per dimension , unit : micrometre
    imgParameters.threEm      : Threshold for embryo mask, determined by pixel-intensity histogram
    imgParameters.numAP       : Resolution on the anterior-posterior(AP) axis
    imgParameters.numDV       : Resolution on the dorsal-ventral(DV) axis
    imgParameters.apRatio     : Extension ratio of AP-axis, recommended to be bigger than 1
    imgParameters.dvLeng      : Length of DV, recommended to be equal to or a bit longer than actual 
    dorasl-ventral distance to guarantee the completion
    delta_angle : 
%}
imgParameters=struct();
imgParameters.showPicMin = 250;
imgParameters.showPicMax = 3000;
imgParameters.picSize=[1920,1920];
imgParameters.resolution =[0.286,0.286,1]; 
imgParameters.threEm = 500;
imgParameters.numAP = 2000;
imgParameters.numDV = 800;
imgParameters.apRatio = 1.1;
imgParameters.dvLeng = 400;
delta_angle=pi/36;

%% Show the intensity histogram
% Alternative, help to determine parameters. To switch on, change histoPiic to 1.
histoPic = 0;
if histoPic
    figure
    for iter_pic = 1: num_pic
        if mod(iter_pic, 10) == 1
            disp(iter_pic);
        end    
    pic_name1 = files1(iter_pic).name;
    imm1 = imread(pic_name1);
    pre_imm1 = imm1;
    figure,histogram(pre_imm1);
    imm_adj1 = max(imgParameters.showPicMin, min(pre_imm1, imgParameters.showPicMax));
    [coun, posi] = histcounts(imm_adj1, 100);
    posi(end) = [];
    plot(posi, coun)
    hold on
    end
    hold off
end

%% Prepare data
% Get some necessary information from the images, such as the largest embryo 
% section and the diirection of AP axis.

% The dataset of xyz coordinates and values are super memory consuming.
% We would recommend 20Gb memory to avoid out-of-memory problem. We also
% use the single precision to reduce size. 
% Creation of these large varibles is time-consuming.

% Intermediate parameters:
%{
    midMask     : Embryo mask of the largest section
    recxx,recyy : x&y coordinates of the anterior and posterior of embryo
    axvec       : vector perpendicular to AP axis
%}
prep_data = 1;
if prep_data
    vvv1 = single(zeros(imgParameters.picSize(1), imgParameters.picSize(2), num_pic));
    xx = single(imgParameters.resolution(1) * (1: imgParameters.picSize(1)));
    yy = single(imgParameters.resolution(2) * (1: imgParameters.picSize(2)));
    zz = single(imgParameters.resolution(3) * (1: num_pic));
    [xxx, yyy, zzz] = meshgrid(xx, yy, zz);

    % Find the largest embryo section and the AP axis. 
    aream = 0;
    recz = 1;
    for iter_pic = 1: num_pic
        if mod(iter_pic, 10) == 1
            disp(iter_pic);
        end

        pic_name1 = [files1(iter_pic).folder,'/',files1(iter_pic).name];
        imm1 = imread(pic_name1);
        imm_adj1 = imm1;
        vvv1(:, :, iter_pic) = single(imm_adj1);


        if 90 < iter_pic && iter_pic<120
            [Area,emMask]=K_mask_zhc_2(imm_adj1,imgParameters.threEm);
            areac = max(Area);
            if areac > aream
                aream = areac;
                recz = iter_pic;midMask=emMask;
            end   
        end
    end
    close all
    [recxx, recyy] = myGetAP(midMask,0);
    vvv1 = permute(vvv1, [2, 1, 3]);
end

%% Find the correct intersection plane.
ind1 = sub2ind(size(xxx), recxx(1), recyy(1), recz);
ind2 = sub2ind(size(xxx), recxx(2), recyy(2), recz);
cor1 = [xxx(ind1), yyy(ind1), zzz(ind1)];
cor2 = [xxx(ind2), yyy(ind2), zzz(ind2)];

cor1n = [cor1(2), cor1(1), cor1(3)];
cor2n = [cor2(2), cor2(1), cor2(3)];
cent = 0.5 * (cor1n + cor2n);
cor1ex = imgParameters.apRatio * (cor1n - cent) + cent;
cor2ex = imgParameters.apRatio * (cor2n - cent) + cent;
cut_leng = imgParameters.dvLeng / 2; 
Intensity1=[];

zAngle = -pi/2+delta_angle:delta_angle:pi/2;
dvLeng = imgParameters.dvLeng;
save recz recz
save imgParameters imgParameters

for i=1:length(zAngle)
    zangle = zAngle(i)
    if zangle==pi/2
        axvec=single([0,0,1]);
    else
        axvec = [- cor1ex(2) + cor2ex(2), cor1ex(1) - cor2ex(1)];
        zup = tan(zangle) * norm(axvec);
        axvec = [axvec, zup]; 
    end
    myvec = axvec / norm(axvec) * cut_leng;

numgirdap = imgParameters.numAP;
linexx = linspace(cor1ex(1), cor2ex(1), numgirdap);
lineyy = linspace(cor1ex(2), cor2ex(2), numgirdap);
linezz = linspace(cor1ex(3), cor2ex(3), numgirdap);

numgirdds = imgParameters.numDV;
auxvec = linspace(-1, 1, numgirdds)';
intxx = linexx + auxvec * myvec(1);
intyy = lineyy + auxvec * myvec(2);
intzz = linezz + auxvec * myvec(3);
  
% Make the interpolation 
ap_leng = norm(cor1 - cor2);
apax = linspace(0, ap_leng, numgirdap);
ds_leng = 2 * cut_leng;
dsax = linspace(0, ds_leng, numgirdds);
int_val1 = interp3(xxx, yyy, zzz, vvv1, intxx, intyy, intzz);
int_val1=uint16(int_val1);
imwrite(int_val1,strcat('Em',num2str(i,'%.2d'),'_ch1.tif'));

Intensity1=cat(3,Intensity1,int_val1);
end
save ap_leng ap_leng
%% Image resize, after imresize, the pixel size is 1um/pixel
load imgParameters
load ap_leng
files=dir('Em*ch1.tif');
for i=1:length(files)
    a1=imread(files(i).name,1);
    b1=imresize(a1,[imgParameters.dvLeng,ap_leng*1.1]);
    imwrite(b1,strcat('image_resize',num2str(i,'%.2d'),'_ch1.tif'));
end