 function Emprofile=EmbryosAnalysis_new_triple(Emindlist,Emprofile,num_channels,bin_avg,saveflag)

% This program extracts the intensity profiles on the ventral and dorsal
% side of the embryo and projexts them on the AP axis
%
% INPUT
%
% numbers - indices of the images analyzed
% level - threshold level used to find the mask
% num_channels - # of channels per image
% nbits - quality of the image analyzed (in bits)
% bin_avg - size of the sliding window on which the signal is averaged
%
% OUTPUT
%
% raw_ventral - 1x(#of embryos) structure containing fields .image1,image2, ...
% raw_dorsal - 1x(#of embryos) structure containing fields .image1, image2, ...
%
% REVISON HISTORY
%
% 05/26/10 Written by Julein Dubuis
% 03/11/2011 Rewritten by Feng Liu

if ~exist('num_channels') || isempty(num_channels), num_channels = 1; end

if ~exist('bin_avg') || isempty(bin_avg), bin_avg = 0.001; end

if ~exist('saveflag') || isempty(saveflag), saveflag = 0; end


warning off all


%load Emprofile

%numofEm=length(Emprofile.Em);


for i=1:length(Emindlist)
        
    i
    tic 
   % Eim=Emprofile.Em(i).Emimage;
   
    Emnum=Emprofile.Em(i).Emnum;
    
    Eimfilename=sprintf('Fluimage_%03g.tif',Emnum);
    %Eimfilename=sprintf('Image%02g.tif',Emnum);
    
    Eim=imread(Eimfilename);
    Emmask=Emprofile.Em(i).Emmask;
    %Emmask = flipud(Emmask);
    
    %Eim=Eim(:,:,1:num_channels);
    %Eim=Eim(:,:,3);
   
    
    %[raw_dorsal raw_ventral I_outline APxy]=analyze_Embryo_new(Eim,Emmask,num_channels,bin_avg);   
    
    [raw_dorsal raw_ventral CytoD_raw CytoV_raw I_NucBand I_CytoBand APxy]=analyze_Embryo_new1(Emnum,Eim,Emmask,num_channels,bin_avg);
    
    
    Emprofile.Em(i).Outline=I_NucBand;
    Emprofile.Em(i).CytoBand=I_CytoBand;
    Emprofile.Em(i).APxy=APxy;    
    Emprofile.Em(i).dorsal=raw_dorsal;%dorsal(j,k,i)
    Emprofile.Em(i).ventral=raw_ventral;
    Emprofile.Em(i).Cytodorsal=CytoD_raw;
    Emprofile.Em(i).Cytoventral=CytoV_raw;
    
    
    
    close all
    
    toc
    
    
    end
% if saveflag
%     save Emprofile Emprofile
%     
% end

save Emprofile Emprofile

end


function [raw1 raw2 I_outline APxy]=analyze_Embryo_new(Eim,Emmask,num_channels,bin_avg)

% INPUT
%
% TIF - rotated and flipped image, in TIF format
% level - threshold level used to find the mask
% num_channel - # of channels on the original image
% nbits - quality of the images displayed
% bin_avg - size of the averaging bin (usually 0.001)
%
% OUTPUT
%
% raw1, raw2 - 1x(#of embryos) 
%
% REVISION HISTORY
%
% 
% 03/11/2011 written by Feng Liu



I_tot=uint16(zeros(size(Eim(:,:,1))));

for i=1:num_channels
  I_tot=I_tot+Eim(:,:,i);
end
  

%I_outline=get_Outline(I_tot,Emmask);

[I_NucBand I_CytolBand]=get_NucandCytoband(I,I_mask);

%I_outline=get_Outline(Eim(:,:,DapiChannelnum),Emmask);

[x_top,y_top,x_back,y_back]=get_Axis(Emmask);

APxy=[x_top,y_top,x_back,y_back];



raw1=zeros(1000,4,num_channels);
raw2=zeros(1000,4,num_channels);


for i=1:num_channels  
  [pixelmat1_corrected, pixelmat2_corrected]=measure_CrossIntensity_new(Eim(:,:,i),I_NucBand,bin_avg,x_top,y_top,x_back,y_back);
  raw1(:,:,i)=pixelmat1_corrected;
  raw2(:,:,i)=pixelmat2_corrected;
  display(sprintf('Image %g completed !',i));
end



end


function [pixelmat1_corrected, pixelmat2_corrected]=measure_CrossIntensity_new(I_embryo,I_outline,bin_size,x_top,y_top,x_back,y_back)

% INPUT

% I_embryo - matrix containing the rotated embryo image
% I_outline - matrix containing a mask for the line of nuclei
% bin_size - size of the averaging bin (usually 0.001)
% x_top, y_top, x_back, y_back - positions of the top and the back of the
% AP axis
% 
% OUTPUT
%
% pixelmat1_corrected, pixelmat2_corrected - 2x1000 matrices containing the
% positions and the intensities of the dorsal and ventral profiles resp.
%
% REVISION HISTORY
%
% 05/24/10 Written by Julien Dubuis
% 03/10/11 Rewirten by Feng Liu

%[d1 d2]=size(I_embryo);

%Lets put the head of the embryo in (0,0)

x_back=x_back-x_top; %this is the x-coordinate of the tail in the new frame
%y_back=y_back-y_top; %this is the y-coordinate of the tail in the new frame
APlength=x_back;

[y_ind,x_ind]=find(I_outline>0);
 
x_bis=x_ind-x_top; y_bis=y_ind-y_top;

Dorsal_ind=find(y_bis<=0);
Ventral_ind=find(y_bis>0);

Dorsal_pixel(:,3)=y_ind(Dorsal_ind);
Dorsal_pixel(:,4)=x_ind(Dorsal_ind);
Dorsal_pixel(:,1)=x_bis(Dorsal_ind)/APlength;

Ventral_pixel(:,3)=y_ind(Ventral_ind);
Ventral_pixel(:,4)=x_ind(Ventral_ind);
Ventral_pixel(:,1)=x_bis(Ventral_ind)/APlength;


for i=1:length(Dorsal_pixel(:,1))
 Dorsal_pixel(i,2)=I_embryo(Dorsal_pixel(i,3), Dorsal_pixel(i,4));
end;


for i=1:length(Ventral_pixel(:,1))
 Ventral_pixel(i,2)=I_embryo(Ventral_pixel(i,3), Ventral_pixel(i,4));
end;


[~,order1]=sort(Dorsal_pixel(:,1));
pixelmat1_order=Dorsal_pixel(order1,:);

[~,order2]=sort(Ventral_pixel(:,1));
pixelmat2_order=Ventral_pixel(order2,:);




pixelmat1_corrected=ones(1000,4);
pixelmat2_corrected=ones(1000,4);

k=1;
for i=0:0.001:0.999
    
    imin=max(0,i-bin_size/2);
    imax=min(1,i+bin_size/2);
    
        

    pixelmat1_corrected(k,1)=i;
    indices=find(pixelmat1_order(:,1)>=imin & pixelmat1_order(:,1)<imax);
    pixelmat1_corrected(k,2)=nanmean(pixelmat1_order(indices,2));
    pixelmat1_corrected(k,3)=nanmean(pixelmat1_order(indices,3));
    pixelmat1_corrected(k,4)=nanmean(pixelmat1_order(indices,4));

    pixelmat2_corrected(k,1)=i;
    indices=find(pixelmat2_order(:,1)>=imin & pixelmat2_order(:,1)<imax);
    pixelmat2_corrected(k,2)=nanmean(pixelmat2_order(indices,2));
    pixelmat2_corrected(k,3)=nanmean(pixelmat2_order(indices,3));
    pixelmat2_corrected(k,4)=nanmean(pixelmat2_order(indices,4));
    
    k=k+1;
end

end




function I_outline=get_Outline(I,I_mask)

% INPUT
%
% I - matrix containing the sum of all channels
% level - threshold level used to find the mask
% nbits - quality of the images displayed
%
% OUTPUT
%
% I_outline - matrix containing the mask of the outline
% I_mask - matrix containing the mask of the embryo
%
%
% REVISION HISTORY
%
% 21/05/10 Written by Julien Dubuis




erode1=[10:2:70];
erode2=[0:1:30];
intensity=zeros(1,31);

for i=1:31
se = strel('disk',erode1(i));
erodedBW = imerode(I_mask,se);
I_patch1=I_mask-erodedBW;

se = strel('disk',erode2(i));
I_patch2 = imerode(I_patch1,se);

I_final=zeros(size(I));

I_final(find(I_patch2==1))=I(find(I_patch2==1));

intensity(i)=sum(sum(I_final));

I_final=uint16(I_final);

end

if max(intensity)>0
    i_max=find(intensity==max(intensity));
else   
    i_max=1;    
end

% disp(erode1(i_max))
% disp(erode2(i_max))

se = strel('disk',erode1(i_max));
erodedBW = imerode(I_mask,se);
I_patch1=I_mask-erodedBW;

se = strel('disk',erode2(i_max));
I_patch2 = imerode(I_patch1,se);

I_final=zeros(size(I));

I_final(find(I_patch2==1))=I(find(I_patch2==1));
I_final=uint16(I_final);

figure('windowstyle','docked')

subplot(1,2,1); imshow(I,[min(I(:)) max(I(:))]), title('I')
subplot(1,2,2); imshow(I_final,[min(I(:)) max(I(:))]), title('I final')

% pause
% close
% 
% reply = input('Are you satisfied with the outline? Y/N [Y]: ', 's');
% if isempty(reply)
%     reply = 'Y';
% end
% 
% while(reply=='N')
%     erode1 = input('Please enter a new value for erode1 : ');
%     erode2 = input('Please enter a new value for erode2 : ');
%     se = strel('disk',erode1);
%     erodedBW = imerode(I_mask,se);
%     I_patch1=I_mask-erodedBW;
% 
%     se = strel('disk',erode2);
%     I_patch2 = imerode(I_patch1,se);
% 
%     I_final=zeros(size(I));
% 
%     I_final(find(I_patch2==1))=I(find(I_patch2==1));
% 
%     I_final=uint16(I_final);
% 
%     subplot(1,2,1); imshow(I,[min(I(:)) max(I(:))]), title('I')
%     subplot(1,2,2); imshow(I_final,[min(I(:)) max(I(:))]), title('I final')
%     
%     pause
%     close
% 
%     reply = input('Are you satisfied with the outline? Y/N [Y]: ', 's');
%     if isempty(reply)
%         reply = 'Y';
%     end
% end


I_outline=I_final;
end




function[x_top,y_top,x_back,y_back]=get_Axis(I_mask)

% INPUT
%
% I_embryo - matrix containing the image of the embryo
% I_mask - matrix containg the mask of the embryo
%
% OUTPUT
%
% x_top,y_top,x_back,y_back - positions of the top and the back of the
% AP axis
%
% REVISION HISTORY
%
% 05/24/10 Written by Julien Dubuis

L=bwlabel(I_mask);
Props=regionprops(L,'Extrema');

ext=Props.Extrema;

x_top=round(ext(8,1));
y_top=round(0.5*(ext(7,2)+ext(8,2)));

y_back=y_top;

L2=bwlabel(I_mask(y_top,:));
Props2=regionprops(L2,'Extrema');

ext2=Props2.Extrema;

x_back=round(ext2(3,1));

% figure, imshow(imadjust(I_embryo)), title('Please double-click on the head of the embryo and press Enter')
% 
% pause
% 
% [x y]=getpts;
% 
% x_top_bis=round(x);
% y_top_bis=round(y);
% 
% close
% 
% figure, imshow(imadjust(I_embryo)), title('Please double-click on the tail of the embryo and press Enter')
% 
% pause
% 
% [x y]=getpts;
% 
% x_back_bis=round(x);
% y_back_bis=round(y);
% 
% close
end





