function [raw1 raw2 CytoD_raw CytoV_raw I_NucBand I_CytolBand APxy]=analyze_Embryo_new1(Emnum,Eim,Emmask,num_channels,bin_avg)

% INPUT
%
% TIF - rotated and flipped image, in TIF format
% level - threshold level used to find the mask
% num_channel - # of channels on the original image
% nbits - quality of the images displayed
% bin_avg - size of the averaging bin (usually 0.001)
%
% OUTPUT
%
% raw1, raw2 - 1x(#of embryos) 
%
% REVISION HISTORY
%
% 
% 03/11/2011 written by Feng Liu



%I_tot=sum(Eim,3);
%I_tot=Eim;
I_tot=Eim(:,:,1);


%I_outline=get_Outline(I_tot,Emmask);

%[I_NucBand I_CytolBand]=get_NucandCytoband(Emnum,I_tot,Emmask);%nuc channelband
[I_NucBand I_CytolBand]=get_NucandCytoband_yz(Emnum,I_tot,Emmask);%nuc channelband

%I_outline=get_Outline(Eim(:,:,DapiChannelnum),Emmask);

[x_top,y_top,x_back,y_back]=get_Axis(Emmask);

APxy=[x_top,y_top,x_back,y_back];



raw1=zeros(1000,4,num_channels);
raw2=zeros(1000,4,num_channels);

CytoD_raw=zeros(1000,4,num_channels);
CytoV_raw=zeros(1000,4,num_channels);


for i=1:num_channels  
  [pixelmat1_corrected, pixelmat2_corrected]=measure_CrossIntensity_new(Eim(:,:,i),I_NucBand,bin_avg,x_top,y_top,x_back,y_back);
  raw1(:,:,i)=pixelmat1_corrected;%dorsal
  raw2(:,:,i)=pixelmat2_corrected;
  
  [pixelmat1_corrected, pixelmat2_corrected]=measure_CrossIntensity_new(Eim(:,:,i),I_CytolBand,bin_avg,x_top,y_top,x_back,y_back);
  CytoD_raw(:,:,i)=pixelmat1_corrected;
  CytoV_raw(:,:,i)=pixelmat2_corrected;
  
  display(sprintf('Image %g completed !',i));
end

end





