function [I_NucBand I_CytolBand]=get_NucandCytoband_yz(Emnum,I,I_mask,Bandwidth,Searchwidth)

% INPUT
%
% I - matrix containing the sum of all channels
% level - threshold level used to find the mask
% nbits - quality of the images displayed
%
% OUTPUT
%
% NucBand - matrix containing the mask of the outline
% I_mask - matrix containing the mask of the embryo
%
%
% REVISION HISTORY
%
% 21/05/10 Written by Julien Dubuis
% add 

% if ~exist('Bandwidth') || isempty(Bandwidth), Bandwidth = 15; end
% if ~exist('Searchstep') || isempty(Searchwidth), Searchstep = 40; end


% erode1=10:2:70;
% erode2=0:1:30;
% intensity=zeros(1,31);

% erode1=Bandwidth:1:(Bandwidth+(Searchstep-1)*2);
% erode2=0:1:(Searchstep-1);
% intensity=zeros(1,Searchstep);


Eim_a = I;
embryomask = I_mask;
medI = I;

depth = 50;%50
intensity_total=zeros(1,depth);
intensity_mean=zeros(1,depth);
filter4band = [0 1 0;1 1 1;0 1 0];


for i = 1 : depth
    erode = strel ('disk',i);
    Edge = bwperim (imerode (embryomask,erode), 8);%8
    Band2test0 = imfilter (Edge, filter4band);
    Band2test = logical(Band2test0 >0);
    plocation = find (Band2test==1);
    I_test = zeros(size(Eim_a));
    for j = 1:size(plocation,1)
        I_test(plocation(j))=medI(plocation(j));
    end
    pixel = find(Band2test == 1);
    pixelsize = size (pixel, 1);
    intensity_total(i) = sum(sum(I_test));
    intensity_mean (i) = intensity_total(i)/pixelsize;
end

[xmax, ymax, wmax, pmax] = findpeaks (intensity_mean);
figure, findpeaks (intensity_mean,'Annotate','extents','MinPeakWidth',10);% % title (cat(2, 'frame',num2str(frame)))
% [xmax, ymax, wmax, pmax] = findpeaks (intensity_total);
% figure, findpeaks (intensity_total,'Annotate','extents','MinPeakWidth',10); % title (cat(2, 'frame',num2str(frame)))


    [wmax_a wmax_p] = max(wmax);
%     wmax_a=wmax(1);wmax_p=1;
    r_major = round(max(wmax)/2);
    [xmin, ymin] = findpeaks ((-1) * intensity_mean);
    
    
    Bandwidth = fix(max(wmax/2));%% need to modify
%     Bandwidth = 8;
    
    %Bandwidth = fix(ymax)-3;
    inner_nucleimask = imerode (embryomask,strel ('disk',ceil(ymax(wmax_p))));%% need to modify
%     inner_nucleimask = imerode (embryomask,strel('disk',9));%% need to modify

    
    FinalCenter_NucleiBand = bwperim (inner_nucleimask , 8);
    I_CytolBand = FinalCenter_NucleiBand;
    NucleiBandMask =  imdilate (FinalCenter_NucleiBand, strel ('disk', Bandwidth));
    I_final=zeros(size(I));
    I_final(NucleiBandMask==1)=I(NucleiBandMask==1);
    
    I_NucBand=uint16(I_final);
    %        I_NucBand1 = NucleiBandMask;
    %        I_NucBand1(I_NucBand1==1) = I(I_NucBand1 == 1);
    %        I_NucBand=uint16(I_NucBand1);
    I_CytolBand=uint16(I_CytolBand);
    
    figure('windowstyle','docked')
    subplot(1,2,1); imshow(I,[min(I(:)) max(I(:))]), title('I')
    subplot(1,2,2); imshow(I_final,[min(I(:)) max(I(:))]), title('I final')
    saveas(gcf,['Emnum',num2str(Emnum),'.tif']);
    %     pause
    %     close
    %
    %     reply = input('Are you satisfied with the outline? Y/N [Y]: ', 's');
    %     if isempty(reply)
    %         reply = 'Y';
    %     end




end
