function [pixelmat1_corrected, pixelmat2_corrected]=measure_CrossIntensity_new(I_embryo,I_outline,bin_size,x_top,y_top,x_back,y_back)

% INPUT

% I_embryo - matrix containing the rotated embryo image
% I_outline - matrix containing a mask for the line of nuclei
% bin_size - size of the averaging bin (usually 0.001)
% x_top, y_top, x_back, y_back - positions of the top and the back of the
% AP axis
% 
% OUTPUT
%
% pixelmat1_corrected, pixelmat2_corrected - 2x1000 matrices containing the
% positions and the intensities of the dorsal and ventral profiles resp.
%
% REVISION HISTORY
%
% 05/24/10 Written by Julien Dubuis
% 03/10/11 Rewirten by Feng Liu

%[d1 d2]=size(I_embryo);

%Lets put the head of the embryo in (0,0)

x_back=x_back-x_top; %this is the x-coordinate of the tail in the new frame
%y_back=y_back-y_top; %this is the y-coordinate of the tail in the new frame
APlength=x_back;

[y_ind,x_ind]=find(I_outline>0);
 
x_bis=x_ind-x_top; y_bis=y_ind-y_top;%this is the coordinate of the position in the new frame

Dorsal_ind=find(y_bis<=0);%dorsalλ
Ventral_ind=find(y_bis>0);

Dorsal_pixel(:,3)=y_ind(Dorsal_ind);%ԭʼx
Dorsal_pixel(:,4)=x_ind(Dorsal_ind);%ԭʼy
Dorsal_pixel(:,1)=x_bis(Dorsal_ind)/APlength;%ͼеxλapԱDorsal_pixel(:,2)ǿ
Ventral_pixel(:,3)=y_ind(Ventral_ind);
Ventral_pixel(:,4)=x_ind(Ventral_ind);
Ventral_pixel(:,1)=x_bis(Ventral_ind)/APlength;


for i=1:length(Dorsal_pixel(:,1))
 Dorsal_pixel(i,2)=I_embryo(Dorsal_pixel(i,3), Dorsal_pixel(i,4));%dosalıǿ
end;


for i=1:length(Ventral_pixel(:,1))
 Ventral_pixel(i,2)=I_embryo(Ventral_pixel(i,3), Ventral_pixel(i,4));
end;


[~,order1]=sort(Dorsal_pixel(:,1));%̥ϵλ
pixelmat1_order=Dorsal_pixel(order1,:);

[~,order2]=sort(Ventral_pixel(:,1));
pixelmat2_order=Ventral_pixel(order2,:);




pixelmat1_corrected=ones(1000,4);
pixelmat2_corrected=ones(1000,4);

k=1;
for i=0:0.001:0.999
    
    imin=max(0,i-bin_size/2);
    imax=min(1,i+bin_size/2);
    
        

    pixelmat1_corrected(k,1)=i;%һУdorsalλ1-1000/EL
    indices=find(pixelmat1_order(:,1)>=imin & pixelmat1_order(:,1)<imax);
    pixelmat1_corrected(k,2)=nanmean(pixelmat1_order(indices,2));%ڶбǿ    %˲nan
    pixelmat1_corrected(k,3)=nanmean(pixelmat1_order(indices,3));%ԭʼy
    pixelmat1_corrected(k,4)=nanmean(pixelmat1_order(indices,4));%ԭʼx

    pixelmat2_corrected(k,1)=i;%ventral
    indices=find(pixelmat2_order(:,1)>=imin & pixelmat2_order(:,1)<imax);
    pixelmat2_corrected(k,2)=nanmean(pixelmat2_order(indices,2));
    pixelmat2_corrected(k,3)=nanmean(pixelmat2_order(indices,3));
    pixelmat2_corrected(k,4)=nanmean(pixelmat2_order(indices,4));
    
    k=k+1;
end

end