function [emMask] = myEmMask(im, thres, fig)

    if ~exist('fig') || isempty(fig), fig = 0; end
    
    noisyOutline = bwareaopen(im > thres, 10, 4);
    
    se90=strel('line',3,90); se0=strel('line',3,0);
    Outlinedil=imdilate(noisyOutline,[se90 se0]);
    
    L = bwlabel(Outlinedil);
    A = regionprops(L, 'Area');
    areas = [A.Area];
    if size(areas, 1) == 0
        emMask = zeros(size(im));
        return
    end    
    biggestRegion = find(max(areas) == areas);
    outline = (L == biggestRegion);   

    %Eim=double(im).*double(~(Outlinedil-outline));

    noisyMask = imfill(outline, 'holes'); 
    noisyMasknobord=imclearborder(noisyMask, 8);
    seD=strel('diamond', 2);
    emMask=imerode(imerode(imerode(noisyMasknobord, seD), seD), seD);
    
    if fig    
        figure
        imagesc(emMask)
    end
end


