#!/bin/bash

# This code chunk should be run from a directory containing the sequence files in fastq.gz format. The value of non-variable arguments are taken from Salmon's documentation.

# $1 is the library type. Stranded and forward strand is SF, unstranded is U, to make Salmon guess use A.
# $2 number of processors to be used by Salmon
# $3 and $4 are the mean and SD of fragment length, respectively.

for i in *.fastq.gz;
do

echo "working on ${i}"
salmon quant -i "/home/nico/Software/Salmon/decoy_mouse_index/combined_index" -l $1 -r ${i} -p $2 --fldMean $3 --fldSD $4 --validateMappings --rangeFactorizationBins 4 --seqBias --gcBias --biasSpeedSamp 10 -o ../quants/${i}_quant

done

