clear; close all; clc;
Folder_path = cd;

nameofcell = 'ABa-ABp';
analysis_cellstage = strcat('/Analysis_pivlab_',nameofcell);

% %Create save directory
% if exist(strcat(Folder_path,'/Analysis'),'dir') ~= 7 %check if the directory exists
%    mkdir(strcat(Folder_path,'/Analysis'));
% end

dirOutput = dir(strcat(Folder_path,'/*.tif'));  % creates a structural array from the current directory and select only the tif files
fileNames = {dirOutput.name}';                  % generates a cell array with the names of the tif files

lasercuttingdata = 0    ;cut = 7;
fn = 1; beginframe=1;
%lastframe = 122;
lastframe = numel(imfinfo(fileNames{fn}));
timeinterval = 3 ;

mkdir(strcat(Folder_path,'/Spindle_length-',nameofcell,'/segementedimages/segementedimages'));

%%Define pixel_size in um
pix = 0.106; %0.106; %0.2257;
% I=imread(fileNames{fn},4);
% imagesc(I);
% [Imask, x_ROI, y_ROI] = roipoly;
% Imask = double(Imask);
% Imask(Imask==0) = NaN;

%%If necessary, define an ROI (on last frame)
I  = imread(fileNames{fn},beginframe);   % Reads the first frame 
I2 = imread(fileNames{fn},lastframe);    % Reads the last frame
TTT = imfuse(I,I2);                      % fuses the two so we do not have any other bright spots 
imshow(TTT,'InitialMagnification',350);
[BW, x_ROI, y_ROI] = roipoly;

fileNames{fn}

%script for lasercut needs two theresholds since itensities go down after
%the laser cut
%%Threshold at 2*level for pre-cut and 0.7*level for post-cut
%%We can automatized the cutting frame identification in the metadata:

%Find cut .txt file
% Cut = dir('*_0.txt');
% cuttinglogfile = {Cut.name}';
% namecuttinglogfile = cuttinglogfile{:};
% frameofcutting_cell=strrep(cuttinglogfile,'_0.txt','');

%%Preassign result matrix
Spindle_length = zeros(lastframe,1);
Centr_coord = [];
%%
if lasercuttingdata == 1
    %%Loop for precut frames
    for i = 1:cut-1;
        cutoff_intensity = 2.0;
        segment_spindle_points
    end
    
    %%Loop for postcut frames
    for i = cut:cut+10
        cutoff_intensity = 1.8;
        segment_spindle_points
    end
    
    for i = cut+11:lastframe;
        cutoff_intensity = 1.7;
        segment_spindle_points
    end
    
    plot(Spindle_length); hold on; % values are in micrometers
    xlabel('Time');ylabel('Distance in micrometeres');
       

%%
elseif lasercuttingdata == 0
    
    
    for i = beginframe:lastframe;
        cutoff_intensity = 1.3;
        segment_spindle_points
    end
    
    for i = 1 : lastframe
        check2bsane(i,1) = pdist([Centr_coord(i,1),Centr_coord(i,2)...
            ;Centr_coord(i,3),Centr_coord(i,4)], 'Euclidean');  % value in pixels
    end
    plot(Spindle_length); hold on; % values are in micrometers
    xlabel('Time');ylabel('Distance in micrometeres');hold off;figure(1001);
    plot(check2bsane);hold on; ylabel('Distance in pixels');hold off;
    %mark_spindle_positions;
    xlabel('Time');ylabel('Spindle Length');
    axis([0 length(check2bsane) 0 inf]);
end
%%

for i = 1: length(Centr_coord)
    
    point1 = [Centr_coord(i,1) Centr_coord(i,2)];
    point2 = [Centr_coord(i,3) Centr_coord(i,4)];
    midpoint(i,1:2)= (point1(:) + point2(:)).'/2;
end

save(strcat(Folder_path,'/Spindle_length-',nameofcell,'/matfile-spindle_length','.mat'));
