I=double(imread(fileNames{fn},i));
%Iorig = I;
%I = uint8 (I / 256);
h=fspecial('gaussian',2, 2); % Blurs the image
Ifilt = imfilter(I,h);
Is=uint8(scaled(Ifilt));     % make binary image
level = graythresh(Is);
It=im2bw(Is,cutoff_intensity*level);
It_mask = It.*BW;
figure(i), imshow(It_mask,'DisplayRange', []);hold on;
Itb = bwlabel(It_mask);
Stats = regionprops(Itb, {'Area','PixelIdxList', 'Centroid'});
[tmp ind]=sort([Stats.Area], 'descend');
Stats=Stats(ind);
%lets delete the frames if in case the other spindle pole is not detected.,
%this is done only because matlab starts giving random values if there are
%no two blobs. recommeded - manual marking of the spindle poles for few
%frames. 
if (numel([Stats.Area])) == 1 | (numel([Stats.Area])) == 0
    %Spindle_length(i, 1) = pix * 0;
    Spindle_length(i, 1) = NaN;
    Centr_coord(i,1:2) = NaN;
    Centr_coord(i,3:4) = NaN;
    cent1 = NaN;cent2 = NaN;
else
    [cent1,cent2]= Stats.Centroid;
    Centr_coord(i,1:2) = cent1;
    Centr_coord(i,3:4) = cent2;
    D = norm(cent1 - cent2);
    Spindle_length(i, 1) = pix * D;
    scatter(cent1(1),cent1(2),'ro');
    scatter(cent2(1),cent2(2),'ro');
end

hold off;
saveas(gcf,strcat(Folder_path,'/Spindle_length-',nameofcell,'/segementedimages/',mat2str(i)),'tif');
close(figure(i));

% h = histogram(Iorig);
% fit_g = fit([h.BinLimits(1):h.BinWidth:h.BinLimits(2)-h.BinWidth]',h.BinCounts','gauss2');
% hold on; 
% plot(fit_g);
