#!/usr/bin/python

import wx,os,sys,re
import numpy as np

class MainLibModGUI(wx.Frame):

	def __init__(self,parent):
		wx.Frame.__init__(self,parent,wx.ID_ANY,"Library change GUI",size=(1000,900))
		self.panel = wx.Panel(self,wx.ID_ANY)
		self.textDisp()
		self.textEntry()
		self.textDialog()
		self.textButton()
		
	
	def textDisp(self):
		#self.box = wx.BoxSizer(self.panel,wx.VERTICAL)
		self.textBox_input = wx.StaticText(self.panel,wx.ID_ANY,"Enter the input file downloaded from Blastp site:" ,pos=(10,10),size=(350,50),style=wx.TE_RIGHT)
		self.textBox_output = wx.StaticText(self.panel,wx.ID_ANY,"Enter the Output file name:",pos=(10,48),size=(350,50),style=wx.TE_RIGHT)
		#self.box.Add(self.textBox_input,0,wx.EXPAND)
		#self.box.Add(self.textBox_output,1,wx.EXPAND)
		#self.SetSizer(self.box)

	def textEntry(self):
		size_file = (500,30);size_num = (100,30)
		self.textent_input = wx.TextCtrl(self.panel,wx.ID_ANY,"",pos=(400,6),size=size_file,style=wx.TE_LEFT|wx.TE_PROCESS_ENTER)
		self.textent_input.SetInsertionPoint(0)
		self.textent_output = wx.TextCtrl(self.panel,wx.ID_ANY,"",pos=(400,40),size=size_file,style=wx.TE_LEFT|wx.TE_PROCESS_ENTER)

	wildcard = "output (*.out)|*.out|library (*.lib)|*.lib|seqdump (*.seqdump)|*.seqdump|text (*.txt)|*.txt|All files()|*"

	def textDialog(self):
		self.dlgbutton1 = wx.Button(self.panel,label="dir...",pos=(900,6),size=(80,30))
		self.dlgbutton1.Bind(wx.EVT_BUTTON,self.OnDlg1,self.dlgbutton1)
		self.dlgbutton2 = wx.Button(self.panel,label="dir...",pos=(900,40),size=(80,30))
		self.dlgbutton2.Bind(wx.EVT_BUTTON,self.OnDlg2,self.dlgbutton2)

	def textButton(self):
		self.button1 = wx.Button(self.panel,label="OK",pos=(300,200),size=(100,30))
		self.Bind(wx.EVT_BUTTON,self.OnOK,self.button1)
		self.button2 = wx.Button(self.panel,label="Cancel",pos=(600,200),size=(100,30))
		self.Bind(wx.EVT_BUTTON,self.OnCancel,self.button2)
		self.checkBox = wx.CheckBox(self.panel,label='r_deleter on',pos=(10,100))
		self.checkBox.SetValue(True)
		#self.checkBox.Bind(wx.EVT_CHECKBOX, self.R_DELETER)


	#When we set self.checkBox.Bind(wx.EVT_CHECKBOX, self.R_DELETER), then the check status seemed to be reflected every time
	#when we click the check box.

	#def R_DELETER(self,e):
		#sender = e.GetEventObject()
		#isChecked = sender.GetValue()
	
		#if isChecked:
		#	self.r_del = 1
		#else:
		#	self.r_del = 0
		#print self.r_del

	def OnDlg1(self,event):
		dlg = wx.FileDialog(self, "Select the file.",os.getcwd(),style=wx.FD_OPEN,wildcard=self.wildcard)
		text_inp = []
		if dlg.ShowModal() == wx.ID_OK:
			text_inp = dlg.GetPath()
			self.textent_input.AppendText(text_inp)
		dlg.Destroy()

	def OnDlg2(self,event):
		dlg = wx.FileDialog(self, "Select the file.",os.getcwd(),style=wx.FD_OPEN,wildcard=self.wildcard)
		text_inp = []
		if dlg.ShowModal() == wx.ID_OK:
			text_out = dlg.GetPath()
			self.textent_output.AppendText(text_out)
		dlg.Destroy()

	def OnOK(self,event):
		self.input_file = self.textent_input.GetValue()
		self.output_file = self.textent_output.GetValue()
		self.process_rdel = self.checkBox.GetValue()
		self.execProgram()

	def execProgram(self):
		if self.process_rdel == 1:
			#print "r_deleter_on"
			exe_rdelet = os.system('python ./r_deleter.py -INPUT '+self.input_file)

		execution = os.system('python ./Library_change.py -INPUT '+self.input_file+' -OUTPUT '+self.output_file)
		if(execution == 0):
			dlg = wx.MessageDialog(None,"The file format could be converted correltly.","Program succeeded" ,wx.OK)
			dlg.ShowModal()
		else:
			dlg = wx.MessageDialog(None,"The file could not be converted. Please confirm your input file.","Program failed",wx.ICON_ERROR)
			dlg.ShowModal()

	def OnCancel(self,event):
		self.textent_input.Clear()
		self.textent_output.Clear()

	def errorProgram(self):
		print "error"
		dlg = wx.MessageDialog(None,"Error! Please input the file name!", "Program Error",wx.ICON_ERROR)
		dlg.ShowModal()

if __name__=='__main__':
	app = wx.PySimpleApp()
	frame = MainLibModGUI(None)
	frame.Show()
	app.MainLoop()


