%% from Kan, Enos, Korkmazhan et al., 2020; Part 1

%this code uses output from u-track software (Jaqaman et al., 2008)
%Many bits of code here are adopted from Mathworks tutorials/posts and
%forums like GitHub

%need to run this code by changing names appropriately for each Wnt and control
%pool to accumulate into the relevant megapool array (see Part 2) 

%components to try in gaussian mixture model comparisons. Will compare
%models of 1 component, 2 components, 3 components etc
componentstotry=10; %as large as possible 
%need to try component number larger than final best fit component number

%for fitgmdist later
replicates=25;
iterations=500;
reps=100;
mintracklength=10; %minimum length of a single molecule track considered will be mintracklength
%Reminder that videos include only first 40 frames of imaging. See Methods

%this example is for "Wnt Pool 1" but the same code is used for Wnt Pool 2,
%Control Pool 1 etc by changing variable names appropriately. 
%in this case amplitudeswp1 is for Wnt Pool 1.
amplitudeswp1=[]; %will have a list of ampliotudes in first frame of tracks
analyzefolder='190613_wntpool1_angle0613-1_blue82p5';
for i=1:200
    if 7==exist(['C:\dishvld_cellb_analysis\utrack_1\' analyzefolder '\reg' num2str(i) '\TrackingPackage\tracks'],'dir')
        load(['C:\dishvld_cellb_analysis\utrack_1\' analyzefolder '\reg' num2str(i) '\TrackingPackage\tracks\Channel_1_tracking_result.mat'])
        %take tracks that were at least mintracklength frames long and take
        %gather first recorded amplitude value
        for ii=1:length(tracksFinal)
            if tracksFinal(ii).seqOfEvents(2,1)-tracksFinal(ii).seqOfEvents(1,1)>mintracklength
                amplitudeswp1=[amplitudeswp1;tracksFinal(ii).tracksCoordAmpCG(4)];
            end
                
        end        
        clearvars -except megapoolwnt megapoolcontrol reps amplitudeswp1 componentstotry iterations mintracklength replicates analyzefolder cp2monomermu cp1monomermu wp2monomermu wp1monomermu
    end
end
clear i
clear ii


maxamp=max(amplitudeswp1);


%max iteration is 100 by default. Changed options in fitgmdist to increase
%Try upto componentstotry Gaussian mixture mode components and compare BIC
%or AIC

%Below code adopted from Mathworks tutorials

%Fitting process

%note will need to change if using AIC for model selection
BIC = zeros(1,componentstotry);
gmms = cell(1,componentstotry); %Gaussian mixture models
for k = 1:componentstotry
    gmms{k} = fitgmdist(amplitudeswp1,k,'Options',statset('MaxIter',iterations),'Replicates',reps);
    BIC(k)= gmms{k}.BIC; %use .AIC if using AIC for model selection " gmms{k}.AIC; "
end
[minBIC,numComponents] = min(BIC); %get number of components in mixture model minimizing BIC or AIC
numComponents

%from mathworks tutorials

gmmwinner=gmms{numComponents};

%
gmmwinnerPDF = @(x)reshape(pdf(gmmwinner,[x(:)]),size(x));

%correct for imperfect background subtraction amd normalize as
%described in Methods

differenceofmonomeranddimer=(min(gmmwinner.mu(gmmwinner.mu~=min(gmmwinner.mu)))-min(gmmwinner.mu));
conservativebackgroundval=max((min(gmmwinner.mu)-differenceofmonomeranddimer));
figure
nobackground_renorm=(amplitudeswp1-conservativebackgroundval)/differenceofmonomeranddimer;
myhist=histogram(nobackground_renorm(nobackground_renorm>0),'Normalization','pdf','FaceAlpha',0.1);
hold on
ylabel(' Probability Density');
xlabel(' Background corrected intensity ratio to single GFP');
title('Wnt Pool 1');
hold off

%add onto megapool of Wnt. In control files, do same but now with megapoolcontrol
megapoolwnt=[megapoolwnt;nobackground_renorm(nobackground_renorm>0)];