/*Diffusion and Binding*/
/*1 dimensional space*/
/*Mochi110606*/
/* dx*Nmax=100 micro meter
   dt*Tend=10 seconds */

#define Nmax 10000
#define Tout 5000
#define Tend 100
#define DU		20.0
#define Gamma 1.0 /*00.0*/
#define dt		0.0001
#define dx		0.1
#define Gmx  11
#include <time.h>
#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#define drand() ((double)rand()/((double)RAND_MAX+1.0))

double grand(){ return drand()+drand()+drand()+drand()+drand()+drand()+drand()+drand()+drand()+drand()+drand()+drand()-6.0; }

void init(u,v,A,B,D)
	double u[Nmax+2],v[Nmax+2],A[Nmax+2],B[Nmax+2],D[Nmax+2];
{
	int i;
	srand(56);
		for(i=1;i<Nmax+1;++i){
			if(i*dx<=1.0){
				u[i]=0.0; /*10.0*/
			}
			else{
				u[i]=0.0;
			}
		}
		for(i=1;i<Nmax+1;++i){
			v[i]=0.0;
		}

		for(i=1;i<Nmax+1;++i){
			if(/*i%20==17||*/i%20==18||i%20==19/*||i%20==0*/){
				A[i]=10.0;
			}
			else{
				A[i]=0.0;
			}
		}
		for(i=1;i<Nmax+1;++i){
			B[i]=0.1;
		}

		for(i=1;i<Nmax+1;++i){
			D[i]=0.01;
		}

}

void initR(u,v,A,B,D)
	double u[Nmax+2],v[Nmax+2],A[Nmax+2],B[Nmax+2],D[Nmax+2];
{
	int i;
	//	srand(56);
	srand(time(NULL));
		for(i=1;i<Nmax+1;++i){
			if(i*dx<=1.0){
				u[i]=0.0; /*10.0*/
			}
			else{
				u[i]=0.0;
			}
		}
		for(i=1;i<Nmax+1;++i){
			v[i]=0.0;
		}
		//		srand(time(NULL));
		for(i=1;i<Nmax+1;++i){
			if(/*i%20==17||*/i%20==18||i%20==19/*||i%20==0*/){
				//A[i]=10.0;
				A[i] = 0.1;
				double a = A[i-1]*grand();
				A[i] = 0.1<a?a:0.1;
			}
			else{
				A[i]=0.0;
			}
		}
		for(i=1;i<Nmax+1;++i){
			B[i]=0.1;
		}

		for(i=1;i<Nmax+1;++i){
			D[i]=0.01;
		}

}


void calcu(u,v,A,B,du,dxdt,ru)
	double u[Nmax+2],v[Nmax+2];
	double A[Nmax+2],B[Nmax+2];
	float du;
	float dxdt;
	double ru[Nmax+2];
{
	int i;
	
/*	for(i=1;i<Nmax+1;++i){
		ru[i]=u[i]+du*dxdt*(u[i+1]-2.0*u[i]+u[i-1])+
		dt*Gamma*(-A[i]*u[i]+B[i]*v[i]);
	}*/
	for(i=1;i<Gmx;++i){
		ru[i]=u[i]+du*dxdt*(u[i+1]-2.0*u[i]+u[i-1])+
		dt*Gamma*(0.2-A[i]*u[i]+B[i]*v[i]);
	}
	for(i=Gmx;i<Nmax+1;++i){
		ru[i]=u[i]+du*dxdt*(u[i+1]-2.0*u[i]+u[i-1])+
		dt*Gamma*(-A[i]*u[i]+B[i]*v[i]);
	}
}

void calcv(v,u,A,B,D,dxdt,rv)
	double v[Nmax+2],u[Nmax+2];
	double A[Nmax+2],B[Nmax+2],D[Nmax+2];
	float dxdt;
	double rv[Nmax+2];
{
	int i,j;
	
	for(i=1;i<Nmax+1;++i){
		rv[i]=v[i]+dt*Gamma*(A[i]*u[i]-B[i]*v[i]-D[i]*v[i]);
	}
}

void output(x,filename)
	double x[Nmax+2];
	char filename[20];

{
	int i,j;
	FILE	*fp;
	
	fp=fopen(filename,"a");
	
	for(i=1;i<Nmax+1;++i){
		fprintf(fp," %lf",x[i]);
	}
	fprintf(fp,"\n");
	fclose(fp);
}

void output4gplt(x,y,filename)
	double x[Nmax+2];
	double y[Nmax+2];
	char filename[20];
{
	int i,j;
	FILE	*fp;
	
	fp=fopen(filename,"a");
	
	for(i=1;i<Nmax+1;++i){
		fprintf(fp,"%d %lf %lf\n",i,x[i],y[i]);
	}
	fprintf(fp,"\n\n");
	fclose(fp);
}

void output4gplt_fit(x,y,filename)
	double x[Nmax+2];
	double y[Nmax+2];
	char filename[20];
{
	int i,j;
	FILE	*fp;
	
	fp=fopen(filename,"a");
	FILE* fpp = fopen("exp_fit.dat","w");
	for(i=1;i<Nmax+1;++i){
		fprintf(fp,"%d %lf %lf\n",i,x[i],y[i]);
		float xx = i*0.1;
		if(y[i]>0.00000001)fprintf(fpp,"%f %f\n",xx,y[i]);
	}
	fprintf(fp,"\n\n");
	fclose(fp);
	fclose(fpp);
}

int main(){
	FILE	*fp;
	double u1[Nmax+2],v1[Nmax+2];
	double u2[Nmax+2],v2[Nmax+2];
	double A[Nmax+2],B[Nmax+2],D[Nmax+2];
	float dxdt;
	int 	i,j,t,s;
	int 	kok;
	char	filename[20];
	float base;
	
	/*input initial&parameters*/
	dxdt=dt/dx/dx;

	init(u1,v1,A,B,D);
	
	fp=fopen("dists_uv.dat","w");
	fclose(fp);
	/*
	fp=fopen("outu","w");
	fclose(fp);
	fp=fopen("outv","w");
	fclose(fp);
	output(u1,"outu");
	output(v1,"outv");
	*/

	/*large loop for the time*/
	for(s=0;s<Tend;++s){
		for(t=0;t<Tout;++t){
		
			/*first*/
			u1[0]=u1[1];
			v1[0]=v1[1];
			u1[Nmax+1]=u1[Nmax];
			v1[Nmax+1]=v1[Nmax];
			
			calcu(u1,v1,A,B,DU,dxdt,u2);
			calcv(v1,u1,A,B,D,dxdt,v2);
	
			/*second*/
			u2[0]=u2[1];
			v2[0]=v2[1];
			u2[Nmax+1]=u2[Nmax];
			v2[Nmax+1]=v2[Nmax];
			
			calcu(u2,v2,A,B,DU,dxdt,u1);
			calcv(v2,u2,A,B,D,dxdt,v1);
			
		}
		//		output4gplt(u1,v1,"dists_uv.dat");
		if(s<(Tend-1)) output4gplt(u1,v1,"dists_uv.dat");
		else output4gplt_fit(u1,v1,"dists_uv.dat");
		//output(u1,"outu");
		//output(v1,"outv");
	}
	return(0);
}
