%%Determines the distance of each nucleus to the wounding site, or YSL.
%Projects all nuclei into a 2D plane along a manually defined axis and analyses the radial distribution of pSMAD2/3 to DAPI expressions.
%needs arrow3.m which can be found here https://www.mathworks.com/matlabcentral/fileexchange/14056-arrow3
clearvars; close all;
addpath(pwd);
currentpath=pwd;

savemovie=false;
savexls=false;
selectfiles=false;

% default parameters for testing
Xmin=-7450;
Ymin=-6359;
Zmin=1530;
minimumoccupiedRatio=0.05;   %inclusion criterion for local maximum search
psxy=1; % normalized pixel size

%Input parameters
Inprompt = {'bin values every ? mu', 'draw graph up to a distance of ? mu','1= use z-projection to calculate distances; 0= use euclidian distance',...
    'Xmin','Ymin','Zmin',' angle bin', 'z-projection instead of reading Axis file (0= off 1=on)','Extra Channel ?', 'minimumoccupiedRatio',...
    'Find max Ratio or Max Int Ch2 (1= Ch2/Ch4, 0= Ch2)', 'Search radius for Max Ration/Intensity'};
Intitle = 'Input parameters';
Indefinput = {'5','300','0',num2str(Xmin),num2str(Ymin),num2str(Zmin),'5','0','1',num2str(minimumoccupiedRatio),'1','13'};
answer = inputdlg(Inprompt,Intitle,[1,1,1,1,1,1,1,1,1,1,1,1],Indefinput);


setZtoZero=str2double(answer{3}); % 1= use z-projection to calculate distances; 0= use euclidian distance
dstep=str2double(answer{1});    %bin values every dstep mu
maxEvalD=str2double(answer{2});% draw graph up to a distance of maxEvalD mu
Xmin=str2double(answer{4}); %center of origin of Imaris spot detection
Ymin=str2double(answer{5});
Zmin=str2double(answer{6});
dAngle=str2double(answer{7});
doSimpleZprojection=str2double(answer{8})>0;
extraChannel=str2double(answer{9})>0;
minimumoccupiedRatio=str2double(answer{10});
maxRatioorMaxInt=logical(str2double(answer{11}));
SearchRadius=str2double(answer{12});

if selectfiles
    [YSLFile,YSLpath] = uigetfile('*.xls','YLS Cells');
    cd(YSLpath);
    [NucleiFile,NucleiPath]=uigetfile('*.xls','488/Dapi Nuclei');
    if ~doSimpleZprojection
        [AxisFile,AxisPath]=uigetfile('*.xls','Axis file');
    end
    if extraChannel
        [XtraFile,XtraPath]=uigetfile('*.xls','Extra Channel');
    end
    cd(currentpath);
else
    % default parameters for testing
    YSLpath='D:\TempData\Alexandra\sample 1\';
    NucleiPath=YSLpath;
    SurfacePath=YSLpath;
    AxisPath=YSLpath;
    YSLFile='20181026_GR_256cE_explant1_10_ysl.xls';
    NucleiFile='20181026_GR_256cE_explant1_10.xls';
    SurfaceFile='C8-20181026_GR_256cE_explant1_10.ims - Image 11 Block 8.tif';
    AxisFile='20181026_GR_256cE_explant1_10_axis.xls';
    XtraFile=NucleiFile;
    XtraPath=NucleiPath;
end
myviewpoint=[15,51];
% END Input parameters

[allYSL] = importRefCellsWithT(fullfile(YSLpath,YSLFile));
allnucleiX=importNucleiX(fullfile(NucleiPath,NucleiFile));
Axis=zeros(4,3);    % (1,:); center of YSL (2,:) explant orientation  (3:)= maximum ration point; (4,:)= proj. maxium intensity center
Axis(1,:)=mean(allYSL(:,1:3),1);
if doSimpleZprojection
    Axis(2,:)=[Axis(1,1:2), Zmin];
else
    Axis(2,:)=importAxis(fullfile(AxisPath,AxisFile));
end

if savemovie
    ct = camtarget;
    axis vis3d;
    moviename=[NucleiPath NucleiFile(1:end-4) '.avi'];
    writerObj1 = VideoWriter(moviename);
    writerObj1.FrameRate = 12;
    writerObj1.Quality = 94;
    open(writerObj1);
end

tn=unique(allYSL(:,4));    %in case of time dependent data. Here tn=1;
for ii=1:numel(tn)
    YSL=allYSL(allYSL(:,4)==tn(ii),1:3);
    nucleiX=allnucleiX(allnucleiX(:,4)==tn(ii),:);
    
    if setZtoZero
        YSL(:,3)=YSL(:,3).*0;
        nucleiX(:,3)=nucleiX(:,3).*0;
    end
    
    DI=zeros(size(nucleiX,1),6);  % order 1= geom. distance 2= angle to max point 3= channel 2 4=channel 4 5=distance in surface 6=distance to max Intensity center
    for i=1:size(nucleiX,1)
        DI(i,2:4)=nucleiX(i, [1,5,6]);
        DI(i,1)=pdist2(YSL,nucleiX(i,1:3),'euclidean','Smallest',1);
    end
    
    figure(77);
    hold('on');
    scatter3((YSL(:,1)-Xmin)./psxy,(YSL(:,2)-Ymin)./psxy,(YSL(:,3)-Zmin)./psxy,40,repmat([0,1,0]',[1,size(YSL,1),1])','filled');
    maxd=max(DI(:,1));
    c=[DI(:,1)./maxd,DI(:,1).*0,DI(:,1).*0];
    scatter3((nucleiX(:,1)-Xmin)./psxy,(nucleiX(:,2)-Ymin)./psxy,(nucleiX(:,3)-Zmin)./psxy,8,c,'filled');
    hold('off');
    
    title(['T= ' num2str(ii)]);
    view(myviewpoint);
    
    
    %projection onto explant axis plane
    if doSimpleZprojection
        nAxis=[0,0,1];
    else
        nAxis=Axis(1,:)-Axis(2,:);
        nAxis=nAxis./norm(nAxis);
    end
    projNucleiX=nucleiX;
    for i=1:size(nucleiX,1)
        q=nucleiX(i,1:3);
        p=Axis(2,:);
        q_proj=q - dot(q - p, nAxis) * nAxis;
        projNucleiX(i,1:3)=q_proj;
    end
    % maximum Ratio point;
    IntRatio=nucleiX(:,5)./nucleiX(:,6);
    Axis(3,:)=projNucleiX(IntRatio==max(IntRatio),1:3);
    
    
    if savemovie
        picframe = getframe(gcf);
        writeVideo(writerObj1, picframe);
    end
    figure;
    scatter(DI(:,1),DI(:,3),'.');
    hold('on');
    scatter(DI(:,1),DI(:,4),'.');
    hold('off');
    legend({'Int. Ch2','Int. Ch4'});
    xlabel('distance (m)');
    ylabel('Intensity raw. Value');
    
    %distance graphs
    
    % show how well the direction of the spot with the highest ratio
    % coincides with the overall highest direction
    X=projNucleiX(:,1:3);
    Xp=rotatePlane(X);
    
    % normalize
    minXp=min(Xp,[],1);
    maxXp=max(Xp,[],1)-minXp;
    Xp=(Xp-minXp)./maxXp.*100;
    ratioImage=nan(102,102);
    ncount=zeros(size(ratioImage));
    
    if maxRatioorMaxInt
        allRatio=projNucleiX(:,5)./projNucleiX(:,6);
    else
        allRatio=projNucleiX(:,5);
    end
    
    for i=1:size(Xp,1)
        if ~isnan(ratioImage(round(Xp(i,2))+1,round(Xp(i,1))+1))
            ratioImage(round(Xp(i,2))+1,round(Xp(i,1))+1)=ratioImage(round(Xp(i,2))+1,round(Xp(i,1))+1)+allRatio(i);
        else
            ratioImage(round(Xp(i,2))+1,round(Xp(i,1))+1)=allRatio(i);
        end
        ncount(round(Xp(i,2))+1,round(Xp(i,1))+1)=ncount(round(Xp(i,2))+1,round(Xp(i,1))+1)+1;
    end
    ratioImage=ratioImage./ncount;
    kernel=strel('disk',SearchRadius);
    kernel=kernel.Neighborhood;
    [xmax,ymax,B2]=rangedMaxFind(ratioImage,kernel,minimumoccupiedRatio);
    figure;
    imagesc(ratioImage)
    hold('on');
    scatter(xmax,ymax,500,'red');
    scatter(round(Xp(allRatio==max(allRatio),1))+1,round(Xp(allRatio==max(allRatio),2))+1,200,'green');
    hold('off');
    if maxRatioorMaxInt
        title('distribution of ration: Ch2/Ch4 and maximum (Green), highest Area= Red');
    else
        title('distribution of Intensitiy of Ch2 and maximum (Green), highest Area= Red');
        allRatio=projNucleiX(:,5)./projNucleiX(:,6);  % reset allRatio to ratio after we are done searching for the maximum
    end
    
    % Maximum point on plane
    Xpmax=[xmax ymax]./100.*maxXp+minXp;
    X=projNucleiX(:,1:3);
    Xp=rotatePlane(X);
    Xp2D=Xp(:,1:2);
    [~,minIdx]=pdist2(Xp2D,Xpmax,'euclidean','Smallest',1);     % Closest spot to the maximum is used for back projection
    Axis(4,:)=projNucleiX(minIdx,1:3);
    
    figure;
    hold('on');
    scatter3((YSL(:,1)-Xmin)./psxy,(YSL(:,2)-Ymin)./psxy,(YSL(:,3)-Zmin)./psxy,40,repmat([0,1,0]',[1,size(YSL,1),1])','filled');
    
    scatter3((nucleiX(:,1)-Xmin)./psxy,(nucleiX(:,2)-Ymin)./psxy,(nucleiX(:,3)-Zmin)./psxy,8,'red','filled');
    arrow3((Axis(1,:)-[Xmin Ymin Zmin])./psxy,(Axis(2,:)-[Xmin Ymin Zmin])./psxy,'k-3');
    arrow3((Axis(2,:)-[Xmin Ymin Zmin])./psxy,(Axis(3,:)-[Xmin Ymin Zmin])./psxy,'g-3');
    arrow3((Axis(2,:)-[Xmin Ymin Zmin])./psxy,(Axis(4,:)-[Xmin Ymin Zmin])./psxy,'r-3');
    scatter3((projNucleiX(:,1)-Xmin)./psxy,(projNucleiX(:,2)-Ymin)./psxy,(projNucleiX(:,3)-Zmin)./psxy,'m.');
    hold('off');
    % make arrow at bottom visible
    myzlim=zlim;
    zlim([myzlim(1)-10,myzlim(2)]);
    
    for i=1:size(nucleiX,1)
        
        v1=Axis(4,:)-Axis(2,:);
        v2=projNucleiX(i,1:3)-Axis(2,:);
        
        DI(i,2)= atan2d(norm(cross(v1, v2)), dot(v1, v2));
        DI(i,2)=DI(i,2)*sign(det([nAxis;v1;v2]));  % angle in projected plane between vectors with sign
        DI(i,6)=norm(projNucleiX(i,1:3)-Axis(4,:)); %distance from intensity center;
    end
    figure;
    sizec=wcodemat(allRatio,40);
    scatter3(projNucleiX(:,1),projNucleiX(:,2),projNucleiX(:,3),sizec,[(DI(:,2)+180)/360,DI(:,2).*0,DI(:,2).*0],'filled');
    hold('on');
    daspect([1 1 1]);
    arrow3(Axis(2,:),Axis(4,:),'r-3');
    arrow3(Axis(1,:),Axis(2,:),'k-3');
    hold('off');
    title('angle Convention: Color=Angle Size=Intensity Ratio');
    
    figure;
    sizec=wcodemat(DI(:,6),40);
    scatter3(projNucleiX(:,1),projNucleiX(:,2),projNucleiX(:,3),sizec,[(DI(:,2)+180)/360,DI(:,2).*0,DI(:,2).*0],'filled');
    hold('on');
    daspect([1 1 1]);
    arrow3(Axis(2,:),Axis(4,:),'r-3');
    arrow3(Axis(1,:),Axis(2,:),'k-3');
    hold('off');
    title('Distance from maximum Ratio Center: Size=Distance');
    
    n=0;
    for i=0:dstep:maxEvalD
        n=n+1;
        x(n)=i+dstep/2;
        w=find(DI(:,1)>=i & DI(:,1)<i+dstep); %geometric distance
        w2=find(DI(:,5)>=i & DI(:,5)<i+dstep); % in-surface distance
        nn(n)=numel(w);
        ICh2(n)=median(DI(w,3));
        ICh4(n)=median(DI(w,4));
        stdCh2(n)=std(DI(w,3));%/sqrt(nn(n));
        stdCh4(n)=std(DI(w,4));
        ratio(n)= ICh2(n)./ ICh4(n);
        nn_2(n)=numel(w2);
        ICh2_2(n)=median(DI(w2,3));
        ICh4_2(n)=median(DI(w2,4));
        stdCh2_2(n)=std(DI(w2,3));%/sqrt(nn(n));
        stdCh4_2(n)=std(DI(w2,4));
        ratio_2(n)= ICh2_2(n)./ ICh4_2(n);
    end
    
    % angular distribution
    n=0;
    for i=-180+dAngle:dAngle:180-dAngle
        n=n+1;
        w=find(DI(:,2)>=i & DI(:,2)<i+dAngle); %geometric distance
        RatioAngle(n)=median(DI(w,3)./DI(w,4));
        stdRatioAngle(n)=std(DI(w,3)./DI(w,4));
    end
    figure
    errorbar(-180+dAngle:dAngle:180-dAngle, RatioAngle,stdRatioAngle,'linewidth',2);
    title('angular Distribution');
    xlabel('Degree from max Ratio');
    ylabel('Ratio');
    
    figure
    errorbar(x,ICh2,stdCh2,'linewidth',2);
    hold('on');
    errorbar(x,ICh4,stdCh4,'linewidth',2);
    legend({'Channel 2 (geom. Distance)','Channel4 (geom. Distance)'});
    errorbar(x,ICh2_2,stdCh2_2,'linewidth',2);
    errorbar(x,ICh4_2,stdCh4_2,'linewidth',2);
    legend({'Channel 2 (in-surface Distance)','Channel4 (in-surfaceDistance)'});
    hold('off');
    title('Intensity(distance)');
    xlabel('distance (m)');
    ylabel('raw Intensities');
    figure
    hold('on');
    plot(x,ratio,'linewidth',2);
    xlabel('distance (m)');
    ylabel('ration Ch2/Ch4');
    plot(x,ratio_2,'linewidth',2);
    legend({'ratio Ch2/Ch4 (geom. Distance)','ratio Ch2/Ch4 (in-surface Distance)'});
    xlabel('distance (m)');
    ylabel('ratio');
    hold('off');
    if savexls
        xlswrite([NucleiPath NucleiFile(1:end-4) '_output.xlsx'],{'geom. Distance (mu)','angle to max Ratio','Intensity Channel 2','Intensity Channel4', 'Spot ID','distance to max Intensity Center','Intensity Channel1'},['Time' num2str(tn(ii))] ,'A1');
        xlswrite([NucleiPath NucleiFile(1:end-4) '_output.xlsx'],DI(:,[1,2,3,4,5,6]),['Time' num2str(tn(ii))],'A2');
        %%% write spot ID
        SpotID=xlsread(fullfile(NucleiPath,NucleiFile),'Position','H:H');
        xlswrite([NucleiPath NucleiFile(1:end-4) '_output.xlsx'],SpotID,['Time' num2str(tn(ii))],'E2');
        
    end
end
if savemovie
    close(writerObj1);
end

% repeat for extra channel
if extraChannel
    allnucleiX=importNucleiXSecondChannel(fullfile(XtraPath,XtraFile));
    xlswrite([NucleiPath NucleiFile(1:end-4) '_output.xlsx'],allnucleiX(:,5),['Time' num2str(tn(ii))],'G2');
end
