function [xmax,ymax,B2] = rangedMaxFind(A,kernel,minOc)
% finds the global maximum of A, within a search area kernel, ignoring
% nan and requiring a minimum of non nan values given by minimumoccupiedRatio

%nan padd A
B=nan(size(A)+2*size(kernel));
B(size(kernel,1):size(kernel,1)+size(A,1)-1,size(kernel,2):size(kernel,2)+size(A,2)-1)=A;
[y,x]=find(kernel>0);
minOc=round(minOc*numel(y));
Lmax=-inf;
xmax=nan;ymax=nan;
B2=zeros(size(B));
for i=0:size(B,1)-size(kernel,1)
    for j=0:size(B,1)-size(kernel,1)
        x2=x+j;
        y2=y+i;
        idx=sub2ind(size(B),y2,x2);
        ss=nanmean(B(idx));
        B2(i+1,j+1)=ss;
        if ss>Lmax
            if sum(~isnan(B(idx)))>minOc
                Lmax=ss;
                xmax=j;
                ymax=i;
            else
                B2(i+1,j+1)=nan;
            end
        end
    end
end
B=B2;
minOc=numel(y)-1;
Lmax=-inf;
xmax=nan;ymax=nan;
B2=zeros(size(B));
for i=0:size(B,1)-size(kernel,1)
    for j=0:size(B,1)-size(kernel,1)
        x2=x+j;
        y2=y+i;
        idx=sub2ind(size(B),y2,x2);
        ss=nanmean(B(idx));
        B2(i+1,j+1)=ss;
        if ss>Lmax
            if sum(~isnan(B(idx)))>minOc
                Lmax=ss;
                xmax=j;
                ymax=i;
            else
                B2(i+1,j+1)=nan;
            end
        end
    end
end
xmax=xmax;
ymax=ymax;

