function [C2D]=rotatePlane(C3D)
    % rotates a 3D plane to a new 2D coordinate system 
    N=size(C3D,1);
    origin=C3D(1,:);
    localz=cross(C3D(2,:)-origin,C3D(3,:)-origin);
    unitz=localz/norm(localz,2);
    localx=C3D(2,:)-origin;
    unitx=localx/norm(localx,2);
    localy=cross(localz,localx);
    unity=localy/norm(localy,2);
    T=[unitx(:),unity(:),unitz(:),origin(:); 0 0 0 1];
    C=[C3D,ones(N,1)];
    C2D=T\C';
    C2D=C2D(1:2,:)';
end

