function [OutPutStruct, fig] = Figure2_source(TableOfInter, field_2_plot, varargin)

%%
%%% Input : Table from 'ConcatenateExpData'
% field_2_plot = 'InterferenceToHuntedRatio'; ...
%           'NumberOfCatches';
%           'InterferenceToHuntedRatio'; 
%           'NumberOfDetections';% 'fb_FA_rate';
%           'Range_est_err_std' ;

% varargin{1} - fb_flag- if filterbank table =1
% varargin{2}, the currnet figure to plot on

%%%% compare multiple experimetns (data tables) %%%
NumberOfExperiments = 1;  %3; % number of differnt lines to plot  

CellofExpTables = cell(1,NumberOfExperiments); % cell conatining the experiment tables
ExpName = cell(NumberOfExperiments,1); % the names to plot - for the legend()

% CellofExpTables{1} = TNoNoMaskingall; %Table_NOP_OneBat ;% Table_NOP_5Bats; % Table_NumOfBats_SeqTH;


TableOfInter.ReceiverType = cellstr(TableOfInter.ReceiverType);

% ExpName{1} = 'No Masking';

CellofExpTables{1} =  TableOfInter;

ExpName{1} = 'General';
% 

% CellofExpTables{2} = TableNoiseLevelCorr; % Table_NumOfBats_SeqTH;
% ExpName{2} = 'Correltion';
% % 

% continue on current figure or new figure
fb_flag = 0;
if nargin > 2
    fb_flag = varargin{1};
    fig =   varargin{2};
else 
    figure
    fig = gcf;
end %if nargin >0
hold on



xFieldName = 'NumberOfBats';

% Fileds as y axis
yFieldCell = cellstr(field_2_plot);
% yFieldCell{1} = 'InterferenceToHuntedRatio'; ...
%'NumberOfCatches';%'InterferenceToHuntedRatio'; %'MaskingLevelDB_ave'; %
% 'NumberOfDetections'; %'fb_masking_powerdb'; % 'fb_masking_powerdb'; %'fb_det_SIRdb'; % 'fb_FA_rate';

% yFieldCell{2} = 'fb_masking_powerdb'; %'Approach_MaskingRatioToHunted';
% 
% yFieldCell{3} = 'Buzz_MaskingRatioToHunted';
% yFieldName = 'TotalInterferenceRatio';  
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'Search_MaskingRatioToHunted' / 'Approach_MaskingRatioToHunted' / 'MaskingLevelDB_ave' 
%  / 'NumberOfCatches', 'Search_MaskingRatioToHunted' / 'Search_TotalPulses'

%%% GROUP BY PARAMETER %%%%
GroupParamterFieldName1 = 'ReceiverType';  % 'ReceiverType';
GroupParamterFieldName2 = 'ReceiverType';
GroupParamterFieldName3 =  'NumOfPreys';
% 'NoiseLeveldB'; %'ReceiverType'

% split to 2 figures 
SplitFigFlag= 0;
if SplitFigFlag 
    % NumOfPreys == 10 / 20 
    CellofExpTables{1} = CellofExpTables{1}(CellofExpTables{1}.NumOfPreys == 20,:);    
end %if SplitFigFlag 

% Plot Def
ColorVec= {'k', 'b', 'r', 'm', 'g', 'c'}; %[0.5 0.5 0.5], 'r', 'm', 'g', 'c'} ; %{Corr random, JAR, Peak, Corr same freq} 
LineWVec = [2, 2, 2, 2];

% ColorVec= {'k' , 'r', 'k', 'r' , 'g'}; %{'k' , 'r', 'b', 'g' , 'm'}; %%% SPECIAL 
% LineStVec = { '-', '--', ':' }; %{Total Ratio, Masking Ratio} 


OutPutStruct(6) = struct( ...
    'Experiment',[] ,...
    'xFieldName',[], ...  
    'xVaules', [], ...
    'NumberOfBats', [], ...
    'ParamterName1', [],....
    'ParamterName2', [],...
    'Paramter1', [], ...
    'Paramter2',[],...
    'Means',[],...
    'STDErrs',[],...
    'Numel', [],...
    'MDL', []...
        );
%%% Remove 'OneBat' and 'NoMasking'
% RemoveNames = {'NoMasking', 'no_mask_FilterBank', 'Max_Diff_CorrelationDetector', 'TimeSequenceTH', 'noFreq_Diff_CorrelationDetector'};
wanted_rec_types = {'CorrelationDetector', 'JAR_CorrelationDetector', 'FilterBank', 'JAR_FilterBank'};
% IdxRemove = zeros(size(CellofExpTables{1}.ReceiverType));
Idx_wanted = zeros(size(CellofExpTables{1}.ReceiverType));

for nn= 1:numel(wanted_rec_types)
    IdxTemp = strcmp(CellofExpTables{1}.ReceiverType, wanted_rec_types{nn});
    Idx_wanted = IdxTemp | Idx_wanted;
end % for nn
CellofExpTables{1} = CellofExpTables{1}(Idx_wanted,:);

%%% remove One Bat
IdxOneBat = (CellofExpTables{1}.NumberOfBats == 1);
CellofExpTables{1} = CellofExpTables{1}(~IdxOneBat,:);

k=1;
for nTable = 1:NumberOfExperiments
    T1 = CellofExpTables{(nTable)};
    numOfFlights = numel(T1.NumberOfBats);
    % runing for each  field
        % The Values of the parmater1
        UniqParVals1 = unique(T1.(GroupParamterFieldName1));
        NumOfGroups1 = numel(UniqParVals1);
        
        % The Values of the parmater2
        %     UniqParVals2 = unique(T1.(GroupParamterFieldName2));
%         UniqParVals2 = {'OneBat', 'NoMasking', 'CorrelationDetector'}; % descending order
%         NumOfGroups2 = numel(UniqParVals2);
%         
        % 3rd group
        UniqParVals3 = unique(T1.(GroupParamterFieldName3));
        NumOfGroups3 = numel(UniqParVals3);
     
        for nYfield = 1:numel(yFieldCell)
            yFieldName = yFieldCell{nYfield};
            
            
            for nIndx1 = 1:NumOfGroups1
                uValParamter = UniqParVals1(nIndx1);
                if isnumeric(uValParamter)
                    IDxGRP1 =  T1.(GroupParamterFieldName1) == uValParamter;
                else
                    IDxGRP1 = strcmp(T1.(GroupParamterFieldName1), uValParamter);
                end
                
                %%% if there are no other groups
                IDxGRP2 = ones(size(IDxGRP1));
                IDxGRP3 = ones(size(IDxGRP1));
                %         for nIndx2 = 1: NumOfGroups2
                %             %             IDxGRP2 = strcmp(T1.(GroupParamterFieldName2), UniqParVals2{nGrp2});
                %
                %             if isnumeric(UniqParVals2)
                %                 IDxGRP2 = T1.(GroupParamterFieldName2) == UniqParVals2(nIndx2); %  UniqParVals2
                %             else %  isnumeric(UniqParVals2)
                %                 IDxGRP2 = strcmp(T1.(GroupParamterFieldName2), UniqParVals2{nIndx2}); %  UniqParVals2
                %             end %  isnumeric(UniqParVals2)
                
                %             for nIndx3 = 1:NumOfGroups3
                %                 if isnumeric(UniqParVals3)
                %                     IDxGRP3 = T1.(GroupParamterFieldName3) == UniqParVals3(nIndx3);
                %                 else %  isnumeric(UniqParVals2)
                %                     IDxGRP3 = strcmp(T1.(GroupParamterFieldName2), UniqParVals3{nIndx3});
                %                 end %  isnumeric(UniqParVals2)
                
                IDxFilt = IDxGRP1 & IDxGRP2 & IDxGRP3;
                
                Tgrpd = T1(IDxFilt,:);
                
                x = Tgrpd.(xFieldName) ;
                y = Tgrpd.(yFieldName) ; % for percentage:*100
               
% %                 % calculate time errors in micros from range arrors in cm
% %                 % (xyResolution)
% % % %                 if strcmp( yFieldName, 'Range_est_err_std')
% %                     y = 0.5*y*0.01/343*1e6;
% %                 end % if strcmp
                % errors in cm
                if strcmp( yFieldName, 'fb_std_err_microsec') || strcmp( yFieldName, 'fb_std_err2_hunted')
                    y = 2*y*343*1e-6/0.01; % cm
                end % if strc
                
                % percentage 
                if strcmp(yFieldName ,'InterferenceToHuntedRatio') || ...
                        strcmp(yFieldName ,'fb_FA_rate')
                    y = y*100;
                end % if strcmp
                
                % filter out nan values
                IdxOfNumbers = ~(isnan(y) | isnan(x)) ;
                y = y(IdxOfNumbers);
                x = x(IdxOfNumbers);
                
                % contsructing the bins
                switch xFieldName
                    case {'NumberOfBats', 'NumOfPreys', 'PulsePower', 'NoiseLeveldB', 'PulseDuration_Search' }
                        %             xMidBins = unique(T1.NumberOfBats)';
                        
                        xMidBins = unique(x)';
                        Nbins = numel(xMidBins);
                        
                        Means = nonzeros(accumarray(x,y,[],@mean));
                        Numel = nonzeros(accumarray(x,y,[],@numel));
                        StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                       
                        
                    otherwise
                        % number of bins in the plot
                        Nbins = 10; % 10
                        % the edges of each bin
                        
                        xEdges = min(x):(max(x)-min(x))/(Nbins):max(x);
                        %             Numel = accumarray(discretize(x(:),xEdges),y(:),[],@numel); % Number Of elemnets
                        xMidBins = xEdges(1:Nbins) +diff(xEdges)/2;
                        [Means, StdError, Numel ] = binfunc(x,y,xEdges);
                end % switch xFieldName
                
                % Filter out outliers
                ThrowOutLiersFlag= 0;
                if ThrowOutLiersFlag
                    OutLierPerTh = 1/Nbins/3; % the Thrershold is relative to the number of bins
                    OutLierIndx = Numel/sum(Numel) < OutLierPerTh;
                    xMidBins = xMidBins(~OutLierIndx);
                    Means = Means(~OutLierIndx);
                    StdError = StdError(~OutLierIndx);
                end % if ThrowOutLiersFlag
                
                % The Plot
                % colors and styles
                switch UniqParVals1{nIndx1}
                    case 'FilterBank'
                        line_col = 'b'; %[0.5 0.5 0.5]; %'k'; %[0.5 0.5 0.5];
                        line_st = '-';
                    case 'JAR_FilterBank' 
                        line_col = [0.1 0.6 0.9]; %[0.5 0.5 0.5] ; % 'b'; % [0.5 0.5 0.5];
                        line_st = '--';
                    case 'CorrelationDetector'
                        line_col = [0 0 0]; %'k';
                        line_st = '-';
                    case 'JAR_CorrelationDetector'
                        line_col = [0.5 0.5 0.5]; %'b';
                        line_st = '--';
                end % switch UniqParVals1
                % line style
%                 line_st = '-';   
%                 if fb_flag
%                     line_st = '--';
%                 else
%                     line_st = '-';
%                 end

                
                
                errorbar(xMidBins,Means, StdError,'-', 'Color', line_col, ...
                    'LineStyle', line_st, 'LineWidth', LineWVec(1), 'DisplayName', UniqParVals1{nIndx1} );   %   , 'MarkerSize',1); %  LineStVec{nIndx2}
                
%                 errorbar(xMidBins,Means, StdError,'-', 'Color', ColorVec{nIndx1}, ...
%                     'LineStyle', LineStVec{nYfield}, 'LineWidth', LineWVec(1)) ;   %   , 'MarkerSize',1); %  LineStVec{nIndx2}
                
                LegTxt{k} = unique(T1.ReceiverType(IDxFilt)); % [ unique(T1.ReceiverType(IDxFilt)), yFieldName] ;
                
                %                 LegTxt{k} = [GroupParamterFieldName1, ': ', num2str(UniqParVals1(nIndx1)), ...
                %                     ' Preys: ' , num2str(unique(T1.NumOfPreys(IDxFilt))), ...
                %                     ' ' , UniqParVals2{nIndx2} ];  % UniqParVals2{nGrp2} ; %UniqParVals{nIndx}; % [yFieldCell{nyFields}, ' ', UniqParVals{nIndx} ];
                
                hold on
                
                %%% Saving the THe summary Data , Means, Numel, STDERRR
                OutPutStruct(k).Experiment = ExpName;
                OutPutStruct(k).xFieldName = xFieldName;
                OutPutStruct(k).xVaules = unique(xMidBins)';
                OutPutStruct(k).NumberOfBats = unique(Tgrpd.NumberOfBats)';
                OutPutStruct(k).ParamterName1 = GroupParamterFieldName1;
                OutPutStruct(k).ParamterName2 = 'MaskingRatio';
%                 OutPutStruct(k).Paramter1 = UniqParVals1{nIndx1};
                OutPutStruct(k).Paramter2 = yFieldName; % XXXXXX
                OutPutStruct(k).Means = Means';
                OutPutStruct(k).STDErrs = StdError';
                OutPutStruct(k).Numel = Numel';
                k=k+1;
                %             end %for nIndx3
                %         end % for nIndx2  %%%%
            end % for kuParamter= UniqParVals;
        end % for nYfield
end % for nTable

%% stats
x_var = {'NumberOfBats', 'ReceiverType'};
y_var = field_2_plot;
OutPutStruct(1).MDL = fitlm(TableOfInter, ...
    'ResponseVar', y_var , ...
    'PredictorVars',x_var, ...
    'CategoricalVars','ReceiverType');
%%

% Leg = legend(...
%     'Correlation random freqs', ...
%     'JAR', ...
%     'Peak Detector', ...
%     'Correlation same freqs'...
%         );


% legend('off')

% %%% the size of the figure

ax1 = gca;
% set(fig,'Units','centimeters','Position',[ 5 5 7 7.5])

axis auto % axis(ax1,[1 21 0 50]);
ax1.XTick = unique(xMidBins);
if nargin > 2
    Leg = legend('Correlation, no JAR', 'Correaltion, JAR', 'Filter-Bank, no JAR', 'Filter-Bank, JAR');
    Leg.Position = [0.2  0.6  0.3    0.3];
    Leg.Box = 'off';
    Leg.FontSize = 8;
else
    legend off
end % if nargin

ax1.FontSize = 10;

xlabel('Number of Bats per 100m^2')

%%% ylbael
switch field_2_plot
    case 'NumberOfCatches'
        ytext  = 'Captures / 10sec';
        axis(ax1,[1 21 0 5]);
        ax1.YTick = [0:5];
    case 'InterferenceToHuntedRatio'
        ytext = 'Jammming Probabilty (%)';
        ax1.YTick = [0:5:20];
    case 'MaskingLevelDB_ave'
        ytext = 'Masking Lvl (dB)';
        axis(ax1,[1 21 0 25]);
        ax1.YTick= [0:5:25];
    case 'fb_FA_rate'
        ytext = 'False-Alarm Rate (%)';
        axis(ax1, [1 21 0 10])
        ax1.YTick = [0:2:10];
    case 'Range_est_err_std'
%          ytext = 'Time Errors (micros)';
         ytext = 'Range Errors (cm)';
    case 'SIROfDetectedPreys_ave'
         ytext = 'SNR (dB)';
    case 'SIR2_hunted_ave'
         ytext = 'SNR (dB)'; 
    case 'fb_SIR2_hunted_ave'
         ytext = 'SNR (dB)'; 
    case 'fb_std_err_microsec'
%          ytext = 'time errors (micros)';
         ytext = 'Range Errors (cm)';
         axis(ax1,[1 21 0 45])
    case 'Range2_hunted_err_std'
%          ytext = 'time errors (micros)';
         ytext = 'Range Errors (cm)';
%          axis(ax1,[1 21 0 45])     
    otherwise
        ytext= [];
end % switch

ylabel(ytext)
%% 
%legend({ ExpName{1}}) ;...
%     ExpName{2};...
%     ExpName{3} })

 %%% SAVINg THE FIGURE
SaveFIGflag= 0;

if SaveFIGflag
    if nargin > 2
        set(fig,'Units','centimeters','Position',[ 4 5 10 6])
%         fig.OuterPosition = fig.InnerPosition + [ -0.1 -0.1 0.1 0.1];

    else %  if nargin > 2
        set(fig,'Units','centimeters','Position',[ 4 5 8 5])   
        fig.PaperPositionMode = 'manual';
        fig.PaperUnits = 'centimeters';
        fig.PaperPosition = fig.Position;
    end %  if nargin > 2
    leg=legend('Correlation', ' Correlation JAR', 'Filter-Bank', 'Filter-Bank JAR') ;
    leg.Box =  'off';
%     leg.Location = 'southeast'; % 'northwest'; 
    leg.Position =  [0.11  0.67   0.4290    0.32]; % [0.495  0.21   0.4290    0.32]; % [0.145   0.62    0.4290    0.32];
    ax1.FontSize = 10;
%     fig.InnerPosition = [4.8 9.8 7 8];
%     ax1.FontSize = 9;
    ax1.XLim = [1 20];
    FigPathName = 'C:\Users\YossiYNB7\Documents\Omer\BatSimulation\Results\final\FilterBank\FB_Rectifier\Final for paper\figures\';
    FigName = 'fb_rect_20p_false_alarms'; %  %'fb_rect_20p_jam_prob';
    print([FigPathName,FigName ],'-dmeta','-r400')
     savefig(fig, [FigPathName,FigName ])
end % if SaveFIGflag
%