function [OutPutStruct, fig1] = Figure3_panel1_source(TableOFIntersest)

%%
%%% Input : Table from 'ConcatenateExpData'

% load()
%for one experiment
% NumberOfExperiments = 1;
% T = Table_NumOfBats_SeqTH; 

%%
%%%%%%%%%  Figure 6  %%%%%%%%%%%
% plot error bar of Number Of CATCES as function of NUMBEROF BATS or
% Masking Level

%%%% compare multiple experimetns (data tables) %%%
NumberOfExperiments = 1;  %3; % number of differnt lines to plot  

%% Remove un wanted rows
TableOFIntersest.ReceiverType = cellstr(TableOFIntersest.ReceiverType);
rm_rec =  {'Max_Diff_CorrelationDetector'}; %{'Max_Diff_CorrelationDetector', 'TimeSequenceTH', 'no_mask_FilterBank'};
% wanted_rec_types = {'CorrelationDetector', 'JAR_CorrelationDetector', 'FilterBank', 'JAR_FilterBank'};
idx_rm = zeros(size(TableOFIntersest.ReceiverType));
% Idx_wanted = zeros(size(CellofExpTables{1}.ReceiverType));

for nn= 1:numel(rm_rec)
    IdxTemp = strcmp(TableOFIntersest.ReceiverType, rm_rec{nn});
    idx_rm = IdxTemp | idx_rm;
end % for nn
TableOFIntersest = TableOFIntersest(~idx_rm,:);
%%


CellofExpTables = cell(1,NumberOfExperiments); % cell conatining the experiment tables
ExpName = cell(NumberOfExperiments,1); % the names to plot - for the legend()

CellofExpTables{1} = TableOFIntersest; % TableNOB10Preys2111; % TableNOB3Preys2111; %TableNOB20Preys2111; %TableNOB10Preys2111 ; 
   %TT3 %TT10; %TT20; %TT10; %TableNOB3PreysFullDATA; %TableNOB20Preys0911; % TableNOB10Preys070911; 
ExpName{1} = ['Performance: ', num2str(unique(CellofExpTables{1}.NumOfPreys)), ' Prey Items'];




%%% choose the paramters to plot %%%%
% 2 plots - one with 'NumberOfBats' , second with
% 'InterferenceToHuntedRatio'
NumOfFields =1;

yFieldCell = cell(1, NumOfFields);
LegFieldName = cell(1, NumOfFields);

xFieldName = 'NumberOfBats'; 
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'NumberOfBats' / 'MaskingLevelDB_Q90' / 'MaskingLevelDB_ave' /
%  'NumOfPreys' / 'NumberOfDetections', /'PulsePower'


yFieldCell{1} = 'NumberOfCatches';
% LegFieldName{1} = 'Total Ratio';
yFieldName = yFieldCell{1};

% yFieldCell{2} = 'InterferenceToHuntedRatio';
% LegFieldName{2} = 'Ratio';
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'Search_MaskingRatioToHunted' / 'Approach_MaskingRatioToHunted' / 'MaskingLevelDB_ave' 
%  / 'NumberOfCatches'

%%% GROUP BY PARAMETER %%%%
GroupParamterFieldName = 'ReceiverType';
% 'NoiseLeveldB'

ColorVec = {'g' , 'b', 'k', 'm' , 'r', 'y'}; %{'k' , 'r', 'm', 'g' , 'r'};   
% For 10 Preys and 20 Preys:{'k' ,'b', 'g', 'r', 'm' , 'c', }; 
% for 3 Preys: {'k' ,'b', 'g', 'r', 'm' , 'c', }; 
% ColorVec= {'k' , 'r', 'm', 'g' , 'r'}; 
LineStVec = { '-', '--' }; %'--', '--', '--', '--'};

fig1 = figure();
ax1 = gca;
hold on
% title({yFieldName , ' vs ' , xFieldName})
% xlabel(xFieldName)
% ylabel(yFieldName)


k=0;
NumOfGroups = 5; % to fix with dorrect code
clear OutPutStruct;
OutPutStruct(NumberOfExperiments*NumOfFields) = struct( ...
    'Experiment',[] ,...
    'NumberOfBats', [], ...
    'ParamterName1', [],....
    'ParamterName2', [],...
    'Paramter1', [], ...
    'Paramter2',[],...
    'Means',[],...
    'STDErrs',[],...
    'Numel', []...
        );



for nTable = 1:NumberOfExperiments
    T1 = CellofExpTables{(nTable)};
    numOfFlights= numel(T1.NumberOfBats);
    
    % convert to cell
%     T1.ReceiverType = cellstr(T1.ReceiverType);
    
    UniqParVals = unique(T1.(GroupParamterFieldName));
    OrderUniqParVals = UniqParVals ;
%     OrderUniqParVals  = {'NoMasking', ...%         'Max_Diff_CorrelationDetector', ...
%         'JAR_Corr', ...
%         'CorrelationDetector', ...
%         'noFreq_Diff_CorrelationDetector', ... % 'NoFreq_Diff_CorrelationDetector' (10reys)
%         'TimeSequenceTH' ...
%          };
%     OrderUniqParVals = unique(T1.ReceiverType);

    NumOfGroups =  numel(OrderUniqParVals) ; %  numel(UniqParVals);
    for nIndx = 1:NumOfGroups
        uValParamter = OrderUniqParVals(nIndx); %UniqParVals(nIndx);
        if isnumeric(uValParamter)
            Tgrpd = T1(T1.(GroupParamterFieldName) == uValParamter,:);
        else % isnumeric(uValParamter)
            IDxForCell = strcmp(T1.(GroupParamterFieldName),uValParamter);
            Tgrpd = T1(IDxForCell,:);
        end % isnumeric(uValParamter)
        
        for nyFields = 1:NumOfFields
            k=k+1;
            x = Tgrpd.(xFieldName) ;
            y = Tgrpd.(yFieldCell{nyFields}) ; % for percentage:*100
            
            % filter out nan values
            IdxOfNumbers = ~(isnan(y) | isnan(x)) ;
            y = y(IdxOfNumbers);
            x = x(IdxOfNumbers);
            
            % contsructing the bins
            switch xFieldName
                case {'NumberOfBats', 'NumOfPreys'}
                    %             xMidBins = unique(T1.NumberOfBats)';
                    xMidBins = unique(x)';
                    Nbins = numel(xMidBins);
                    
                    Means = nonzeros(accumarray(x,y,[],@mean));
                    Numel = nonzeros(accumarray(x,y,[],@numel));
                    
                    % the if condition - for yfields == 'ratios'
                    %                 if sum(xMidBins == 1) > 0 % adding 1st zero for one bat where ther is no masking
                    %                     Means = [0; Means];
                    %                     StdError = [0 ;nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                    %                 else
                    %                     StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                    %                 end % if sum(xMidBins == 1) > 0
                    StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                    
                otherwise
                    % number of bins in the plot
                    Nbins = 10; % 10
                    % the edges of each bin
                    
                    xEdges = min(x):(max(x)-min(x))/(Nbins):max(x);
                    %             Numel = accumarray(discretize(x(:),xEdges),y(:),[],@numel); % Number Of elemnets
                    xMidBins = xEdges(1:Nbins) +diff(xEdges)/2;
                    [Means, StdError, Numel ] = binfunc(x,y,xEdges);
            end % switch xFieldName
            
            
            % Filter out outliers
            ThrowOutLiersFlag= 1;
            if ThrowOutLiersFlag
                OutLierPerTh = 1/Nbins/5; % the Thrershold is relative to the number of bins
                OutLierIndx = Numel/sum(Numel) < OutLierPerTh;
                xMidBins = xMidBins(~OutLierIndx);
                Means = Means(~OutLierIndx);
                StdError = StdError(~OutLierIndx);
            end % if ThrowOutLiersFlag
            
            % The Plot
            %     errorbar(xMidBins,Means, StdError,'o-', 'Color', ColorVec{nTable} ) ;   %   , 'MarkerSize',1);
            % color by group, line be experiment table
            marker_style = 'none';
            marker_col = 'none';
            switch OrderUniqParVals{nIndx}
                case 'NoMasking'
                    line_col = 'g'; %[0.5 0.5 0.5];
                    line_st = '-';
                    marker_style = 's';
                    marker_col = 'k';
                case 'no_mask_FilterBank'
                    line_col = 'g'; %[0.5 0.5 0.5];
                    line_st = '-';
                    marker_style = 's';
                    marker_col = 'b';
                case 'same_freq_FilterBank'
                    line_col = [0.9 0.3 0.9]; % 'b'; %[0.5 0.5 0.5];
                    line_st = '-.';
                    
                case 'FilterBank'
                    line_col = 'b'; % [0.5 0.5 0.5];
                    line_st = '-';
                case 'JAR_FilterBank'
                    line_col = [0.1 0.6 0.9]; %'b';
                    line_st = '--';
                case 'CorrelationDetector'
                    line_col = 'k';
                    line_st = '-';
                case 'JAR_Corr'
                    line_col = [0.5 0.5 0.5]; %'k';
                    line_st = '--';
                case 'noFreq_Diff_CorrelationDetector'
                    line_col = [0.85 0.85 0.85]; %'k';
                    line_st = '-.';
                case 'TimeSequenceTH'
                    line_col = 'r';
                    line_st = '-';
                    
            end % switch
            
            %%% correlation figure
            if strcmp(OrderUniqParVals{nIndx},'JAR_Corr') || ...
                    strcmp(OrderUniqParVals{nIndx},'noFreq_Diff_CorrelationDetector') || ...
                    strcmp(OrderUniqParVals{nIndx},'CorrelationDetector') || ...
                    strcmp(OrderUniqParVals{nIndx},'NoMasking')
                %              %%% filter Bank figure
                %             if strcmp(OrderUniqParVals{nIndx},'JAR_FilterBank') || ...
                %                     strcmp(OrderUniqParVals{nIndx},'same_freq_FilterBank') || ...
                %                     strcmp(OrderUniqParVals{nIndx},'FilterBank') || ...
                %                     strcmp(OrderUniqParVals{nIndx},'no_mask_FilterBank')
                %
                
                
                errorbar(xMidBins,Means, StdError,'-', 'Color', line_col, ...
                    'LineStyle', line_st, 'LineWidth',1.5 ) %, ...
                % 'Marker', marker_style, 'MarkerFaceColor', marker_col, 'MarkerSize',4) ;   %   , 'MarkerSize',1);
                LegTxt{k} = UniqParVals{nIndx}; % [yFieldCell{nyFields}, ' ', UniqParVals{nIndx} ];
                hold on
            end % ~strcmp(OrderUniqParVals{nIndx},'no_mask_FilterBank')
            % Mark OneBat Reference
            % % %             OneBatIdx= [(xMidBins ==1);
            % % %             if sum(OneBatIdx) ==1
            % % %                 plot( xMidBins(OneBatIdx), Means(OneBatIdx),'go', 'LineWidth',2, 'MarkerSize',10)
            % % %             end % if sum
            
            %%% Saving the THe summary Data , Means, Numel, STDERRR
            OutPutStruct(k).Experiment = ExpName;
            OutPutStruct(k).NumberOfBats = unique(x)';
            OutPutStruct(k).ParamterName1 = GroupParamterFieldName;
            OutPutStruct(k).ParamterName2 = 'NumOfPreys';
            OutPutStruct(k).Paramter1 = OrderUniqParVals(nIndx);
            OutPutStruct(k).Paramter2 = unique(CellofExpTables{1}.NumOfPreys);
            OutPutStruct(k).Means = Means';
            OutPutStruct(k).STDErrs = StdError';
            OutPutStruct(k).Numel = Numel';
        end %for nyFields = 1:NumOfFields
        
    end % for kuParamter= UniqParVals;
    
end % for nTable

% ADD Marker to One BAT
IdxOneBat = TableOFIntersest.NumberOfBats == 1 & strcmp(TableOFIntersest.ReceiverType,'NoMasking');
% IdxOneBat = TableOFIntersest.NumberOfBats == 1 & strcmp(TableOFIntersest.ReceiverType,'no_mask_FilterBank');

plot( 1, mean(TableOFIntersest.NumberOfCatches(IdxOneBat)), ...
    'go', 'LineWidth',2, 'MarkerSize',10 );


% Leg = legend( 'Correaltion ', 'Peak', 'Location','northwest'  );
% Leg.FontSize = 4.5
% %%% the size of the figure
legend off

% set(fig,'Units','centimeters','Position',[ 5 5 7 4])
%
% FigPathName = 'C:\Users\DELL\Documents\\\\MATLAB Bat Simulation\Results\Final\Figures\Meta\';
% print([FigPathName, 'Figure2aNew_230918_PNG'],'-dpng','-r0')
ax1.FontSize = 10;
ax1.XTick = unique(T1.NumberOfBats);
ax1.YTick = [0:1:5];
%
% ylabel('Catches')
% xlabel('Masking Ratio [%]')
%  title('Catches vs Masking Ratio')

% xlabel('Number of Bats')
% ylabel('Captures / 10sec')
axis([0 20 0 5.1]);
%legend({ ExpName{1}}) ;...
%     ExpName{2};...
%     ExpName{3} })

%%% SAVINg THE FIGURE
SaveFIGflag= 0;
Leg = legend('Correaltion, no JAR', 'Correaltion, JAR', 'Nomasking', 'Correaltion, same freqs');
% Leg = legend('Filter-Bank, no JAR', ' Filter-Bank, JAR', 'Nomasking', 'Filter-Bank, same freqs');
Leg.Location = 'northwest';
Leg.Position = [0.11   0.7    0.87   0.2036];
Leg.FontSize = 8;
Leg.Box = 'off';
legend off
if SaveFIGflag
    fig1.PaperPositionMode = 'auto';
    set(fig1,'Units','centimeters','Position',[ 6 5 6 8])
    %     set(fig1,'Units','centimeters','Position',[ 6 5 7 9])
    %     set(fig1,'OuterPosition', fig1.InnerPosition + [ -0.2 -0.2 0.2 0.2]);
    fig1.PaperPositionMode = 'manual';
    fig1.PaperUnits = 'centimeters';
    fig1.PaperPosition = fig1.Position;
    ax1.FontSize = 9;
    axis([0 20 0 5.1]);
    
    FigPathName = 'C:\Users\YossiYNB7\Documents\Omer\BatSimulation\Results\final\FilterBank\fig2_FB figures\';
    FigName = 'revFig2_NOB_3p_fb_final';
    print([FigPathName,FigName ],'-dmeta','-r16000')
    savefig(fig1, [FigPathName,FigName ])
end % if SaveFIGflag
%


% %%
% % script to analyze OutPutStruct
% WantedRec = 'NoMasking'; %'NoMasking', 'CorrelationDetector', 'Max_Diff_CorrelationDetector', 'NoFreq_Diff_CorrelationDetector', 'TimeSequenceTH'
% kTrial = strcmp([OutPutStruct.Paramter1],'NoMasking');
% WantedBats = 10;
% WantedMeans = OutPutStruct(kTrial).Means( OutPutStruct(kTrial).NumberOfBats = WantedBats);
% %%