function [OutPutStruct, fig] = Figure3_panel3_source(TableOfInter)

%%
%%% Input : Table from 'ConcatenateExpData'

% load()
%for one experiment
% NumberOfExperiments = 1;
% T = Table_NumOfBats_SeqTH; 

%%
%%%%%%%%%  Figure 6  %%%%%%%%%%%
% plot error bar of Number Of CATCHES as function of NUMBEROF BATS or
% Masking Level

%%%% compare multiple experimetns (data tables) %%%
NumberOfExperiments = 1;  %3; % number of differnt lines to plot  

CellofExpTables = cell(1,NumberOfExperiments); % cell conatining the experiment tables
ExpName = cell(NumberOfExperiments,1); % the names to plot - for the legend()

% CellofExpTables{1} = TNoNoMaskingall; %Table_NOP_OneBat ;% Table_NOP_5Bats; % Table_NumOfBats_SeqTH;
% ExpName{1} = 'No Masking';

CellofExpTables{1} =  TableOfInter;
%TablePulsePowerOneBat0512; % TablePulsePower2511; % Table_PulsePower_2511; %TT_All; %Table_PulsePower_All_2511; %TablePulsePowerOneBat; %TablePulsePowerCorrelation; % TablePulsePower1711All; %TT2; 
%TablePulsePowerNew2; % TablePulsePowerOneBat; % TablePulsePowerFullNew_NoPeak;
% PulsePowerTablePulsePowerAll300918; %TablePulsePowerOnlyNew;%TablePulsePowerNew2; % TablePulsePowerFullNew; %PulsePowerTablePulsePowerAll300918; %Table_PulsePower_All; % Table_NumOfBats_SeqTH;
ExpName{1} = 'PulsePower';
% 

% CellofExpTables{2} = TableNoiseLevelCorr; % Table_NumOfBats_SeqTH;
% ExpName{2} = 'Correltion';
% % 



%%% choose the paramters to plot %%%%
% 2 plots - one with 'NumberOfBats' , second with
% 'InterferenceToHuntedRatio'

xFieldName = 'NumberOfBats';
%'PulseDuration_Search';% 'NoiseLeveldB'; %'PulsePower'; 
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'NumberOfBats' / 'MaskingLevelDB_Q90' / 'MaskingLevelDB_ave' /
%  'NumOfPreys' / 'NumberOfDetections', /'PulsePower'

% Fileds as y axis
yFieldCell{1} = 'Search_MaskingRatioToHunted';

yFieldCell{2} = 'Approach_MaskingRatioToHunted';

yFieldCell{3} = 'Buzz_MaskingRatioToHunted';
% yFieldName = 'TotalInterferenceRatio';  
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'Search_MaskingRatioToHunted' / 'Approach_MaskingRatioToHunted' / 'MaskingLevelDB_ave' 
%  / 'NumberOfCatches', 'Search_MaskingRatioToHunted' / 'Search_TotalPulses'

%%% GROUP BY PARAMETER %%%%
GroupParamterFieldName1 = 'ReceiverType';  % 'ReceiverType';
GroupParamterFieldName2 = 'ReceiverType';
GroupParamterFieldName3 =  'NumOfPreys';
% 'NoiseLeveldB'; %'ReceiverType'

% split to 2 figures 
SplitFigFlag= 0;
if SplitFigFlag 
    % NumOfPreys == 10 / 20 
    CellofExpTables{1} = CellofExpTables{1}(CellofExpTables{1}.NumOfPreys == 20,:);    
end %if SplitFigFlag 

% Plot Def
ColorVec= {'k', 'b', 'r', 'm', 'g', 'c'} ; %{Corr random, JAR, Peak, Corr same freq} 
LineWVec = 2*ones(1,6); %[2, 2, 2, 2];

% ColorVec= {'k' , 'r', 'k', 'r' , 'g'}; %{'k' , 'r', 'b', 'g' , 'm'}; %%% SPECIAL 
LineStVec = { '-', '--', ':' }; %{Total Ratio, Masking Ratio} 

figure
hold on
% title({yFieldName , ' vs ' , xFieldName})
% xlabel(xFieldName)
% ylabel(yFieldName)
% 
OutPutStruct(6) = struct( ...
    'Experiment',[] ,...
    'xFieldName',[], ...  
    'xVaules', [], ...
    'NumberOfBats', [], ...
    'ParamterName1', [],....
    'ParamterName2', [],...
    'Paramter1', [], ...
    'Paramter2',[],...
    'Means',[],...
    'STDErrs',[],...
    'Numel', []...
        );
%%% Remove 'OneBat' and 'NoMasking'
RemoveNames = {'NoMasking', 'Max_Diff_CorrelationDetector', 'TimeSequenceTH', 'noFreq_Diff_CorrelationDetector'};
IdxRemove = zeros(size(CellofExpTables{1}.ReceiverType));
for nn= 1:numel(RemoveNames)
    IdxTemp = strcmp(cellstr(CellofExpTables{1}.ReceiverType), RemoveNames{nn});
    IdxRemove =IdxTemp | IdxRemove;
end % for nn
CellofExpTables{1} = CellofExpTables{1}(~IdxRemove,:);

%%% remove One Bat
IdxOneBat = (CellofExpTables{1}.NumberOfBats == 1);
CellofExpTables{1} = CellofExpTables{1}(~IdxOneBat,:);

k=1;
for nTable = 1:NumberOfExperiments
    T1 = CellofExpTables{(nTable)};
    numOfFlights= numel(T1.NumberOfBats);
    % runing for each  field
        % The Values of the parmater1
        UniqParVals1 = unique(T1.(GroupParamterFieldName1));
        NumOfGroups1 = numel(UniqParVals1);
        
        % The Values of the parmater2
        %     UniqParVals2 = unique(T1.(GroupParamterFieldName2));
        UniqParVals2 = {'OneBat', 'NoMasking', 'CorrelationDetector'}; % descending order
        NumOfGroups2 = numel(UniqParVals2);
        
        % 3rd group
        UniqParVals3 = unique(T1.(GroupParamterFieldName3));
        NumOfGroups3 = numel(UniqParVals3);
     
        for nYfield = 1:numel(yFieldCell)
            yFieldName = yFieldCell{nYfield};
            for nIndx1 = 1:NumOfGroups1
                uValParamter = UniqParVals1(nIndx1);
                if isnumeric(uValParamter)
                    IDxGRP1 =  T1.(GroupParamterFieldName1) == uValParamter;
                else
                    T1.(GroupParamterFieldName1) = cellstr(T1.(GroupParamterFieldName1));
                    uValParamter = cellstr(uValParamter);
                    IDxGRP1 = strcmp(T1.(GroupParamterFieldName1), uValParamter);
                end
                
                %%% if there are no other groups
                IDxGRP2 = ones(size(IDxGRP1));
                IDxGRP3 = ones(size(IDxGRP1));
                %         for nIndx2 = 1: NumOfGroups2
                %             %             IDxGRP2 = strcmp(T1.(GroupParamterFieldName2), UniqParVals2{nGrp2});
                %
                %             if isnumeric(UniqParVals2)
                %                 IDxGRP2 = T1.(GroupParamterFieldName2) == UniqParVals2(nIndx2); %  UniqParVals2
                %             else %  isnumeric(UniqParVals2)
                %                 IDxGRP2 = strcmp(T1.(GroupParamterFieldName2), UniqParVals2{nIndx2}); %  UniqParVals2
                %             end %  isnumeric(UniqParVals2)
                
                %             for nIndx3 = 1:NumOfGroups3
                %                 if isnumeric(UniqParVals3)
                %                     IDxGRP3 = T1.(GroupParamterFieldName3) == UniqParVals3(nIndx3);
                %                 else %  isnumeric(UniqParVals2)
                %                     IDxGRP3 = strcmp(T1.(GroupParamterFieldName2), UniqParVals3{nIndx3});
                %                 end %  isnumeric(UniqParVals2)
                
                IDxFilt = IDxGRP1 & IDxGRP2 & IDxGRP3;
                % only releveant receivers
                OrderUniqParVals = char(UniqParVals1(nIndx1));
                if strcmp(OrderUniqParVals,'JAR_Corr') || ...
                        strcmp(OrderUniqParVals,'noFreq_Diff_CorrelationDetector') || ...
                        strcmp(OrderUniqParVals,'CorrelationDetector') || ...
                        strcmp(OrderUniqParVals,'NoMasking')
                    Tgrpd = T1(IDxFilt,:);
                    
                    x = Tgrpd.(xFieldName) ;
                    y = Tgrpd.(yFieldName)*100 ; % for percentage:*100
                    
                    % filter out nan values
                    IdxOfNumbers = ~(isnan(y) | isnan(x)) ;
                    y = y(IdxOfNumbers);
                    x = x(IdxOfNumbers);
                    
                    % contsructing the bins
                    switch xFieldName
                        case {'NumberOfBats', 'NumOfPreys', 'PulsePower', 'NoiseLeveldB', 'PulseDuration_Search' }
                            %             xMidBins = unique(T1.NumberOfBats)';
                            
                            xMidBins = unique(x)';
                            Nbins = numel(xMidBins);
                            
                            Means = nonzeros(accumarray(x,y,[],@mean));
                            Numel = nonzeros(accumarray(x,y,[],@numel));
                            StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                            % % %                     the if condition - for yfields == 'ratios'
                            %                                     if sum(xMidBins == 1) > 0 % adding 1st zero for one bat where ther is no masking
                            %                                         Means = [0; Means];
                            %                                         StdError = [0 ;nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                            %                                     else
                            %                                         StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                            %                                     end % if sum(xMidBins == 1) > 0
                            
                            %%% Condition for ratio an 'NoMsaking'
                            %                         switch yFieldName
                            %                             case {'InterferenceToHuntedRatio', 'TotalInterferenceRatio', 'Search_MaskingRatioToHunted' }
                            %                                 if strcmp(UniqParVals2{nIndx1}, 'NoMasking')
                            %                                     Means= zeros(size(xMidBins));
                            %                                     Numel = numel(xMidBins);
                            %                                     StdError= zeros(size(xMidBins));
                            %                                 end % if strcmp()
                            %                             otherwise
                            %                                 StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                            %                         end % switch yFieldName
                            %                     StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                            
                        otherwise
                            % number of bins in the plot
                            Nbins = 10; % 10
                            % the edges of each bin
                            
                            xEdges = min(x):(max(x)-min(x))/(Nbins):max(x);
                            %             Numel = accumarray(discretize(x(:),xEdges),y(:),[],@numel); % Number Of elemnets
                            xMidBins = xEdges(1:Nbins) +diff(xEdges)/2;
                            [Means, StdError, Numel ] = binfunc(x,y,xEdges);
                    end % switch xFieldName
                    
                    % Filter out outliers
                    ThrowOutLiersFlag= 0;
                    if ThrowOutLiersFlag
                        OutLierPerTh = 1/Nbins/3; % the Thrershold is relative to the number of bins
                        OutLierIndx = Numel/sum(Numel) < OutLierPerTh;
                        xMidBins = xMidBins(~OutLierIndx);
                        Means = Means(~OutLierIndx);
                        StdError = StdError(~OutLierIndx);
                    end % if ThrowOutLiersFlag
                    
                    % The Plot - Correlation
                    
                    
                    errorbar(xMidBins,Means, StdError,'-', 'Color', ColorVec{nIndx1}, ...
                        'LineStyle', LineStVec{nYfield}, 'LineWidth', LineWVec(1)) ;   %   , 'MarkerSize',1); %  LineStVec{nIndx2}
                    
                    %                 LegTxt{k} = [ unique(T1.ReceiverType(IDxFilt)), yFieldName] ;
                    
                    %                 LegTxt{k} = [GroupParamterFieldName1, ': ', num2str(UniqParVals1(nIndx1)), ...
                    %                     ' Preys: ' , num2str(unique(T1.NumOfPreys(IDxFilt))), ...
                    %                     ' ' , UniqParVals2{nIndx2} ];  % UniqParVals2{nGrp2} ; %UniqParVals{nIndx}; % [yFieldCell{nyFields}, ' ', UniqParVals{nIndx} ];
                    
                    hold on
                    
                    %%% Saving the THe summary Data , Means, Numel, STDERRR
                    OutPutStruct(k).Experiment = ExpName;
                    OutPutStruct(k).xFieldName = xFieldName;
                    OutPutStruct(k).xVaules = unique(xMidBins)';
                    OutPutStruct(k).NumberOfBats = unique(Tgrpd.NumberOfBats)';
                    OutPutStruct(k).ParamterName1 = GroupParamterFieldName1;
                    OutPutStruct(k).ParamterName2 = 'MaskingRatio';
                    %                 OutPutStruct(k).Paramter1 = UniqParVals1{nIndx1};
                    OutPutStruct(k).Paramter2 = yFieldName; % XXXXXX
                    OutPutStruct(k).Means = Means';
                    OutPutStruct(k).STDErrs = StdError';
                    OutPutStruct(k).Numel = Numel';
                    k=k+1;
                    %             end %for nIndx3
                    %         end % for nIndx2  %%%%
                end % if strcmp(OrderUniqParVals{nIndx} ...)
            end % for kuParamter= UniqParVals;
        end % for nYfield
end % for nTable



% legend('off')

% %%% the size of the figure
fig = gcf;
ax1 = gca;

axis(ax1,[1 21 0 50]);
ax1.XTick = unique(xMidBins);
Leg = legend(...
    'Search, Corr', ...
    'Search, JAR', ...
    'Approach, Corr', ...
    'Approach, JAR',...
    'Buzz, Corr', ...
    'Buzz, JAR' ...
        );
Leg.Position = [0.28  0.7   0.3    0.1];
Leg.Box = 'off';
Leg.FontSize = 8;
%  legend off

ax1.FontSize = 10;
% title(['Signal Power, ', num2str(uValParamter) , ' Prey Items'])
% title('Signal Power ')

% 
% ylabel('Catches')
% xlabel('Masking Ratio [%]')
% xlabel('Signal Power (dB-SPL)')
% ylabel('Jamming  probability  (%)')
xlabel('Number of bats per 100m^2')

% ylabel('Pursue Masking Ratio (%)')

%legend({ ExpName{1}}) ;...
%     ExpName{2};...
%     ExpName{3} })

 %%% SAVINg THE FIGURE
SaveFIGflag= 0;

if SaveFIGflag
    set(fig,'Units','centimeters','Position',[ 4 5 6.5 7])
    fig.PaperPositionMode = 'auto';
    FigPathName = 'C:\Users\TEMP.DELL-PC.000\Documents\MATLAB\Final_Figures_March2019\';
    FigName = 'Figure_Supp1_JamProb_SearchAppBuzz_20P_1703';
    print([FigPathName,FigName ],'-dmeta','-r0')
    savefig(fig, [FigPathName,FigName ])
end % if SaveFIGflag
%