function [] = Figure4_source_detect_th(TableOFIntersest)

%%
%%% Input : Table from 'ConcatenateExpData'

% load()
%for one experiment
% NumberOfExperiments = 1;
% T = Table_NumOfBats_SeqTH; 

%%
%%%%%%%%%  Figure 6  %%%%%%%%%%%
% plot error bar of Number Of CATCES as function of NUMBEROF BATS or
% Masking Level

%%%% compare multiple experimetns (data tables) %%%
NumberOfExperiments = 1;  %3; % number of differnt lines to plot  

CellofExpTables = cell(1,NumberOfExperiments); % cell conatining the experiment tables
ExpName = cell(NumberOfExperiments,1); % the names to plot - for the legend()

% CellofExpTables{1} = TNoNoMaskingall; %Table_NOP_OneBat ;% Table_NOP_5Bats; % Table_NumOfBats_SeqTH;
% ExpName{1} = 'No Masking';

CellofExpTables{1} = TableOFIntersest; % TablePulsePower1711_All; %TT2; %TablePulsePowerNew2; % TablePulsePowerOneBat; % TablePulsePowerFullNew_NoPeak;
% PulsePowerTablePulsePowerAll300918; %TablePulsePowerOnlyNew;%TablePulsePowerNew2; % TablePulsePowerFullNew; %PulsePowerTablePulsePowerAll300918; %Table_PulsePower_All; % Table_NumOfBats_SeqTH;
ExpName{1} = 'Call_duration';
% 

% CellofExpTables{2} = TableNoiseLevelCorr; % Table_NumOfBats_SeqTH;
% ExpName{2} = 'Correltion';
% % 



%%% choose the paramters to plot %%%%
% 2 plots - one with 'NumberOfBats' , second with
% 'InterferenceToHuntedRatio'

xFieldName = 'NoiseLeveldB'; %'PulseDuration_Search'; % 'PulsePower'; 
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'NumberOfBats' / 'MaskingLevelDB_Q90' / 'MaskingLevelDB_ave' /
%  'NumOfPreys' / 'NumberOfDetections', /'PulsePower'
yFieldName = 'NumberOfCatches';  
%  Possile Fields:% 'InterferenceToHuntedRatio' / 'TotalInterferenceRatio'
%  / 'Search_MaskingRatioToHunted' / 'Approach_MaskingRatioToHunted' / 'MaskingLevelDB_ave' 
%  / 'NumberOfCatches', 'Search_MaskingRatioToHunted' / 'Search_TotalPulses'

%%% GROUP BY PARAMETER %%%%
GroupParamterFieldName1 = 'NumberOfBats';
GroupParamterFieldName2 = 'ReceiverType';
GroupParamterFieldName3 =  'NumOfPreys';
% 'NoiseLeveldB'; %'ReceiverType'

% split to 2 figures 
SplitFigFlag= 0;
if SplitFigFlag 
    % NumOfPreys == 10 / 20
    CellofExpTables{1} = CellofExpTables{1}(CellofExpTables{1}.NumOfPreys == 20,:);    
end %if SplitFigFlag 

% Plot Def
ColorVec=  {'k','g','b'}; % { ' k', 'r','b' ,' k', 'r','b' ,' k', 'r','b' };  %{'k' , 'r', 'b', 'g' , 'm'};   
% ColorVec= {'k' , 'r', 'k', 'r' , 'g'}; %{'k' , 'r', 'b', 'g' , 'm'}; %%% SPECIAL 
LineStVec = { '-', '--', ':' }; %'--', '--', '--', '--'};
% MarkerSt = {'m','k'};

figure
hold on
title({yFieldName , ' vs ' , xFieldName})
xlabel(xFieldName)
ylabel(yFieldName)


k=1;
for nTable = 1:NumberOfExperiments
    T1 = CellofExpTables{(nTable)};
    numOfFlights= numel(T1.NumberOfBats);
    
    % The Values of the parmater1
    UniqParVals1 = unique(T1.(GroupParamterFieldName1));
    NumOfGroups1 = numel(UniqParVals1);
    
    % The Values of the parmater2
    UniqParVals2 = unique(T1.(GroupParamterFieldName2));
    NumOfGroups2 = numel(UniqParVals2);
    
    % 3rd group
    UniqParVals3 = unique(T1.(GroupParamterFieldName3));
    NumOfGroups3 = numel(UniqParVals3);
    
    for nIndx1 = 1:NumOfGroups1
        uValParamter = UniqParVals1(nIndx1);
        if isnumeric(uValParamter)
            IDxGRP1 =  T1.(GroupParamterFieldName1) == uValParamter;
        else
            IDxGRP1 = strcmp(T1.(GroupParamterFieldName1), uValParamter);
        end
        
        for nIndx2 = 1:NumOfGroups2
            %             IDxGRP2 = strcmp(T1.(GroupParamterFieldName2), UniqParVals2{nGrp2});
            
            if isnumeric(UniqParVals2)
                IDxGRP2 = T1.(GroupParamterFieldName2) == UniqParVals2(nIndx2);
            else %  isnumeric(UniqParVals2)
                IDxGRP2 = strcmp(cellstr(T1.(GroupParamterFieldName2)), cellstr(UniqParVals2(nIndx2)));
            end %  isnumeric(UniqParVals2)
            
            for nIndx3 = 1:NumOfGroups3
                if isnumeric(UniqParVals3)
                    IDxGRP3 = T1.(GroupParamterFieldName3) == UniqParVals3(nIndx3);
                else %  isnumeric(UniqParVals2)
                    IDxGRP3 = strcmp(T1.(GroupParamterFieldName2), UniqParVals3{nIndx3});
                end %  isnumeric(UniqParVals2)
                
                IDxFilt = IDxGRP1 & IDxGRP2 & IDxGRP3; % & IDxGRP3;
                
                Tgrpd = T1(IDxFilt,:);
                
                x = Tgrpd.(xFieldName) ;
                y = Tgrpd.(yFieldName) ; % for percentage:*100
                
                % filter out nan values
                IdxOfNumbers = ~(isnan(y) | isnan(x)) ;
                y = y(IdxOfNumbers);
                x = x(IdxOfNumbers);
                
                % contsructing the bins
                switch xFieldName
                    case {'NumberOfBats', 'NumOfPreys', 'PulsePower' ,'PulseDuration_Search', 'NoiseLeveldB'}
                        %             xMidBins = unique(T1.NumberOfBats)';
                        xMidBins = unique(x)';
                        Nbins = numel(xMidBins);
                        
                        x1= x+1*(sum(x==0)>0);
                        Means = nonzeros(accumarray(x1,y,[],@mean));
                        Numel = nonzeros(accumarray(x1,y,[],@numel));
                        
                        % % %                     the if condition - for yfields == 'ratios'
                        %                                     if sum(xMidBins == 1) > 0 % adding 1st zero for one bat where ther is no masking
                        %                                         Means = [0; Means];
                        %                                         StdError = [0 ;nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                        %                                     else
                        %                                         StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                        %                                     end % if sum(xMidBins == 1) > 0
                        %%% Condition for ratio an 'NoMsaking'
                        switch yFieldName
                            case {'InterferenceToHuntedRatio', 'TotalInterferenceRatio', 'Search_MaskingRatioToHunted' }
                                if strcmp(UniqParVals2{nIndx2}, 'NoMasking')
                                    Means= zeros(size(xMidBins));
                                    Numel = numel(xMidBins);
                                    StdError= zeros(size(xMidBins));
                                end % if strcmp()
                            otherwise
                                StdError = [nonzeros(accumarray(x1,y,[],@std))] ./ sqrt(Numel);
                        end % switch yFieldName
                        %                     StdError = [nonzeros(accumarray(x,y,[],@std))] ./ sqrt(Numel);
                        
                    otherwise
                        % number of bins in the plot
                        Nbins = 10; % 10
                        % the edges of each bin
                        
                        xEdges = min(x):(max(x)-min(x))/(Nbins):max(x);
                        %             Numel = accumarray(discretize(x(:),xEdges),y(:),[],@numel); % Number Of elemnets
                        xMidBins = xEdges(1:Nbins) +diff(xEdges)/2;
                        [Means, StdError, Numel ] = binfunc(x,y,xEdges);
                end % switch xFieldName
                
                % Filter out outliers
                ThrowOutLiersFlag= 0;
                if ThrowOutLiersFlag
                    OutLierPerTh = 1/Nbins/3; % the Thrershold is relative to the number of bins
                    OutLierIndx = Numel/sum(Numel) < OutLierPerTh;
                    xMidBins = xMidBins(~OutLierIndx);
                    Means = Means(~OutLierIndx);
                    StdError = StdError(~OutLierIndx);
                end % if ThrowOutLiersFlag
                
                % The Plot
                %     errorbar(xMidBins,Means, StdError,'o-', 'Color', ColorVec{nTable} ) ;   %   , 'MarkerSize',1);
                % color by group, line be experiment table
                if ~isempty(xMidBins)
                    errorbar(xMidBins,Means, StdError,'o-', 'Color', ColorVec{nIndx2}, ...
                        'LineStyle', LineStVec{nIndx3}, 'LineWidth', 1.2, ...
                        'DisplayName', ['Bats:',num2str(unique(T1.NumberOfBats(IDxFilt))), ...
                        ' Preys:', num2str(unique(T1.NumOfPreys(IDxFilt))), ' ', char(UniqParVals2(nIndx2))]  ) ;   %   , 'MarkerSize',1);
                    
                    %                  LegTxt{k} = [ num2str(unique(T1.NumberOfBats(IDxFilt))), ' Bats,' ...
                    %                     ' ', UniqParVals2(nIndx2) ];
                    
                    LegTxt{k} = [GroupParamterFieldName1, ': ', num2str(UniqParVals1(nIndx1)), ...
                        ' Preys: ' , num2str(unique(T1.NumOfPreys(IDxFilt))), ...
                        ' ' , UniqParVals2(nIndx2) ];  % UniqParVals2{nGrp2} ; %UniqParVals{nIndx}; % [yFieldCell{nyFields}, ' ', UniqParVals{nIndx} ];
                    
                    hold on
                    
                    k=k+1;
                end %if ~isempty(xMidBins)
            end %for nIndx3
        end %for nGrp2 = 1:NumOfGroups2 %%%%
    end % for kuParamter= UniqParVals;
    %     k=k+1;
end % for nTable

Leg = legend('Location','northwestoutside');
Leg.FontSize = 7;
% legend('off')
% Leg = legend( 'Correaltion', 'No Mask', 'Peak', 'Location' ,'northwest' );
% %%% the size of the figure
fig = gcf;
ax1 = gca;
% set(fig,'Units','centimeters','Position',[ 5 5 7 7.5])
% set(fig,'Units','centimeters','Position',[ 5 5 7 11])
axis([0 30.5 0.5 5.5]); %axis([1.5 8.5 0.5 5.5]); % axis([85 155 1.5 5.5]);

ax1.FontSize = 9;
title(['Signal Power, ', num2str(uValParamter) , ' Prey Items'])
% 
% ylabel('Catches')
% xlabel('Masking Ratio [%]')
xlabel('Signal Power (dB-SPL)')
ylabel('Catches/ 10sec')

% ylabel('Pursue Masking Ratio (%)')

%legend({ ExpName{1}}) ;...
%     ExpName{2};...
%     ExpName{3} })

 %%% SAVINg THE FIGURE
SaveFIGflag= 0;

if SaveFIGflag
    fig.PaperPositionMode = 'auto';
    FigPathName = 'C:\Users\DELL\Documents\\\\MATLAB Bat Simulation\Results\Final\Figures\Meta\Article\Final\';
    FigName = 'Figure6bPulsePower_10Preys_1811';
    print([FigPathName,FigName ],'-dmeta','-r0')
   
end % if SaveFIGflag
%