% *****************************************************************
% 
%
%
% 
% *****************************************************************


%%
clear;clc;

addpath .\UnderConfig

triLen = 10;

load .\NN_dssall03_27_f6c6
ybb = yb(2*fs+[1:triLen*fs],:,[1:4],[1:16]);

bloname = {'A-s','A-d','R-s','R-d'};
%%

f=1:fs*triLen;f=f-1;f=f/triLen;

topoo  = fft(ybb);
topoCh = [2*abs(topoo)/size(ybb,1)].^2;
topo   = (topoCh(:,2:3:end,:,:)+topoCh(:,3:3:end,:,:))/2;
topoP  = squeeze(mean(topo,2));

%%
ShadeColor = [.7 .7 .7];

topoPm = double(squeeze(mean(topoP,2)));
[dum,seq] = sort(topoPm(triLen+1,:));
% seq=randperm(16);
topoPm = topoPm(:,seq);
topoPm = 10*log10(topoPm);
topoPm = topoPm+ones(size(topoPm,1),1)*[1:16].*1e-26;

figure('color',[1 1 1]);subplot(1,2,1);
lab1 = plot(f(2:end-1),topoPm(2:end-1,:)-topoPm(1:end-2,:)/2-topoPm(3:end,:)/2+ones(length(f)-2,1)*[1:16]*4,'k','linewidth',1);
xlim([0.4 2.6]);grid on
xlabel('frequency/hz');ylabel('dB');
title('Response Spectrum-Sub','FontSize',18)
set(gca,'FontSize',12);
xlabel('Frequency (Hz)','FontSize',16);
ylabel('Magnitude (dB)','FontSize',16);
%%
DIM = triLen+1;
blos = [1 2;3 4];

xx = 0:pi/100:2*pi;
clear bloAngs
for cond = 1:2
    
    ChAngle  = squeeze(angle(topoo(DIM,:,blos(cond,:),:)));
    ChAngle  = permute(ChAngle,[3 2 1]);
    bloAngle = squeeze(ChAngle(:,1,:)-ChAngle(:,2,:));
    bloAngs(:,cond) = mphase2(bloAngle,2);
end
bloAngs = mphase2(bloAngs,2);

subplot(1,2,2);hold on
plot(cos(xx),sin(xx),'k','linewidth',2);axis off
for ind = 1:size(bloAngs,1)
    plot([0 cos(bloAngs(ind))],[0 sin(bloAngs(ind))],'k','linewidth',1)
    plot(cos(bloAngs(ind)),sin(bloAngs(ind)),'k.','markersize',25)
end
title('Phase Difference-Sub','FontSize',18);
