% *****************************************************************
% 
%
%
% 
% *****************************************************************


%%
clear;clc;

addpath .\UnderConfig

triLen = 10;

load .\NN_dssall03_27_f6c6
ybb = yb(2*fs+[1:triLen*fs],:,[1:4],[1:16]);

bloname = {'A-s','A-d','R-s','R-d'};
%%

f=1:fs*triLen;f=f-1;f=f/triLen;

topoo  = fft(ybb);
topoCh = [2*abs(topoo)/size(ybb,1)].^2;
topo   = (topoCh(:,2:3:end,:,:)+topoCh(:,3:3:end,:,:))/2;
topoP  = squeeze(mean(topo,2));

%%
ShadeColor = [.7 .7 .7];

topoP = double(topoP);
figure('color',[1 1 1]);
for blo = 1:4
    
    subplot (4,1,blo);hold on
    
    plot_shade(f,squeeze(mean(topoP(:,blo,:),3))',std(squeeze(topoP(:,blo,:)),0,2)'/sqrt(size(topoP,3)),ShadeColor);
    lab1 = plot(f,squeeze(mean(topoP(:,blo,:),3))','k','linewidth',2);
    xlim([0.4 2.6]);ylim([1e-27 1e-24]);
    set(gca,'yscale','log');set(gca,'ytick',[1e-27 1e-26 1e-25 1e-24]);
    title(bloname{blo});
    grid on
    xlabel('frequency/hz');
    ylabel('power');
    grid on;
    
end

%%

Pvalue = 0.05;

load .\Topo\E1_channel   %ݶȼͣ102ͨԼ

pp = pps;
pp(pp>=Pvalue) = 3;
pp(pp< Pvalue) = 2;
pp(pp==3) = 1;
pp = pp-1;

DIMs = [triLen+1 2*triLen+1];
clear Specto
for dm = 1:2
    DIM = DIMs(dm);
    Specto(:,:,:,dm) = topo(DIM,:,:,:);
%     Specto(:,:,:,dm) = topo(DIM,:,:,:)-mean(topo(DIM+[-1 1],:,:,:));
end
Spec = squeeze(mean(Specto,3));

hz = [1 2 4];

clear caxisGro
caxisGro(:,1) = [0 1e-25]';
caxisGro(:,2) = [0 1e-24]';
colors = [1 1 1;1 0.2 0];

figure('color',[1 1 1]);
for blo = 1:2
    for dm = 1:2
        subplot(2,2,(blo-1)*2+dm)
        PKUtopoGradOutline(Spec(:,blo,dm).*pp(:,blo,dm),5);
        caxis(caxisGro(:,dm)');
        
        PKUtopoChN(find(pps(:,blo,dm)<Pvalue),20);
        colormap(colorwrite(colors(1,:),colors(2,:)));colorbar
        title([ num2str(hz(dm)) 'hz-' bloname{blo}]);
    end
end
figure('color',[1 1 1]);
for blo = 3:4
    for dm = 1:2
        subplot(2,2,(blo-3)*2+dm)
        PKUtopoGradOutline(Spec(:,blo,dm).*pp(:,blo,dm),5);
        caxis(caxisGro(:,dm)');
        
        PKUtopoChN(find(pps(:,blo,dm)<Pvalue),20);
        colormap(colorwrite(colors(1,:),colors(2,:)));colorbar
        title([ num2str(hz(dm)) 'hz-' bloname{blo}]);
    end
end

%%
DIM = triLen+1;
blos = [1 2;3 4];

color1 = [254 200 50]/255;
color2 = [248 187 68]/255;
color3 = [135 191 119]/255;
color4 = [56 185 158]/255;

colorrange = [colorwrap(color1,color2,20);... 
              colorwrap(color2,color3,20);... 
              colorwrap(color3,color4,20);...
              colorwrap(color4,color3,20);...
              colorwrap(color3,color2,20);...
              colorwrap(color2,color1,20)];

condname = {'A','R'};
sensorname = {'meg','gra1','gra2'};
for cond = 1:2
    
    ChAngle = squeeze(angle(topoo(DIM,:,blos(cond,:),:)));
    ChAngle = permute(ChAngle,[3 2 1]);
    
    bloAngle = squeeze(ChAngle(:,1,:)-ChAngle(:,2,:));
    ChAngleDiff = mphase2(bloAngle,1);
    ChAngleDiff(ChAngleDiff>pi) = ChAngleDiff(ChAngleDiff>pi)-2*pi;
    xx = reshape(ChAngleDiff,3,size(ChAngleDiff,2)/3);
    xx = squeeze(mphase2(xx,1));
    xx(xx>pi) = xx(xx>pi)-2*pi;
    xx = xx/pi*180;
    
    figure('color',[1 1 1]);
    subplot(1,2,1)
    PKUtopoGradOutline(xx,5);
    caxis([-180 180]);colormap(colorrange);colorbar
    title([condname{cond}])
    
    %ͳͨλ
    subplot(1,2,2)
    ADCall = mphase2(bloAngle,1);
    polar(0,100,'-k');hold on
    rose(ADCall,40);
    legend('all')
    title([condname{cond} '-sensor']);
    
end

%%

DIMs = [triLen+1 2*triLen+1];
clear ResP
for dm = 1:size(DIMs,2)
    DIM = DIMs(dm);
    ResP(:,:,dm) = topoP(DIM,:,:);
end
ResP = permute(ResP,[2,1,3]);
ResP = double(ResP);
% ResP = 10*log(ResP);

pos = [1 2 3 4];
figure('color',[1 1 1]);
for dm = 1:2
    subplot(1,2,dm);hold on
    bar_errorbar_func([1 2 3 4],ResP(:,:,dm)',[0 0 0]);
    set(gca,'xtick',[0:5]);set(gca,'xticklabel',{' ','A-s','A-d','R-s','R-d',' '});xlim([0 5]) 
    set(gca,'yscale','log');ylabel('power');set(gca,'ytick',[1e-27 1e-26 1e-25 1e-24]);ylim([1e-27 1e-24])
    title([num2str(dm) '-Hz'])
end







