% This function generates points along the cell periphery for graphical output.
%
% INPUT: 
% Cell_Radii: radius of the cell in xyz directions
% Cell_ShapeFactor: cell shape factor in xyz directions
%
% OUTPUT:
% [x, y, z]: position of points along the cell periphery
%
% LAST UPDATE:
% 09/07/2020
% Reza Farhadifar (rfarhadifar@flatironinstitute.org)

function [x, y, z] = CellShape(Cell_Radii, Cell_ShapeFactor)

M = 2./Cell_ShapeFactor;
Cell_Radii = 0.999 * Cell_Radii;
n = 500;

v = linspace(-pi/2, pi/2,n);
u = linspace(-pi,pi,n);
[V, U] = meshgrid(v,u);
cosV = cos(V);
sinV = sin(V);
cosU = cos(U);
sinU = sin(U);
cosV(:,[1 n]) = 0;
sinU([1 n],:) = 0;
x = Cell_Radii(1).*sign(cosV).*abs(cosV).^M(1) .* sign(cosU).*abs(cosU).^M(1);
y = Cell_Radii(2).*sign(cosV).*abs(cosV).^M(2) .* sign(sinU).*abs(sinU).^M(2);
z = Cell_Radii(3).*sign(sinV).*abs(sinV).^M(3);


