% This function updates the positions and velocities of centrosomes.
%
% INPUT: 
% Cent_Force: total force from cortical force-generators on centrosomes
% Cent_Pos: position of centrosomes
% Cent_Drag: drag coefficient on centrosomes
% deltat: time step
%
% OUTPUT:
% Cent_Pos: position of centrosomes
% Cent_Vel: velocity of centrosomes
%
% LAST UPDATE:
% 09/07/2020
% Reza Farhadifar (rfarhadifar@flatironinstitute.org) 

function [Cent_Pos, Cent_Vel] = update_CentPosVel (Cent_Force, Cent_Pos, Cent_Drag, deltat)

R1 = Cent_Pos(1, :); R2 = Cent_Pos(2, :);
F1 = Cent_Force(1,:); F2 = Cent_Force(2,:);

Rc = R1+R2;
Ro = R1-R2;
S = Ro./vecnorm(Ro);

Fc = F1+F2;
Vc = Fc/Cent_Drag(1);
Rc = Rc + Vc*deltat;

Fo = F1-F2;
fric = (Cent_Drag(1)*eye(3)+2*Cent_Drag(2)*(S'*S));
Vo = (fric\Fo')';
Ro = Ro + Vo*deltat;

R1 = 0.5*(Rc + Ro);
V1 = 0.5*(Vc + Vo);
R2 = 0.5*(Rc - Ro);
V2 = 0.5*(Vc - Vo);

Cent_Vel = [V1; V2];
Cent_Pos = [R1; R2];


