% This function calculates forces on centrosomes.
%
% INPUT:
% Cent_Pos: position of centrosomes
% CFG: cortical force-generator configuration
% CFG_P: probability of attachment of a microtubule to force-generators
% CFG_F0: maximum pulling force exerted by occupied force-generator
%
% OUTPUT:
% F: force on centrosomes
%
% LAST UPDATE:
% 09/07/2020
% Reza Farhadifar (rfarhadifar@flatironinstitute.org) 

function Cent_Force = update_Force(Cent_Pos, CFG, CFG_P, CFG_F0)

CFG_Pos = CFG(:, 1:3);
kesi1 = CFG_Pos - Cent_Pos(1, :);
kesi1 = kesi1./vecnorm(kesi1, 2, 2);
kesi2 = CFG_Pos - Cent_Pos(2, :);
kesi2 = kesi2./vecnorm(kesi2, 2, 2);

f1 = CFG_F0.*CFG_P(:, 1).*kesi1;
f2 = CFG_F0.*CFG_P(:, 2).*kesi2;
Cent_Force = [sum(f1); sum(f2)];