/* Macro to analyze nuclear import based on segmentation of nuclei from DAPI/Hoechst channel 
   and cytoplasm from Mitotracker channel

		C00 DAPI
		C01 mitotracker
		C02 cargo 
*/

if (isOpen("Results")){

        selectWindow("Results");    

		run("Close"); } 

//Give a chamber directory, then it will loop over all fields

chamberDir =  getDirectory("Choose your input folder");

list_fields = getFileList(chamberDir);

Array.sort(list_fields);

count = 0;

for (j=0; j<list_fields.length-1; j++) {

	run("Bio-Formats Importer", "open=" + chamberDir + list_fields[j] +

	" autoscale color_mode=Default crop rois_import=[ROI manager] split_channels view=Hyperstack stack_order=XYCZT");

	selectWindow(list_fields[j] + " - C=0"); // DAPI channel

	getDimensions(w, h, channels, slices, frames);

	// first mask: nucleus

	run("Gaussian Blur...", "sigma=4 stack");

	run("Remove Outliers...", "radius=10 threshold=0 which=Bright stack");  

	run("Square Root", "stack");   // Reduces intensity differences so thresholding works better

	setAutoThreshold("Default dark");

	run("Convert to Mask", "method=Default background=Dark calculate");

	run("Fill Holes", "stack");

	run("Duplicate...", "title=mask1 duplicate"); mask1=getImageID(); 

	run("Duplicate...", "title=mask3 duplicate"); mask3=getImageID(); 

	selectWindow(list_fields[j] + " - C=0"); 

	run("Watershed", "stack");

	run("Options...", "iterations=3 count=1 edm=Overwrite"); 

	run("Erode", "stack");

	// second mask: nuclear envelope

	selectImage(mask1);   

	run("Watershed", "stack");

	imageCalculator("Subtract stack", mask1, list_fields[j] + " - C=0");  //use the nuclear image to subtract

	selectImage(mask3); // used to compute mask outside nucleus

	run("Median...", "radius=2");

	run("Options...", "iterations=2 count=1 edm=Overwrite"); // erosion and dilation will be performed 2 times

	run("Dilate", "stack");

	 
	//third mask: cytoplasm

	selectWindow(list_fields[j] + " - C=1"); // Mitotracker / cytoplasm channel

	run("Duplicate...", "title=mask2 duplicate"); mask2=getImageID(); 

	run("Gaussian Blur...", "sigma=4 stack");

	run("Remove Outliers...", "radius=10 threshold=0 which=Bright stack");  

	run("Square Root", "stack");  

	setAutoThreshold("Default dark");

	run("Convert to Mask", "method=Default background=Dark calculate");

	run("Fill Holes", "stack");  

	imageCalculator("Subtract stack", mask2, mask3); 

	// measure intensity of masked images

	selectWindow(list_fields[j] + " - C=0"); 

	run("Divide...", "value=255.000 stack");

	imageCalculator("Multiply create stack", list_fields[j] + " - C=2",list_fields[j] + " - C=0");

	// measure in all thresholded areas

	if (j==0){

	makeRectangle(0, 0, w, h); 
	run("ROI Manager...");

	roiManager("Add");}

	roiManager("Select", 0);

	run("Set Measurements...", "area mean min integrated stack limit redirect=None decimal=3");

	setAutoThreshold("Triangle dark");

	roiManager("multi-measure measure_all append");


	selectImage(mask1);   

	run("Divide...", "value=255.000 stack");

	imageCalculator("Multiply create stack", list_fields[j] + " - C=2", mask1);

	roiManager("Select", 0);

	run("Set Measurements...", "area mean min integrated stack limit redirect=None decimal=3");

	setAutoThreshold("Triangle dark");

	roiManager("multi-measure measure_all append");


	selectImage(mask2);   

	run("Divide...", "value=255.000 stack");

	imageCalculator("Multiply create stack", list_fields[j] + " - C=2", mask2);

	roiManager("Select", 0);

	run("Set Measurements...", "area mean min integrated stack limit redirect=None decimal=3"); 

	setAutoThreshold("Triangle dark");

	roiManager("multi-measure measure_all append");
	

	for (i=0; i<frames; i++) {

	print(j,"	", list_fields[j], "	", getResult("Slice", nResults-3*frames+i), "	", getResult("Mean", nResults-3*frames+i), "	", getResult("Mean", nResults-2*frames+i), "	", getResult("Mean", nResults-frames+i), 

	 "	", getResult("Area", nResults-3*frames+i), "	", getResult("Area", nResults-2*frames+i) , "	", getResult("Area", nResults-frames+i) );

   } 

	updateResults;
	
	run("Close All");
	
	run("Options...", "iterations=1 count=1 edm=Overwrite"); // reset to 1
}


// save measurements in a file

selectWindow("Log");  //select Log-window

saveAs("Text", chamberDir+"\\results"); // save results from log
