function [MSD] = DoMSD_Blink(Ided,truncation)
    %%%%%%%%%%%%%%%%%
    % allMovies=guidata (findobj('tag','dataFig'));
    % Ided = allMovies.Movie1.Tracks;
    % truncation = 10;
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %input : ided, truncation
    %ouput : MSD=[MSD, Lag, particule, SEMerror]

    Ided = sortrows(Ided,[4 3]); % sort by particle id and then ascending time
    MSD=[]; msd=[];

    for whichparticles= 1:Ided(end,4)
      revelantwich = find(Ided(:,4)== whichparticles);
        if size(revelantwich,1) > 0    
            position = find(Ided(:,4) == whichparticles);
            ided = Ided(position(1):position(end),:);

            %% Boucle de calcul msd
            msd=[]; error=[];
            for dt=1:truncation
                displacement=[]; j=1;
                for i=1:size(ided,1)
                   frame =  ided(i,3);

                   %dternime si le frame+dt existe ou pas;si oui, calcule le
                   %displacement
                    if isempty(ided(find(frame+dt==ided(:,3)),:)) ~= 1
                        id  = ided(find(frame+dt==ided(:,3)),:);
                        displacement(j)= (ided(i,1)-id(1))^2 + (ided(i,2)-id(2))^2;
                        j=j+1;
                    end

                % calcul des erreurs selon Quian biophys j. N=nombre tot de
                % frames. doit terminer....
    %                 if i<= N/2
    %                     error(i,1) = sqrt((4*i^2*(N-i)+2*(N-i)+i-i^3)/(6*(N-i)^2));
    %                 elseif i > N/2
    %                     error(i,1) = sqrt(1+((N-i)^3-4*i*(N-i)^2+4*i-(N-i))/(6*i^2*(N-i)));
    %                 end
                end
                
            msd(dt,:)= [sum(displacement)/ size(displacement,2) dt whichparticles std(displacement)/sqrt(size(displacement,2))];
            %MSDwich = [Lag msd error ones(N-1,1)*whichparticles];
    %                  pause
            end
    MSD = [MSD; msd];
        end
    end
% save MSD MSD
end


