function  [Projection,Projection2] = f_Makeprojection_V3(FileName1,numtimepoint)
%%
% in : read zstack in .stk ou.tiff
% compute :
%    Addition des images au temps t
% ouput :
%     save Projection in .tiff .mat
%     Projection,Projection2

%%
% [FileName1,PathName] = uigetfile('*.stk','Select the first MultiTif file');
% cd(PathName)
% [FileName2,PathName] = uigetfile('*.stk','Select the first SEP MultiTif file');
% numtimepoint =1;

%%
if exist([FileName1(1:end-7) '_Projection.tif']) > 0
    button = questdlg('Analysed Images found. Do analysis again?','','No');
    if strcmp(button, 'No')
        Projection = tiffread([FileName1(1:end-7) '_Projection.tif']);
        %         Projection2 = tiffread([FileName2(1:end-7) '_Projection_align.tif']);
        clc
        return
    else
        delete([FileName1(1:end-7) '_Projection.tif'])
    end
end

h = waitbar(0,'Time point...');
for i=1:numtimepoint
    FileNames1  = [FileName1(1:end-5) num2str(i) '.TIF'];
    I = tiffread(FileNames1);

    %make projection
    sizeX = size((I(1).data), 1);
    sizeY = size((I(1).data), 2);
    Imax = I(1).data;
    for a=1 : numel(I)-1
        frameAdd = I(a+1).data;
        for k =1 : sizeX
            for j=1: sizeY
                if frameAdd(k, j) > Imax(k, j)
                    Imax (k,j) = frameAdd(k,j);
                end
            end
        end
    end
    figure(10)
    imshow(Imax,[])
    text(10,10,['Frame= ' num2str(i)],'color','w')
    Projection(i).data= Imax;
    waitbar(i/numtimepoint)
end
close(h)

%%
% Get max intensity and rescale movie and write to 16 Bits Image for channel 1.
% Projection = Ifoc;
% maxs = [];
% for i=1:numel(Projection)
%     maxi = max(Projection(i).data(:));
%     maxs = [maxs ; maxi];
% end
% pixelmax = max(maxs);
% for i=1:numel(Projection)
%     Projection(i).data = uint16((Projection(i).data /pixelmax) *(2^16));
% %     imwrite(Projection(i).data,[FileName1(1:end-7) '_Projection.tif'],'tif','Compression','none','WriteMode','append')
% end

% % Get max intensity and rescale movie and write to 16 Bits Image for channel 2.
% Projection2 = Ifoc2;
% maxs = [];
% for i=1:numel(Projection2)
%     maxi = max(Projection2(i).data(:));
%     maxs = [maxs ; maxi];
% end
% pixelmax = max(maxs);
% for i=1:numel(Projection2)
%     Projection2(i).data = uint16((Projection2(i).data /pixelmax) *(2^16));
% %     imwrite(Projection2(i).data,[FileName2(1:end-7) '_Projection.tif'],'tif','Compression','none','WriteMode','append')
% end

%Align images

% if get(findobj('tag','alignImagesh'),'Value')
%     [Projection] = StackAlignment_1channel(Projection);
% end
%save aligned images
% si 1 canal... pas la meilleure faon....
%     if strcmp(FileName1(1:end-7),FileName2(1:end-7))
%         for i=1:numel(Projection)
%             imwrite(Projection(i).data,[FileName1(1:end-7) '_Projection_align.tif'],'tif','Compression','none','WriteMode','append')
%         end
%     else
h = waitbar(0,'Writing images...');
for i=1:numel(Projection)
    imwrite(Projection(i).data,[FileName1(1:end-7) '_Projection.tif'],'tif','Compression','none','WriteMode','append')
    %             imwrite(Projection2(i).data,[FileName2(1:end-7) '_Projection_align.tif'],'tif','Compression','none','WriteMode','append')
    waitbar(i/numel(Projection))
end
close(h)
close(10)
end
