%fitMSD

function [D,offset,L,v,PARAM] = fitMSD(MSD,FitType, xyres, tres, Dmin);

% FitType = Free or Confined
% Dmin = str2double(inifile(strcat([Filename,'.ini']), 'read', {Filename,'Definitions','Dmin'}));
%%%%%%%%%%%%%%%%%%%%%%%%%
% load MSD
% xyres = 0.254     ;
% tres = 0.05;
% whichparticles= 1;
% FitType = 'Free';
% Dmin = 0.0075;
%%%%%%%%%%%%%%%%%%%%%%%%%
D=[]; L=[]; offset=[]; v=[];
for whichparticles= 1:MSD(end,3)
   revelantwich = find(MSD(:,3)== whichparticles);
 
       if size(revelantwich,1) > 1
        Dwhich=[];
        offseti =[];
   
        position = find(MSD(:,3) == whichparticles);
        ided = MSD(position(1):position(end),:);
        msd = ided(:,1);
        Lag = ided(:,2);
%         error = ided(:,3); 

% %
        if strcmp(FitType, 'Confined')

           % nonlinear regression
           %
           options=optimset('Display', 'Off');
           msdl = msd(1:6,1);
           Lagl = Lag(1:6,1);
           ini = [(msdl(2)-msdl(1))/(Lagl(2)-Lagl(1)) msdl(1)/2];
           [PARAMlinear] = lsqcurvefit(@modelfree,ini,Lagl,msdl,[0 0],[4 msdl(1)],options);
%             PARAMlinear(1)= Dinst;
%             PARAMlinear(2)=offset;
            
            ini = [2*msd(end) PARAMlinear(1)  PARAMlinear(2)];
            [PARAM] = lsqcurvefit(@GenericConfinedOffset4,ini,Lag,msd,[],[],options);
            % change units
            %L = PARAM(1)*xyres;
            %Dmicro = PARAM(2)*xyres^2/tres;
  
%             StdDmicro = Deviations(3)*xyres^2/tres
            Offseti = PARAM(3)*xyres^2;
            Lwhich = PARAM(1)*xyres;
            Dwhich = PARAM(2)*xyres^2/tres;
            D=[D;Dwhich];
            L=[L;Lwhich];
            offset = [offset; Offseti];
            
            %plot
            msdFit=[];
            figure (1)
            for i=1:size(msd,1)
            msdFit(i) = 2*PARAM(2)^2*(1-exp(-Lag(i)*4*PARAM(3)/2/PARAM(2)^2));
%             msdFit(i) = PARAM(1)+2*PARAM(2)^2*(1-exp(-Lag(i)*4*PARAM(3)/2/PARAM(2)^2));
            end
%             hold on
            plot(Lag*tres,msdFit*xyres^2,'-g')
            errorbar(Lag*tres,msd*xyres^2,(error*xyres^2),'.b')
            hold off
           % pause
% % 
       elseif strcmp(FitType, 'ActiveTransport')
            % ini = [(msd(2)-msd(1))/(Lag(2)-Lag(1)) msd(1)/2 msd(1)/2];
            p = polyfit(Lag,msd,2);
           
            Dwhich = (p(2)/4)*xyres^2/tres;
                if Dwhich < 0
                    Dwhich = 0;
                end
            D=[D;Dwhich];
            
            vwhich = (p(1))*xyres/tres; 
            v=[v;vwhich];
            
            offseti = p(3)*xyres^2;
            offset = [offset; offseti];
% %            
       elseif strcmp(FitType, 'Free')

 %nlinfit....
%            ini = [(msd(2)-msd(1))/(Lag(2)-Lag(1)) msd(1)/2];
%            statsset = statset('MaxIter',100, 'TolFun' , 1e-8,'Display','off',  'FunValCheck', 'on','Robust','on','WgtFun','bisquare');
%            [PARAM] = nlinfit(Lag,msd,@modelfree,ini,statsset);
                  
%lsqcurvefit
           options=optimset('Display', 'Off');
           ini = [(msd(2)-msd(1))/(Lag(2)-Lag(1)) msd(1)/2];
           Lag4 = Lag(1:4,:);
           msd4 = msd(1:4,:);
%             Diffusion_Min = (0.00005*tres)/((xyres)^2);
            Diffusion_Min = (0.00001*tres)/((xyres)^2);
           [PARAM] = lsqcurvefit(@modelfree,ini,Lag4,msd4,[],[],options);
           Dwhich = PARAM(1)*xyres^2/tres;
%            if Dwhich <= 0
%               Dwhich = 0;
%            end
           offseti= (sqrt(PARAM(2)/8))*xyres;
           
            

%             %plot
%             figure (19)
%             plot(Lag*tres,msd.*xyres^2,'ob')
            msdFit=[];
            for i=1:size(msd,1)
                msdFit(i) = (PARAM(1)*4*Lag(i)+ PARAM(2));
            end
            
%             hold on
%                 plot(Lag*tres,msdFit*xyres^2,'-xr')
% 
                mActive = sum(msd(6:end)) - sum(msdFit(6:end));
                [h,p]=ttest(msd(5:end), msdFit(5:end)');
%                 [h,p] = kstest2(msd(6:end), msdFit(6:end)');
%                 [p,h] = ranksum(msd(5:end),msdFit(5:end)');
                if p<0.1 && mActive > 0
%                    legend('Active!!')
                   active = 1;
                else
%                     legend('Stationary')
                    active = 0;
                end
                
% active =input('Active (1) or not (0) ');

                Dwhich = [Dwhich active];
                D=[D;Dwhich];
                offset = [offset; offseti];

% pause
% close(19)
        end
  end     
end
%   close(19)     
% end