'''
Created on Aug 17, 2016

@author: Nao
'''
from ImportList import *
from ImportListForCell import *
from Cells import *
from CellsComparor import *
from os import listdir

saveLoc = '/Users/naorho/Downloads'

top = 'OFF_SAC.xml' # switch two
bot = 'ON_SAC.xml'

test = '/Users/naorho/Downloads/test.xml'

# 1. Basics

cell = Cells(test) # initialize cells. It has a lot of other options, but, for general purposes,
                    #they do not need to be known. All the coordinates are converted to nm.
topCell = Cells(top) #initalize top cells.
botCell = Cells(bot) #initialize bot cells.

coef = topCell.getCoefInfo().values()[0] # This fits a plane to the cell and return its normal vector + position of the normal vector; in other words, it returns the normal vector of affine plane. It uses 3D square fitting.
###for example, [.5, .5, -1, 234] means that the original equation is .5 z + 0.5 y - x + 234 = 0.
cells.changeCoordinate(coef) # changes coordinates; it changes coordinates in a way that, now, the said affine plane vector is its new x axis. It generates a unitary matrix and multiply every points with that, meaning it preserves the unit volume.

# 2. Lets learn about options in Python!
#Lets take a look at function getMidPoint.
"""
def getMidPoint(self, onlyX = False, Average = True, Node = True, keyword = None):
    if not (self.NCBEboolean[0]):
        raise Exception("This cell does not have nodes.")
        avgDict = {}
        nodeDict = {}
        if Node:
            nodeDict = self.Nodes
    else:
        if keyword == None:
            nodeDict = self.Comments
            else:
                nodeDict = self.commentWithKeywordExtractDict(keyword)
for name in nodeDict.keys():
    nodeList = nodeDict[name]
    
    avgDict.setdefault(name)
        
        if len(nodeList) == 0:
            if onlyX:
                avgDict[name] ="None"
                else:
                    avgDict[name]= ["None", "None", "None"]
        else:
            if Average:
                if onlyX:
                    avgDict[name] = getAvgPoint(nodeList)[2]
                    else:
                        avgDict[name] = getAvgPoint(nodeList)
                else:
                    if onlyX:
                        #print nodeList
                        avgDict[name] = getMedianPoint(nodeList)[2]
                    else:
                        avgDict[name] = getMedianPoint(nodeList)
return avgDict
"""
#Now, in Python, Functions have default values. In getMidPoint function, onlyX is setup to be False.
print cells.getMidPoint() # This function will print out the same thing as getMidPoint(False, True, True, None)
print cells.getMidPoint(Node = False) #Now, in python, you can set up only one option to be something that is not default. Now, this will return a value equivalent to getMidPoint(Flase, True, Flase, None)
# If you do not declare variables explicitly, then it will take variables sequentially. For example,
print cells.getMidPoint(False, False, False) #this will set onlyX = False, Average = False, and Node = False.
#Now, we should learn more about all the functions I created.

# 3. Accessing raw datas.
# In some cases, you need to access the raw data of the Cells object. For example, you can print out the entire skeletal nodes by:
print cells.Nodes # it is formmated this way: Nodes { cell: [z y x id cellName]}. It is a dictionary of list of list.
"""
Here are lists of raw datas that you can access in similar way.

Nodes { cell: [z y x id cellName]}     # all the skeletal nodes
Comments { cell: [z y x id cellName comment]}  # all the comments
Edges { cell: [target source]}  # all the edges
Branches { cell: [z y x id cellName branchpoint]}  # all the branch points
Names [name of cell]  # all the name of cells
scale: [z y x]  # scale factor of these cells.
"""
# Here is an application.
"""
def skeletonPrinter1(saveLoc,top, bot, NOSsCells): # you can find this code in CellsComparor.py
    NOSs = Cells(NOSsCells)
    topCell = Cells(top)
    botCell = Cells(bot)        # I declared cells.
    
    coef = topCell.getCoefInfo().values()[0]
    NOSs.changeCoordinate(coef)           # I changed the coordinates.
    NOSs.cutByXSkeletons(None, 25)            # I will explain this later on. It is irrelevant now.
    Skeletons = NOSs.Nodes                    # Pull out the skeleton nodes from the data structure.
    
    for cellname in Skeletons:                  # loop over all the cells.
    with open( saveLoc + "/"+ cellname +".csv", 'wb') as csvfile:   # write CSV file
            fieldnames = [ 'x']
            writer = csv.DictWriter(csvfile, fieldnames = fieldnames )
            writer.writerow({'x':'x' })
            
            for node in Skeletons[cellname]:    # print out every nodes on CSV file.
                writer.writerow({'x': node[2] })
"""
print cells.Nodes["somecells"] # this will print out the list of list of skeletal node of "somecells".


# 4. Functions.
# These functions will be used often.

# 4.1 Here are functions that are close to extracting raw data with few processings. Thiese functions are extremely crucial and if you find an error, please report them to me.

print cells.commentWithKeywordExtractDict(key1= None) # This will return dictionary of comments like raw data Comments except it throws away values comments of which do not include keywords given. If key1 = None, then it just returns cells.Comments. Also, if you set key1 = ["dsda","sds"] or any arbitary list. That will return the dictionary of comments with only comments that contains 1 or more of those keywords in the list.

# 4.2 These functions return the analyzed numbers from the raw data.

print cells.getMidPoint( onlyX = False, Average = True, Node = True, keyword = None)
# onlyX = True will return a dictionary of a single digits of avg/median of x points. False will return a dictionary of list of avg/medians of all the coordinates in this way [z_avg y_avg x_avg]
#Average = True will set the value to be average. False will return the median, instead of average.
#Node variable determines whether I am going to use skeleton or comments.
#True will let us use only skeletons. False will let us use only comments.
#Now, if you decided to use only comments, then keyword will let you use which comments to use. For example, if you set keyword = "Outputs", then this code will let you use only comments that include the word "Outputs". If you set keyword = None, it will use every comments.

print cells.getDeviation(StandardDeviation = True, Node = True, keyword = None)
# This function is similar to the one above.
#StandardDeviation = True will set the value to be Standard Deviation. False will return the Absolute Deviation, instead of average.
#Node variable determines whether I am going to use skeleton or comments.
#True will let us use only skeletons. False will let us use only comments.
#Now, if you decided to use only comments, then keyword will let you use which comments to use. For example, if you set keyword = "Outputs", then this code will let you use only comments that include the word "Outputs". If you set keyword = None, it will use every comments.

print cells.toArea(Nodes = True, keyword = None)# this will return a dictionary of area of convex hull of projection of cell objects on yz plane. I recommend you to use it after changeCoordinate or it is meaningless.
#Node variable determines whether I am going to use skeleton or comments.
#True will let us use only skeletons. False will let us use only comments.
#Now, if you decided to use only comments, then keyword will let you use which comments to use. For example, if you set keyword = "Outputs", then this code will let you use only comments that include the word "Outputs". If you set keyword = None, it will use every comments.

print toConvexHull(Nodes = True, keyword = None, printCSV = False, saveLocation = None, group = False)
# this will return a dictionary of convex hull for each cell AND it can print out CSV containing convex hulls.
#Node variable determines whether I am going to use skeleton or comments.
#True will let us use only skeletons. False will let us use only comments.
#Now, if you decided to use only comments, then keyword will let you use which comments to use. For example, if you set keyword = "Outputs", then this code will let you use only comments that include the word "Outputs". If you set keyword = None, it will use every comments.
# printCSV determines whether it prints out CSV files of them or not. If True, print the CSV files. If not, it will not.
# saveLocation determines where it will save the file. It must be provided or it will throw errors.
# group = False will print out individual convex hulls. If group = True will print out every convex hulls into one single CSV file. Consequenty, printCSV and group must be both True or it will throw error.

# 4.3 These functions convert Cells object to other data type.

cells.toXML("example.xml")# this prints out the Cells object to xml file. If the specific directory is not included in the name, it will print out to where tutorials.py is. This will save every modification you made to the cell.

cells.toMultiXML("saveDirectory") # this will rip off the cells and print each of cell into the savedirectory with its name. Be careful, because it will print out 50~100 cells to your directory depending on how much cells the cells object has in its structure.

cells.toVTK(fileLoc, commentonlyToo = True, keyForComment = None, Commentcolor = "0.500000", skeletonColor = "0.000000") # This function will print out the VTK files of the cells object. It saves multiple VTK files of each cell to fileLoc. You must provide one.
# if commentonlyToo = True, it prints out comments files as well. If False, it will only print out VTKs of Skeletons.
# if commentOnlyToo = True is provided, then we can use keyForComment.  keyForComment will determine which comments to print out. For example, if you set keyForComment = "Outputs", then this code will let you use only comments that include the word "Outputs". If you set keyForComment = None, it will use every comments.
# Commentcolor and skeletalColor have default values of 0.5 and 0.0 respectively, but you can change it to some values between 0 and 1.

cells.toVTKcomment(fileLoc, CommentColorDict) # This function will print out the VTK files of only comments of the cells object and it will throw away comments that is not on CommentColorDict. It saves VTK files to fileLoc. You must provide one. CommentColorDict can be something like {"input":"0.1000", "output":"0.2000"}. This will print out comments of each cell in cells, which contain either "input" or "output". "input" will be colored 0.1 and "output" will be colored 0.2.

cells.toManyCells(NCBEboolean = [True, True, True, True]) # This one will return a dictionary of cells object, something like {cellname : cell object}. You do not have to worry about the option. You can just run:
cells.toManyCells() # this is useful, because sometime, you just want to run functions of Cells to single cell in cells object.

#4.4 These functions make changes to Cells object, so be careful using it.

cells.cutByXSkeletons(highPercent=None, lowPercent=None) # this will sort skeleton by x axis and trim off certain percentages of numbers of skeletal nodes. highPercentage will take off nodes with the biggest x axis and lowPercentage will take off nodes with the smallest x axis. These numbers should be between 0 and 100. If they are provided as None, then skeletal nodes will not be trimmed off.

cells.normalizeX(botcell, topcell, zeroToOne, extraFactor = 1) # this will normalize x axis of the cell using two plane cells such as OFFsac and ONsac. If zeroToOne is True, it will be normalized this way:node[2] = (topX - node[2])/( topX - botX).
# if zeroToOne is False, then it will be normalized this way:node[2] = (node[2] * 45 + 27.5) * extraFactor.






